/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.ResizePolicy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionHandles;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.gre.ViewMetadataRepository;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Node;

class SelectionItem {
    private LayoutCanvas mCanvas;
    private final CanvasViewInfo mCanvasViewInfo;
    private final Rectangle mRect;
    private final NodeProxy mNodeProxy;
    private ResizePolicy mResizePolicy;
    private SelectionHandles mHandles;

    public SelectionItem(LayoutCanvas canvas, CanvasViewInfo canvasViewInfo) {
        assert (canvasViewInfo != null);
        this.mCanvas = canvas;
        this.mCanvasViewInfo = canvasViewInfo;
        if (canvasViewInfo == null) {
            this.mRect = null;
            this.mNodeProxy = null;
        } else {
            Rectangle r = canvasViewInfo.getSelectionRect();
            this.mRect = new Rectangle(r.x, r.y, r.width, r.height);
            this.mNodeProxy = this.mCanvas.getNodeFactory().create(canvasViewInfo);
        }
    }

    public boolean isRoot() {
        return this.mCanvasViewInfo.isRoot();
    }

    public boolean isHidden() {
        return this.mCanvasViewInfo.isHidden();
    }

    public CanvasViewInfo getViewInfo() {
        return this.mCanvasViewInfo;
    }

    public UiViewElementNode getUiNode() {
        return this.mCanvasViewInfo.getUiViewNode();
    }

    public Rectangle getRect() {
        return this.mRect;
    }

    NodeProxy getNode() {
        return this.mNodeProxy;
    }

    LayoutCanvas getCanvas() {
        return this.mCanvas;
    }

    static String getAsText(LayoutCanvas canvas, List<SelectionItem> selection) {
        StringBuilder sb = new StringBuilder();
        LayoutEditorDelegate layoutEditorDelegate = canvas.getEditorDelegate();
        for (SelectionItem cs : selection) {
            CanvasViewInfo vi = cs.getViewInfo();
            UiViewElementNode key = vi.getUiViewNode();
            Node node = key.getXmlNode();
            String t = layoutEditorDelegate.getEditor().getXmlText(node);
            if (t == null) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(t);
        }
        return sb.toString();
    }

    static SimpleElement[] getAsElements(List<SelectionItem> items) {
        return SelectionItem.getAsElements(items, null);
    }

    static SimpleElement[] getAsElements(List<SelectionItem> items, SelectionItem primary) {
        ArrayList<SimpleElement> elements = new ArrayList<SimpleElement>();
        if (primary != null) {
            CanvasViewInfo vi = primary.getViewInfo();
            SimpleElement e = vi.toSimpleElement();
            e.setSelectionItem(primary);
            elements.add(e);
        }
        for (SelectionItem cs : items) {
            if (cs == primary) continue;
            CanvasViewInfo vi = cs.getViewInfo();
            SimpleElement e = vi.toSimpleElement();
            e.setSelectionItem(cs);
            elements.add(e);
        }
        return elements.toArray(new SimpleElement[elements.size()]);
    }

    public boolean isLayout() {
        UiViewElementNode node = this.mCanvasViewInfo.getUiViewNode();
        if (node != null) {
            return node.getDescriptor().hasChildren();
        }
        return false;
    }

    public SelectionHandles getSelectionHandles() {
        if (this.mHandles == null) {
            this.mHandles = new SelectionHandles(this);
        }
        return this.mHandles;
    }

    public ResizePolicy getResizePolicy() {
        if (this.mResizePolicy == null && this.mNodeProxy != null) {
            this.mResizePolicy = ViewMetadataRepository.get().getResizePolicy(this.mNodeProxy.getFqcn());
        }
        return this.mResizePolicy;
    }
}

