/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.ResizePolicy;
import com.android.ide.common.api.SegmentType;
import com.android.utils.Pair;
import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.ControlPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.Gesture;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.Overlay;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionHandle;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.gre.RulesEngine;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.GC;

public class ResizeGesture
extends Gesture {
    private ResizeOverlay mOverlay;
    private LayoutCanvas mCanvas;
    private SelectionHandle mHandle;
    private NodeProxy mParentNode;
    private NodeProxy mChildNode;
    private DropFeedback mFeedback;
    private ResizePolicy mResizePolicy;
    private SegmentType mHorizontalEdge;
    private SegmentType mVerticalEdge;

    public ResizeGesture(LayoutCanvas canvas, SelectionItem item, SelectionHandle handle) {
        this.mCanvas = canvas;
        this.mHandle = handle;
        this.mChildNode = item.getNode();
        this.mParentNode = (NodeProxy)this.mChildNode.getParent();
        this.mResizePolicy = item.getResizePolicy();
        this.mHorizontalEdge = ResizeGesture.getHorizontalEdgeType(this.mHandle);
        this.mVerticalEdge = ResizeGesture.getVerticalEdgeType(this.mHandle);
    }

    @Override
    public void begin(ControlPoint pos, int startMask) {
        super.begin(pos, startMask);
        this.mCanvas.getSelectionOverlay().setHidden(true);
        RulesEngine rulesEngine = this.mCanvas.getRulesEngine();
        Rect newBounds = this.getNewBounds(pos);
        ViewHierarchy viewHierarchy = this.mCanvas.getViewHierarchy();
        CanvasViewInfo childInfo = viewHierarchy.findViewInfoFor(this.mChildNode);
        CanvasViewInfo parentInfo = viewHierarchy.findViewInfoFor(this.mParentNode);
        Object childView = childInfo != null ? childInfo.getViewObject() : null;
        Object parentView = parentInfo != null ? parentInfo.getViewObject() : null;
        this.mFeedback = rulesEngine.callOnResizeBegin(this.mChildNode, this.mParentNode, newBounds, this.mHorizontalEdge, this.mVerticalEdge, childView, parentView);
        this.update(pos);
        this.mCanvas.getGestureManager().updateMessage(this.mFeedback);
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        this.update(this.mCanvas.getGestureManager().getCurrentControlPoint());
        this.mCanvas.redraw();
        return true;
    }

    @Override
    public boolean keyReleased(KeyEvent event) {
        this.update(this.mCanvas.getGestureManager().getCurrentControlPoint());
        this.mCanvas.redraw();
        return true;
    }

    @Override
    public void update(ControlPoint pos) {
        super.update(pos);
        RulesEngine rulesEngine = this.mCanvas.getRulesEngine();
        Rect newBounds = this.getNewBounds(pos);
        int modifierMask = this.mCanvas.getGestureManager().getRuleModifierMask();
        rulesEngine.callOnResizeUpdate(this.mFeedback, this.mChildNode, this.mParentNode, newBounds, modifierMask);
        this.mCanvas.getGestureManager().updateMessage(this.mFeedback);
    }

    @Override
    public void end(ControlPoint pos, boolean canceled) {
        super.end(pos, canceled);
        if (!canceled) {
            RulesEngine rulesEngine = this.mCanvas.getRulesEngine();
            Rect newBounds = this.getNewBounds(pos);
            rulesEngine.callOnResizeEnd(this.mFeedback, this.mChildNode, this.mParentNode, newBounds);
        }
        this.mCanvas.getSelectionOverlay().setHidden(false);
    }

    @Override
    public Pair<Boolean, Boolean> getTooltipPosition() {
        return Pair.of((Object)(this.mHorizontalEdge != SegmentType.TOP ? 1 : 0), (Object)(this.mVerticalEdge != SegmentType.LEFT ? 1 : 0));
    }

    private Rect getNewBounds(ControlPoint pos) {
        LayoutPoint p = pos.toLayout();
        LayoutPoint start = this.mStart.toLayout();
        Rect b = this.mChildNode.getBounds();
        SelectionHandle.Position direction = this.mHandle.getPosition();
        int x = b.x;
        int y = b.y;
        int w = b.w;
        int h = b.h;
        int deltaX = p.x - start.x;
        int deltaY = p.y - start.y;
        if (deltaX == 0 && deltaY == 0) {
            return b;
        }
        if (this.mResizePolicy.isAspectPreserving() && w != 0 && h != 0) {
            double aspectRatio = (double)w / (double)h;
            int newW = Math.abs(b.w + (direction.isLeft() ? -deltaX : deltaX));
            int newH = Math.abs(b.h + (direction.isTop() ? -deltaY : deltaY));
            double newAspectRatio = (double)newW / (double)newH;
            if (newH == 0 || newAspectRatio > aspectRatio) {
                deltaY = (int)((double)deltaX / aspectRatio);
            } else {
                deltaX = (int)((double)deltaY * aspectRatio);
            }
        }
        if (direction.isLeft()) {
            int nx1 = b.x + deltaX;
            int x2 = b.x + b.w;
            if (nx1 <= x2) {
                x = nx1;
                w = x2 - x;
            } else {
                w = 0;
                x = x2;
            }
        } else if (direction.isRight()) {
            int nx2 = b.x + b.w + deltaX;
            w = nx2 >= b.x ? nx2 - b.x : 0;
        } else assert (direction == SelectionHandle.Position.BOTTOM_MIDDLE || direction == SelectionHandle.Position.TOP_MIDDLE);
        if (direction.isTop()) {
            int ny1 = b.y + deltaY;
            int y2 = b.y + b.h;
            if (ny1 < y2) {
                y = ny1;
                h = y2 - y;
            } else {
                h = 0;
                y = y2;
            }
        } else if (direction.isBottom()) {
            int ny2 = b.y + b.h + deltaY;
            h = ny2 >= b.y ? ny2 - b.y : 0;
        } else assert (direction == SelectionHandle.Position.LEFT_MIDDLE || direction == SelectionHandle.Position.RIGHT_MIDDLE);
        return new Rect(x, y, w, h);
    }

    private static SegmentType getHorizontalEdgeType(SelectionHandle handle) {
        switch (handle.getPosition()) {
            case BOTTOM_RIGHT: 
            case BOTTOM_MIDDLE: 
            case BOTTOM_LEFT: {
                return SegmentType.BOTTOM;
            }
            case RIGHT_MIDDLE: 
            case LEFT_MIDDLE: {
                return null;
            }
            case TOP_MIDDLE: 
            case TOP_RIGHT: 
            case TOP_LEFT: {
                return SegmentType.TOP;
            }
        }
        assert (false) : handle.getPosition();
        return null;
    }

    private static SegmentType getVerticalEdgeType(SelectionHandle handle) {
        switch (handle.getPosition()) {
            case BOTTOM_LEFT: 
            case LEFT_MIDDLE: 
            case TOP_LEFT: {
                return SegmentType.LEFT;
            }
            case TOP_MIDDLE: 
            case BOTTOM_MIDDLE: {
                return null;
            }
            case TOP_RIGHT: 
            case RIGHT_MIDDLE: 
            case BOTTOM_RIGHT: {
                return SegmentType.RIGHT;
            }
        }
        assert (false) : handle.getPosition();
        return null;
    }

    @Override
    public List<Overlay> createOverlays() {
        this.mOverlay = new ResizeOverlay();
        return Collections.singletonList(this.mOverlay);
    }

    private class ResizeOverlay
    extends Overlay {
        private ResizeOverlay() {
        }

        @Override
        public void paint(GC gc) {
            if (ResizeGesture.this.mChildNode != null && ResizeGesture.this.mFeedback != null) {
                RulesEngine rulesEngine = ResizeGesture.this.mCanvas.getRulesEngine();
                rulesEngine.callDropFeedbackPaint(ResizeGesture.this.mCanvas.getGcWrapper(), ResizeGesture.this.mChildNode, ResizeGesture.this.mFeedback);
            }
        }
    }
}

