/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import org.eclipse.andmore.internal.editors.layout.gle2.CanvasTransform;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.Overlay;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtDrawingStyle;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class OutlineOverlay
extends Overlay {
    private final ViewHierarchy mViewHierarchy;
    private Color mOutlineColor;
    private CanvasTransform mVScale;
    private CanvasTransform mHScale;

    public OutlineOverlay(ViewHierarchy viewHierarchy, CanvasTransform hScale, CanvasTransform vScale) {
        this.mViewHierarchy = viewHierarchy;
        this.mHScale = hScale;
        this.mVScale = vScale;
    }

    @Override
    public void create(Device device) {
        this.mOutlineColor = new Color(device, SwtDrawingStyle.OUTLINE.getStrokeColor());
    }

    @Override
    public void dispose() {
        if (this.mOutlineColor != null) {
            this.mOutlineColor.dispose();
            this.mOutlineColor = null;
        }
    }

    @Override
    public void paint(GC gc) {
        CanvasViewInfo lastRoot = this.mViewHierarchy.getRoot();
        if (lastRoot != null) {
            gc.setForeground(this.mOutlineColor);
            gc.setLineStyle(SwtDrawingStyle.OUTLINE.getLineStyle());
            int oldAlpha = gc.getAlpha();
            gc.setAlpha(SwtDrawingStyle.OUTLINE.getStrokeAlpha());
            this.drawOutline(gc, lastRoot);
            gc.setAlpha(oldAlpha);
        }
    }

    private void drawOutline(GC gc, CanvasViewInfo info) {
        Rectangle r = info.getAbsRect();
        int x = this.mHScale.translate(r.x);
        int y = this.mVScale.translate(r.y);
        int w = this.mHScale.scale(r.width);
        int h = this.mVScale.scale(r.height);
        gc.drawRectangle(x, y, w + 1, h + 1);
        for (CanvasViewInfo vi : info.getChildren()) {
            this.drawOutline(gc, vi);
        }
    }
}

