/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasTransform;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.ControlPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.DropGesture;
import org.eclipse.andmore.internal.editors.layout.gle2.GlobalCanvasDragInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.OutlinePage;
import org.eclipse.andmore.internal.editors.layout.gle2.Overlay;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleXmlTransfer;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.andmore.internal.editors.layout.gre.NodeFactory;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.gre.RulesEngine;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class MoveGesture
extends DropGesture {
    private LayoutCanvas mCanvas;
    private MoveOverlay mOverlay;
    private static final boolean DEBUG = false;
    private CanvasViewInfo mCurrentView;
    private SimpleElement[] mCurrentDragElements;
    private NodeProxy mTargetNode;
    private DropFeedback mFeedback;
    private NodeProxy mLeaveTargetNode;
    private DropFeedback mLeaveFeedback;
    private CanvasViewInfo mLeaveView;
    private final GlobalCanvasDragInfo mGlobalDragInfo;

    public MoveGesture(LayoutCanvas canvas) {
        this.mCanvas = canvas;
        this.mGlobalDragInfo = GlobalCanvasDragInfo.getInstance();
    }

    @Override
    public List<Overlay> createOverlays() {
        this.mOverlay = new MoveOverlay();
        return Collections.singletonList(this.mOverlay);
    }

    @Override
    public void begin(ControlPoint pos, int startMask) {
        super.begin(pos, startMask);
        this.mCanvas.getSelectionOverlay().setHidden(true);
    }

    @Override
    public void end(ControlPoint pos, boolean canceled) {
        super.end(pos, canceled);
        this.mCanvas.getSelectionOverlay().setHidden(false);
        this.mCanvas.getSelectionManager().syncOutlineSelection();
    }

    @Override
    public void dragEnter(DropTargetEvent event) {
        SimpleXmlTransfer sxt;
        this.clearDropInfo();
        this.mLeaveTargetNode = null;
        this.mLeaveFeedback = null;
        this.mLeaveView = null;
        this.mCurrentDragElements = this.mGlobalDragInfo.getCurrentElements();
        if (this.mCurrentDragElements == null && (sxt = SimpleXmlTransfer.getInstance()).isSupportedType(event.currentDataType)) {
            this.mCurrentDragElements = (SimpleElement[])sxt.nativeToJava(event.currentDataType);
        }
        if (this.mCurrentDragElements == null || this.mCurrentDragElements.length == 0 || this.mCurrentDragElements[0] == null || this.mCurrentDragElements[0].getFqcn() == null || this.mCurrentDragElements[0].getFqcn().length() == 0) {
            event.detail = 0;
        }
        this.dragOperationChanged(event);
    }

    @Override
    public void dragOperationChanged(DropTargetEvent event) {
        MoveGesture.checkDataType(event);
        this.recomputeDragType(event);
    }

    private void recomputeDragType(DropTargetEvent event) {
        if (event.detail == 16) {
            if (this.mGlobalDragInfo.getSourceCanvas() == this.mCanvas && (event.operations & 2) != 0) {
                event.detail = 2;
            } else if ((event.operations & 1) != 0) {
                event.detail = 1;
            }
        }
        if (event.detail != 1 && event.detail != 2) {
            event.detail = 0;
        }
    }

    @Override
    public void dragLeave(DropTargetEvent event) {
        this.mLeaveTargetNode = this.mTargetNode;
        this.mLeaveFeedback = this.mFeedback;
        this.mLeaveView = this.mCurrentView;
        this.clearDropInfo();
    }

    @Override
    public void dragOver(DropTargetEvent event) {
        this.processDropEvent(event);
    }

    @Override
    public void dropAccept(DropTargetEvent event) {
        MoveGesture.checkDataType(event);
        if (this.mLeaveTargetNode != null) {
            this.mTargetNode = this.mLeaveTargetNode;
            this.mFeedback = this.mLeaveFeedback;
            this.mCurrentView = this.mLeaveView;
        }
        if (this.mFeedback != null && this.mFeedback.invalidTarget) {
            event.detail = 0;
        }
        if (this.mLeaveTargetNode == null || event.detail == 0) {
            this.clearDropInfo();
        }
        this.mLeaveTargetNode = null;
        this.mLeaveFeedback = null;
        this.mLeaveView = null;
    }

    @Override
    public void drop(final DropTargetEvent event) {
        Object[] elements = null;
        SimpleXmlTransfer sxt = SimpleXmlTransfer.getInstance();
        if (sxt.isSupportedType(event.currentDataType) && event.data instanceof SimpleElement[]) {
            elements = (SimpleElement[])event.data;
        }
        if (elements == null || elements.length < 1) {
            return;
        }
        if (this.mCurrentDragElements != null && Arrays.equals(elements, this.mCurrentDragElements)) {
            elements = this.mCurrentDragElements;
        }
        if (this.mTargetNode == null) {
            ViewHierarchy viewHierarchy = this.mCanvas.getViewHierarchy();
            if (viewHierarchy.isValid() && viewHierarchy.isEmpty()) {
                this.createDocumentRoot((SimpleElement[])elements);
            }
            return;
        }
        this.updateDropFeedback(this.mFeedback, event);
        Object[] elementsFinal = elements;
        LayoutPoint canvasPoint = this.getDropLocation(event).toLayout();
        String label = MoveGesture.computeUndoLabel(this.mTargetNode, (SimpleElement[])elements, event.detail);
        final ArrayList added = new ArrayList();
        final ArrayList indices = new ArrayList();
        UiElementNode.NodeCreationListener listener = new UiElementNode.NodeCreationListener(){

            @Override
            public void nodeCreated(UiElementNode parent, UiElementNode child, int index) {
                if (parent == MoveGesture.this.mTargetNode.getNode()) {
                    added.add(child);
                    int i = 0;
                    int n = indices.size();
                    while (i < n) {
                        int idx = (Integer)indices.get(i);
                        if (idx >= index) {
                            indices.set(i, idx + 1);
                        }
                        ++i;
                    }
                    indices.add(index);
                }
            }

            @Override
            public void nodeDeleted(UiElementNode parent, UiElementNode child, int previousIndex) {
                if (parent == MoveGesture.this.mTargetNode.getNode()) {
                    int i = 0;
                    int n = indices.size();
                    while (i < n) {
                        int idx = (Integer)indices.get(i);
                        if (idx >= previousIndex) {
                            indices.set(i, idx - 1);
                        }
                        ++i;
                    }
                }
            }
        };
        try {
            UiElementNode.addNodeCreationListener(listener);
            this.mCanvas.getEditorDelegate().getEditor().wrapUndoEditXmlModel(label, new Runnable((SimpleElement[])elementsFinal, canvasPoint){
                private final /* synthetic */ SimpleElement[] val$elementsFinal;
                private final /* synthetic */ LayoutPoint val$canvasPoint;
                {
                    this.val$elementsFinal = simpleElementArray;
                    this.val$canvasPoint = layoutPoint;
                }

                @Override
                public void run() {
                    InsertType insertType = MoveGesture.getInsertType(event, MoveGesture.this.mTargetNode);
                    MoveGesture.this.mCanvas.getRulesEngine().callOnDropped(MoveGesture.this.mTargetNode, this.val$elementsFinal, MoveGesture.this.mFeedback, new Point(this.val$canvasPoint.x, this.val$canvasPoint.y), insertType);
                    MoveGesture.this.mTargetNode.applyPendingChanges();
                    if (event.detail == 2) {
                        GlobalCanvasDragInfo.getInstance().removeSource();
                    }
                    MoveGesture.this.mTargetNode.applyPendingChanges();
                }
            });
        }
        finally {
            UiElementNode.removeNodeCreationListener(listener);
        }
        final ArrayList<INode> nodes = new ArrayList<INode>();
        NodeFactory nodeFactory = this.mCanvas.getNodeFactory();
        for (UiElementNode uiNode : added) {
            NodeProxy node;
            if (!(uiNode instanceof UiViewElementNode) || (node = nodeFactory.create((UiViewElementNode)uiNode)) == null) continue;
            nodes.add(node);
        }
        final SelectionManager selectionManager = this.mCanvas.getSelectionManager();
        if (!selectionManager.selectDropped(nodes, null)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    selectionManager.selectDropped(nodes, indices);
                }
            });
        }
        this.clearDropInfo();
        this.mCanvas.redraw();
        this.mCanvas.setFocus();
    }

    public static InsertType getInsertType(DropTargetEvent event, NodeProxy mTargetNode) {
        GlobalCanvasDragInfo dragInfo = GlobalCanvasDragInfo.getInstance();
        if (event.detail == 2) {
            SelectionItem[] selection = dragInfo.getCurrentSelection();
            if (selection != null) {
                SelectionItem[] selectionItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    SelectionItem item = selectionItemArray[n2];
                    if (item.getNode() != null && item.getNode().getParent() == mTargetNode) {
                        return InsertType.MOVE_WITHIN;
                    }
                    ++n2;
                }
            }
            return InsertType.MOVE_INTO;
        }
        if (dragInfo.getSourceCanvas() != null) {
            return InsertType.PASTE;
        }
        return InsertType.CREATE;
    }

    public static String computeUndoLabel(NodeProxy targetNode, SimpleElement[] elements, int detail) {
        String verb = detail == 2 ? "Move" : "Drop";
        String object = elements != null && elements.length == 1 ? MoveGesture.getSimpleName(elements[0].getFqcn()) : "Widgets";
        String where = MoveGesture.getSimpleName(targetNode.getFqcn());
        return String.format("%1$s %2$s in %3$s", verb, object, where);
    }

    public static String getSimpleName(String fqcn) {
        return fqcn.substring(fqcn.lastIndexOf(46) + 1);
    }

    private void updateDropFeedback(DropFeedback df, DropTargetEvent event) {
        int baseline;
        if (event != null) {
            df.isCopy = event.detail == 1;
        }
        df.sameCanvas = this.mCanvas == this.mGlobalDragInfo.getSourceCanvas();
        df.invalidTarget = false;
        df.dipScale = this.mCanvas.getEditorDelegate().getGraphicalEditor().getDipScale();
        df.modifierMask = this.mCanvas.getGestureManager().getRuleModifierMask();
        GlobalCanvasDragInfo dragInfo = GlobalCanvasDragInfo.getInstance();
        Rect dragBounds = null;
        Rect controlDragBounds = dragInfo.getDragBounds();
        if (controlDragBounds != null) {
            CanvasTransform ht = this.mCanvas.getHorizontalTransform();
            CanvasTransform vt = this.mCanvas.getVerticalTransform();
            double horizScale = ht.getScale();
            double verticalScale = vt.getScale();
            int x = (int)((double)controlDragBounds.x / horizScale);
            int y = (int)((double)controlDragBounds.y / verticalScale);
            int w = (int)((double)controlDragBounds.w / horizScale);
            int h = (int)((double)controlDragBounds.h / verticalScale);
            dragBounds = new Rect(x, y, w, h);
        }
        if ((baseline = dragInfo.getDragBaseline()) != -1) {
            df.dragBaseline = baseline;
        }
        df.dragBounds = dragBounds;
    }

    private static boolean checkDataType(DropTargetEvent event) {
        TransferData current;
        SimpleXmlTransfer sxt = SimpleXmlTransfer.getInstance();
        if (sxt.isSupportedType(current = event.currentDataType)) {
            return true;
        }
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData td = transferDataArray[n2];
            if (td != current && sxt.isSupportedType(td)) {
                event.currentDataType = td;
                return true;
            }
            ++n2;
        }
        event.detail = 0;
        return false;
    }

    private ControlPoint getDropLocation(DropTargetEvent event) {
        return ControlPoint.create(this.mCanvas, event);
    }

    private void processDropEvent(DropTargetEvent event) {
        ISelection currentSelection;
        CanvasViewInfo vi;
        if (!this.mCanvas.getViewHierarchy().isValid()) {
            event.detail = 0;
            this.clearDropInfo();
            return;
        }
        LayoutPoint p = this.getDropLocation(event).toLayout();
        boolean isCaptured = false;
        if (this.mFeedback != null) {
            Rect r = this.mFeedback.captureArea;
            boolean bl = isCaptured = r != null && r.contains(p.x, p.y);
        }
        if (isCaptured) {
            vi = this.mCurrentView;
        } else {
            vi = this.mCanvas.getViewHierarchy().findViewInfoAt(p);
            if (vi == null) {
                vi = this.mCanvas.getViewHierarchy().getRoot();
            }
        }
        boolean isMove = true;
        boolean needRedraw = false;
        if (vi != this.mCurrentView) {
            if (vi == null) {
                isMove = false;
                needRedraw = true;
                event.detail = 0;
                this.clearDropInfo();
            } else {
                DropFeedback df = null;
                NodeProxy targetNode = null;
                CanvasViewInfo targetVi = vi;
                while (targetVi != null && df == null) {
                    SelectionItem[] selection;
                    targetNode = this.mCanvas.getNodeFactory().create(targetVi);
                    df = this.mCanvas.getRulesEngine().callOnDropEnter(targetNode, targetVi.getViewObject(), this.mCurrentDragElements);
                    if (df != null) {
                        this.updateDropFeedback(df, event);
                        df = this.mCanvas.getRulesEngine().callOnDropMove(targetNode, this.mCurrentDragElements, df, new Point(p.x, p.y));
                    }
                    if (df != null && event.detail == 2 && this.mCanvas == this.mGlobalDragInfo.getSourceCanvas() && (selection = this.mGlobalDragInfo.getCurrentSelection()) != null) {
                        SelectionItem[] selectionItemArray = selection;
                        int n = selection.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SelectionItem cs = selectionItemArray[n2];
                            if (cs.getViewInfo() == targetVi) {
                                this.updateDropFeedback(df, event);
                                this.mCanvas.getRulesEngine().callOnDropLeave(targetNode, this.mCurrentDragElements, df);
                                df = null;
                                targetNode = null;
                            }
                            ++n2;
                        }
                    }
                    targetVi = targetVi.getParent();
                }
                if (df == null) {
                    event.detail = 0;
                    this.clearDropInfo();
                } else if (targetNode != this.mTargetNode) {
                    this.callDropLeave();
                    this.mTargetNode = targetNode;
                    this.mFeedback = df;
                    isMove = false;
                }
            }
            this.mCurrentView = vi;
        }
        if (isMove && this.mTargetNode != null && this.mFeedback != null) {
            Point p2 = new Point(p.x, p.y);
            this.updateDropFeedback(this.mFeedback, event);
            DropFeedback df = this.mCanvas.getRulesEngine().callOnDropMove(this.mTargetNode, this.mCurrentDragElements, this.mFeedback, p2);
            this.mCanvas.getGestureManager().updateMessage(this.mFeedback);
            if (df == null) {
                event.detail = 0;
                this.callDropLeave();
            } else if (df != this.mFeedback) {
                this.mFeedback = df;
            }
        }
        if (this.mFeedback != null) {
            if (event.detail == 0 && !this.mFeedback.invalidTarget) {
                event.detail = 16;
                this.recomputeDragType(event);
            } else if (this.mFeedback.invalidTarget) {
                event.detail = 0;
            }
        }
        if (needRedraw || this.mFeedback != null && this.mFeedback.requestPaint) {
            this.mCanvas.redraw();
        }
        OutlinePage outline = this.mCanvas.getOutlinePage();
        TreeSelection newSelection = TreeSelection.EMPTY;
        if (this.mCurrentView != null && this.mTargetNode != null) {
            if (this.mCurrentView.getUiViewNode() != this.mTargetNode.getNode()) {
                this.mCurrentView = this.mCurrentView.getParent();
            }
            if (this.mCurrentView != null && this.mCurrentView.getUiViewNode() == this.mTargetNode.getNode()) {
                TreePath treePath = SelectionManager.getTreePath(this.mCurrentView);
                newSelection = new TreeSelection(treePath);
            }
        }
        if ((currentSelection = outline.getSelection()) == null || !currentSelection.equals(newSelection)) {
            outline.setSelection((ISelection)newSelection);
        }
    }

    private void callDropLeave() {
        if (this.mTargetNode != null && this.mFeedback != null) {
            this.updateDropFeedback(this.mFeedback, null);
            this.mCanvas.getRulesEngine().callOnDropLeave(this.mTargetNode, this.mCurrentDragElements, this.mFeedback);
        }
        this.mTargetNode = null;
        this.mFeedback = null;
    }

    private void clearDropInfo() {
        this.callDropLeave();
        this.mCurrentView = null;
        this.mCanvas.redraw();
    }

    private void createDocumentRoot(SimpleElement[] elements) {
        if (elements == null || elements.length < 1 || elements[0] == null) {
            return;
        }
        this.mCanvas.createDocumentRoot(elements[0]);
    }

    private class MoveOverlay
    extends Overlay {
        private MoveOverlay() {
        }

        @Override
        public void paint(GC gc) {
            if (MoveGesture.this.mTargetNode != null && MoveGesture.this.mFeedback != null) {
                RulesEngine rulesEngine = MoveGesture.this.mCanvas.getRulesEngine();
                rulesEngine.callDropFeedbackPaint(MoveGesture.this.mCanvas.getGcWrapper(), MoveGesture.this.mTargetNode, MoveGesture.this.mFeedback);
                ((MoveGesture)MoveGesture.this).mFeedback.requestPaint = false;
            }
        }
    }
}

