/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.rendering.api.Capability;
import com.android.resources.ResourceType;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutMetadata;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gle2.SubmenuAction;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.resources.CyclicDependencyValidator;
import org.eclipse.andmore.internal.ui.ResourceChooser;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.w3c.dom.Node;

public class ListViewTypeMenu
extends SubmenuAction {
    private final LayoutCanvas mCanvas;
    private boolean mGrid;
    private boolean mSpinner;

    public ListViewTypeMenu(LayoutCanvas canvas, boolean isGrid, boolean isSpinner) {
        super(isGrid ? "Preview Grid Content" : (isSpinner ? "Preview Spinner Layout" : "Preview List Content"));
        this.mCanvas = canvas;
        this.mGrid = isGrid;
        this.mSpinner = isSpinner;
    }

    @Override
    protected void addMenuItems(Menu menu) {
        GraphicalEditorPart graphicalEditor = this.mCanvas.getEditorDelegate().getGraphicalEditor();
        if (graphicalEditor.renderingSupports(Capability.ADAPTER_BINDING)) {
            Action action = new PickLayoutAction("Choose Layout...", "listitem");
            new ActionContributionItem((IAction)action).fill(menu, -1);
            new Separator().fill(menu, -1);
            String selected = this.getSelectedLayout();
            if (selected != null && selected.startsWith("@android:layout/")) {
                selected = selected.substring("@android:layout/".length());
            }
            if (this.mSpinner) {
                action = new SetListTypeAction("Spinner Item", "simple_spinner_item", selected);
                new ActionContributionItem((IAction)action).fill(menu, -1);
                action = new SetListTypeAction("Spinner Dropdown Item", "simple_spinner_dropdown_item", selected);
                new ActionContributionItem((IAction)action).fill(menu, -1);
                return;
            }
            action = new SetListTypeAction("Simple List Item", "simple_list_item_1", selected);
            new ActionContributionItem((IAction)action).fill(menu, -1);
            action = new SetListTypeAction("Simple 2-Line List Item", "simple_list_item_2", selected);
            new ActionContributionItem((IAction)action).fill(menu, -1);
            action = new SetListTypeAction("Checked List Item", "simple_list_item_checked", selected);
            new ActionContributionItem((IAction)action).fill(menu, -1);
            action = new SetListTypeAction("Single Choice List Item", "simple_list_item_single_choice", selected);
            new ActionContributionItem((IAction)action).fill(menu, -1);
            action = new SetListTypeAction("Multiple Choice List Item", "simple_list_item_multiple_choice", selected);
            if (!this.mGrid) {
                new Separator().fill(menu, -1);
                action = new SetListTypeAction("Simple Expandable List Item", "simple_expandable_list_item_1", selected);
                new ActionContributionItem((IAction)action).fill(menu, -1);
                action = new SetListTypeAction("Simple 2-Line Expandable List Item", "simple_expandable_list_item_2", selected);
                new ActionContributionItem((IAction)action).fill(menu, -1);
                new Separator().fill(menu, -1);
                action = new PickLayoutAction("Choose Header...", "listheader");
                new ActionContributionItem((IAction)action).fill(menu, -1);
                action = new PickLayoutAction("Choose Footer...", "listfooter");
                new ActionContributionItem((IAction)action).fill(menu, -1);
            }
        } else {
            this.addDisabledMessageItem("Not supported for this SDK version; try changing the Render Target");
        }
    }

    private String getSelectedLayout() {
        String layout = null;
        SelectionManager selectionManager = this.mCanvas.getSelectionManager();
        for (SelectionItem item : selectionManager.getSelections()) {
            Node xmlNode;
            UiViewElementNode node = item.getViewInfo().getUiViewNode();
            if (node == null || (layout = LayoutMetadata.getProperty(xmlNode = node.getXmlNode(), "listitem")) == null) continue;
            return layout;
        }
        return null;
    }

    private void setNewType(String type, String layout) {
        LayoutEditorDelegate delegate = this.mCanvas.getEditorDelegate();
        GraphicalEditorPart graphicalEditor = delegate.getGraphicalEditor();
        SelectionManager selectionManager = this.mCanvas.getSelectionManager();
        for (SelectionItem item : selectionManager.getSnapshot()) {
            UiViewElementNode node = item.getViewInfo().getUiViewNode();
            if (node == null) continue;
            Node xmlNode = node.getXmlNode();
            LayoutMetadata.setProperty(delegate.getEditor(), xmlNode, type, layout);
        }
        graphicalEditor.recomputeLayout();
        this.mCanvas.redraw();
    }

    private class PickLayoutAction
    extends Action {
        private final String mType;

        public PickLayoutAction(String title, String type) {
            super(title, 1);
            this.mType = type;
        }

        public void run() {
            LayoutEditorDelegate delegate = ListViewTypeMenu.this.mCanvas.getEditorDelegate();
            IFile file = delegate.getEditor().getInputFile();
            GraphicalEditorPart editor = delegate.getGraphicalEditor();
            ResourceChooser dlg = ResourceChooser.create(editor, ResourceType.LAYOUT).setInputValidator(CyclicDependencyValidator.create(file)).setInitialSize(85, 10).setCurrentResource(ListViewTypeMenu.this.getSelectedLayout());
            int result = dlg.open();
            if (result == -5) {
                ListViewTypeMenu.this.setNewType(this.mType, null);
            } else if (result == 0) {
                String newType = dlg.getCurrentResource();
                ListViewTypeMenu.this.setNewType(this.mType, newType);
            }
        }
    }

    private class SetListTypeAction
    extends Action {
        private final String mLayout;

        public SetListTypeAction(String title, String layout, String selected) {
            super(title, 8);
            this.mLayout = layout;
            if (layout.equals(selected)) {
                this.setChecked(true);
            }
        }

        public void run() {
            if (this.isChecked()) {
                ListViewTypeMenu.this.setNewType("listitem", "@android:layout/" + this.mLayout);
            }
        }
    }
}

