/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gre.RulesEngine;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class LayoutCanvasViewer
extends Viewer
implements IPostSelectionProvider {
    private LayoutCanvas mCanvas;
    private final LayoutEditorDelegate mEditorDelegate;
    private ISelectionChangedListener mSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            LayoutCanvasViewer.this.fireSelectionChanged(event);
            LayoutCanvasViewer.this.firePostSelectionChanged(event);
        }
    };
    private ListenerList mPostChangedListeners = new ListenerList();

    public LayoutCanvasViewer(LayoutEditorDelegate editorDelegate, RulesEngine rulesEngine, Composite parent, int style) {
        this.mEditorDelegate = editorDelegate;
        this.mCanvas = new LayoutCanvas(editorDelegate, rulesEngine, parent, style);
        this.mCanvas.getSelectionManager().addSelectionChangedListener(this.mSelectionListener);
    }

    public Control getControl() {
        return this.mCanvas;
    }

    public LayoutCanvas getCanvas() {
        return this.mCanvas;
    }

    public Object getInput() {
        return this.mEditorDelegate.getEditor().getEditorInput();
    }

    public void setInput(Object input) {
    }

    public ISelection getSelection() {
        return this.mCanvas.getSelectionManager().getSelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.mEditorDelegate.getEditor().getIgnoreXmlUpdate()) {
            return;
        }
        this.mCanvas.getSelectionManager().setSelection(selection);
    }

    public void refresh() {
    }

    public void dispose() {
        if (this.mSelectionListener != null) {
            this.mCanvas.getSelectionManager().removeSelectionChangedListener(this.mSelectionListener);
        }
        if (this.mCanvas != null) {
            this.mCanvas.dispose();
            this.mCanvas = null;
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.mPostChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.mPostChangedListeners.remove((Object)listener);
    }

    protected void firePostSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.mPostChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }
}

