/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.ResourceItem;
import com.android.io.IAbstractFile;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.resources.manager.ProjectResources;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.andmore.io.IFileWrapper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IncludeFinder {
    private static final QualifiedName CONFIG_INCLUDES = new QualifiedName("org.eclipse.andmore", "includes");
    private static final QualifiedName INCLUDE_FINDER = new QualifiedName("org.eclipse.andmore", "includefinder");
    private final IProject mProject;
    private Map<String, List<String>> mIncludes = null;
    private Map<String, List<String>> mIncludedBy = null;
    private static boolean sRefreshing;
    private static ResourceListener sListener;
    private final String CHAIN_FORMAT = "%1$s=>%2$s";
    private static final String MESSAGE = "Found cyclical <include> chain";

    private IncludeFinder(IProject project) {
        this.mProject = project;
    }

    public static IncludeFinder get(IProject project) {
        IncludeFinder finder = null;
        try {
            finder = (IncludeFinder)project.getSessionProperty(INCLUDE_FINDER);
        }
        catch (CoreException coreException) {}
        if (finder == null) {
            finder = new IncludeFinder(project);
            try {
                project.setSessionProperty(INCLUDE_FINDER, (Object)finder);
            }
            catch (CoreException e) {
                AndmoreAndroidPlugin.log(e, "Can't store IncludeFinder", new Object[0]);
            }
        }
        return finder;
    }

    private List<String> getIncludesFrom(String includer) {
        this.ensureInitialized();
        return this.mIncludes.get(includer);
    }

    public List<Reference> getIncludedBy(IResource included) {
        String name;
        this.ensureInitialized();
        String mapKey = IncludeFinder.getMapKey(included);
        List<String> result = this.mIncludedBy.get(mapKey);
        if (result == null && !(name = IncludeFinder.getResourceName(included)).equals(mapKey)) {
            result = this.mIncludedBy.get(name);
        }
        if (result != null && result.size() > 0) {
            ArrayList<Reference> references = new ArrayList<Reference>(result.size());
            for (String s : result) {
                references.add(new Reference(this.mProject, s));
            }
            return references;
        }
        return null;
    }

    public boolean isIncluded(IResource included) {
        String name;
        this.ensureInitialized();
        String mapKey = IncludeFinder.getMapKey(included);
        List<String> result = this.mIncludedBy.get(mapKey);
        if (result == null && !(name = IncludeFinder.getResourceName(included)).equals(mapKey)) {
            result = this.mIncludedBy.get(name);
        }
        return result != null && result.size() > 0;
    }

    List<String> getIncludedBy(String included) {
        this.ensureInitialized();
        return this.mIncludedBy.get(included);
    }

    private void ensureInitialized() {
        if (this.mIncludes == null && !this.readSettings()) {
            this.mIncludes = new HashMap<String, List<String>>();
            this.mIncludedBy = new HashMap<String, List<String>>();
            this.scanProject();
            this.saveSettings();
        }
    }

    public static String encodeMap(Map<String, List<String>> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null) {
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                List<String> values = map.get(key);
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(key);
                if (values.size() <= 0) continue;
                sb.append('=').append('>');
                sb.append('{');
                boolean first = true;
                for (String value : values) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(value);
                }
                sb.append('}');
            }
        }
        return sb.toString();
    }

    public static Map<String, List<String>> decodeMap(String encoded) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (encoded.length() > 0) {
            int i = 0;
            int end = encoded.length();
            while (i < end) {
                int keyBegin = i;
                int keyEnd = i;
                while (i < end) {
                    char c = encoded.charAt(i);
                    if (c == ',') break;
                    if (c == '=') {
                        i += 2;
                        break;
                    }
                    keyEnd = ++i;
                }
                ArrayList<String> values = new ArrayList<String>();
                if (i < end && encoded.charAt(i) == '{') {
                    ++i;
                    while (i < end) {
                        int valueBegin = i;
                        int valueEnd = i;
                        char c = '\u0000';
                        while (i < end) {
                            c = encoded.charAt(i);
                            if (c == ',' || c == '}') {
                                valueEnd = i;
                                break;
                            }
                            ++i;
                        }
                        if (valueEnd > valueBegin) {
                            values.add(encoded.substring(valueBegin, valueEnd));
                        }
                        if (c == '}') {
                            if (i >= end - 1 || encoded.charAt(i + 1) != ',') break;
                            ++i;
                            break;
                        }
                        assert (c == ',');
                        ++i;
                    }
                }
                String key = encoded.substring(keyBegin, keyEnd);
                map.put(key, values);
                ++i;
            }
        }
        return map;
    }

    private void saveSettings() {
        String encoded = IncludeFinder.encodeMap(this.mIncludes);
        try {
            if (encoded.length() >= 2048) {
                this.mProject.setPersistentProperty(CONFIG_INCLUDES, null);
            } else {
                String existing = this.mProject.getPersistentProperty(CONFIG_INCLUDES);
                if (!encoded.equals(existing)) {
                    this.mProject.setPersistentProperty(CONFIG_INCLUDES, encoded);
                }
            }
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, "Can't store include settings", new Object[0]);
        }
    }

    private boolean readSettings() {
        try {
            String encoded = this.mProject.getPersistentProperty(CONFIG_INCLUDES);
            if (encoded != null) {
                this.mIncludes = IncludeFinder.decodeMap(encoded);
                this.mIncludedBy = new HashMap<String, List<String>>(2 * this.mIncludes.size());
                for (Map.Entry<String, List<String>> entry : this.mIncludes.entrySet()) {
                    String includer = entry.getKey();
                    List<String> included = entry.getValue();
                    this.setIncludedBy(includer, included);
                }
                return true;
            }
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, "Can't read include settings", new Object[0]);
        }
        return false;
    }

    private void scanProject() {
        ProjectResources resources = ResourceManager.getInstance().getProjectResources(this.mProject);
        if (resources != null) {
            Collection layouts = resources.getResourceItemsOfType(ResourceType.LAYOUT);
            for (ResourceItem layout : layouts) {
                List sources = layout.getSourceFileList();
                for (ResourceFile source : sources) {
                    this.updateFileIncludes(source, false);
                }
            }
            return;
        }
    }

    private boolean updateFileIncludes(ResourceFile resourceFile, boolean singleUpdate) {
        Collection resourceTypes = resourceFile.getResourceTypes();
        for (ResourceType type : resourceTypes) {
            String key;
            if (type != ResourceType.LAYOUT) continue;
            this.ensureInitialized();
            List<Object> includes = Collections.emptyList();
            if (resourceFile.getFile() instanceof IFileWrapper) {
                String xml;
                IFile file = ((IFileWrapper)resourceFile.getFile()).getIFile();
                boolean hadXmlModel = false;
                IStructuredModel model = null;
                try {
                    IModelManager modelManager = StructuredModelManager.getModelManager();
                    model = modelManager.getExistingModelForRead(file);
                    if (model instanceof IDOMModel) {
                        IDOMModel domModel = (IDOMModel)model;
                        IDOMDocument document = domModel.getDocument();
                        includes = IncludeFinder.findIncludesInDocument((Document)document);
                        hadXmlModel = true;
                    }
                }
                finally {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
                if (!hadXmlModel && (xml = AndmoreAndroidPlugin.readFile(file)) != null) {
                    includes = IncludeFinder.findIncludes(xml);
                }
            } else {
                String xml = AndmoreAndroidPlugin.readFile(resourceFile);
                if (xml != null) {
                    includes = IncludeFinder.findIncludes(xml);
                }
            }
            if (includes.equals(this.getIncludesFrom(key = IncludeFinder.getMapKey(resourceFile)))) {
                return false;
            }
            boolean detectCycles = singleUpdate;
            this.setIncluded(key, includes, detectCycles);
            if (singleUpdate) {
                this.saveSettings();
            }
            return true;
        }
        return false;
    }

    static List<String> findIncludes(String xml) {
        int index = xml.indexOf("layout");
        if (index != -1) {
            return IncludeFinder.findIncludesInXml(xml);
        }
        return Collections.emptyList();
    }

    static List<String> findIncludesInXml(String xml) {
        Document document = DomUtilities.parseDocument(xml, false);
        if (document != null) {
            return IncludeFinder.findIncludesInDocument(document);
        }
        return Collections.emptyList();
    }

    private static List<String> findIncludesInDocument(Document document) {
        List<String> includes = IncludeFinder.findIncludesInDocument(document, null);
        if (includes == null) {
            includes = Collections.emptyList();
        }
        return includes;
    }

    private static List<String> findIncludesInDocument(Node node, List<String> urls) {
        if (node.getNodeType() == 1) {
            String tag = node.getNodeName();
            boolean isInclude = tag.equals("include");
            boolean isFragment = tag.equals("fragment");
            if (isInclude || isFragment) {
                String resourceName;
                Element element = (Element)node;
                String url = isInclude ? element.getAttribute("layout") : element.getAttributeNS("http://schemas.android.com/tools", "layout");
                if (url.length() > 0 && (resourceName = IncludeFinder.urlToLocalResource(url)) != null) {
                    if (urls == null) {
                        urls = new ArrayList<String>();
                    }
                    urls.add(resourceName);
                }
            }
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            urls = IncludeFinder.findIncludesInDocument(children.item(i), urls);
            ++i;
        }
        return urls;
    }

    private static String urlToLocalResource(String url) {
        if (!url.startsWith("@")) {
            return null;
        }
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd == -1) {
            return null;
        }
        int nameBegin = typeEnd + 1;
        int typeBegin = 1;
        int colon = url.lastIndexOf(58, typeEnd);
        if (colon != -1) {
            String packageName = url.substring(typeBegin, colon);
            if ("android".equals(packageName)) {
                return null;
            }
            typeBegin = colon + 1;
            assert ("layout".equals(url.substring(typeBegin, typeEnd)));
        }
        return url.substring(nameBegin);
    }

    void setIncluded(String includer, List<String> included, boolean detectCycles) {
        List<String> oldIncludes = this.mIncludes.get(includer);
        if (oldIncludes != null && oldIncludes.size() > 0) {
            for (String includee : oldIncludes) {
                List<String> includers = this.mIncludedBy.get(includee);
                if (includers == null) continue;
                includers.remove(includer);
            }
        }
        this.mIncludes.put(includer, included);
        this.setIncludedBy(includer, included);
        if (detectCycles) {
            this.detectCycles(includer);
        }
    }

    private void setIncludedBy(String includer, List<String> included) {
        for (String target : included) {
            List<String> list = this.mIncludedBy.get(target);
            if (list == null) {
                list = new ArrayList<String>(2);
                this.mIncludedBy.put(target, list);
            }
            if (list.contains(includer)) continue;
            list.add(includer);
        }
    }

    public static synchronized void start() {
        assert (sListener == null);
        sListener = new ResourceListener();
        ResourceManager.getInstance().addListener(sListener);
    }

    public static void stop() {
        assert (sListener != null);
        ResourceManager.getInstance().addListener(sListener);
    }

    private static String getMapKey(ResourceFile resourceFile) {
        IAbstractFile file = resourceFile.getFile();
        String name = file.getName();
        String folderName = file.getParentFolder().getName();
        return IncludeFinder.getMapKey(folderName, name);
    }

    private static String getMapKey(IResource resourceFile) {
        String folderName = resourceFile.getParent().getName();
        String name = resourceFile.getName();
        return IncludeFinder.getMapKey(folderName, name);
    }

    private static String getResourceName(IResource resourceFile) {
        String name = resourceFile.getName();
        int baseEnd = name.length() - "xml".length() - 1;
        if (baseEnd > 0) {
            name = name.substring(0, baseEnd);
        }
        return name;
    }

    private static String getMapKey(String folderName, String name) {
        int baseEnd = name.length() - "xml".length() - 1;
        if (baseEnd > 0) {
            name = name.substring(0, baseEnd);
        }
        if ("layout".equals(folderName)) {
            return name;
        }
        return String.valueOf(folderName) + "/" + name;
    }

    private void detectCycles(String from) {
        if (this.mIncludes.size() > 0) {
            HashSet<String> visiting = new HashSet<String>(this.mIncludes.size());
            String chain = this.dfs(from, visiting);
            if (chain != null) {
                this.addError(from, chain);
            } else {
                this.removeErrors(from);
            }
        }
    }

    private String dfs(String from, Set<String> visiting) {
        visiting.add(from);
        List<String> includes = this.mIncludes.get(from);
        if (includes != null && includes.size() > 0) {
            for (String include : includes) {
                if (visiting.contains(include)) {
                    return String.format("%1$s=>%2$s", from, include);
                }
                String chain = this.dfs(include, visiting);
                if (chain == null) continue;
                return String.format("%1$s=>%2$s", from, chain);
            }
        }
        visiting.remove(from);
        return null;
    }

    private void removeErrors(String from) {
        IResource resource = this.findResource(from);
        if (resource != null) {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    final IMarker marker = iMarkerArray[n2];
                    String tmpMsg = marker.getAttribute("message", null);
                    if (tmpMsg == null || tmpMsg.startsWith(MESSAGE)) {
                        IncludeFinder.runLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    try {
                                        sRefreshing = true;
                                        marker.delete();
                                    }
                                    catch (CoreException e) {
                                        AndmoreAndroidPlugin.log(e, "Can't delete problem marker", new Object[0]);
                                        sRefreshing = false;
                                    }
                                }
                                finally {
                                    sRefreshing = false;
                                }
                            }
                        });
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private void addError(String from, String chain) {
        final IResource resource = this.findResource(from);
        if (resource != null) {
            final String message = String.format("%1$s: %2$s", MESSAGE, chain);
            boolean markerAlreadyExists = false;
            try {
                String tmpMsg;
                int tmpSeverity;
                IMarker marker;
                int tmpLine;
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                if (markers.length != 0 && (tmpLine = (marker = iMarkerArray[0]).getAttribute("lineNumber", -1)) == 1 && (tmpSeverity = marker.getAttribute("severity", -1)) == 2 && (tmpMsg = marker.getAttribute("message", null)) != null && tmpMsg.equals(message)) {
                    markerAlreadyExists = true;
                }
            }
            catch (CoreException coreException) {}
            if (!markerAlreadyExists) {
                IncludeFinder.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            sRefreshing = true;
                            BaseProjectHelper.markResource(resource, "org.eclipse.core.resources.problemmarker", message, 1, 2);
                        }
                        finally {
                            sRefreshing = false;
                        }
                    }
                });
            }
        }
    }

    private static void runLater(Runnable runnable) {
        Display display = Display.findDisplay((Thread)Thread.currentThread());
        if (display != null) {
            display.asyncExec(runnable);
        } else {
            AndmoreAndroidPlugin.log(2, "Could not find display", new Object[0]);
        }
    }

    private IResource findResource(String from) {
        IResource resource = this.mProject.findMember("/res/layout/" + from + '.' + "xml");
        return resource;
    }

    static IncludeFinder create() {
        IncludeFinder finder = new IncludeFinder(null);
        finder.mIncludes = new HashMap<String, List<String>>();
        finder.mIncludedBy = new HashMap<String, List<String>>();
        return finder;
    }

    public Collection<String> getInvalidIncludes(IFile layout) {
        IProject project = layout.getProject();
        Reference self = Reference.create(layout);
        LinkedList<Reference> queue = new LinkedList<Reference>();
        ArrayList<Reference> invalid = new ArrayList<Reference>();
        queue.add(self);
        invalid.add(self);
        HashSet<String> seen = new HashSet<String>();
        seen.add(self.getId());
        while (!queue.isEmpty()) {
            Reference reference = (Reference)queue.removeFirst();
            String refId = reference.getId();
            List<String> included = this.getIncludedBy(refId);
            if (refId.indexOf(47) != -1) {
                List<String> baseIncluded = this.getIncludedBy(reference.getName());
                if (included == null) {
                    included = baseIncluded;
                } else if (baseIncluded != null) {
                    included = new ArrayList<String>(included);
                    included.addAll(baseIncluded);
                }
            }
            if (included == null || included.size() <= 0) continue;
            for (String id : included) {
                if (seen.contains(id)) continue;
                seen.add(id);
                Reference ref = new Reference(project, id);
                invalid.add(ref);
                queue.addLast(ref);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Reference reference : invalid) {
            result.add(reference.getResourceName());
        }
        return result;
    }

    public static class Reference {
        private final String mId;
        private final IProject mProject;
        private String mName;

        private Reference(IProject project, String id) {
            this.mProject = project;
            this.mId = id;
        }

        public String getId() {
            return this.mId;
        }

        public IFile getFile() {
            String projectPath;
            IResource member;
            String reference = this.mId;
            if (!reference.contains("/")) {
                reference = "layout/" + reference;
            }
            if ((member = this.mProject.findMember(projectPath = "res/" + reference + '.' + "xml")) instanceof IFile) {
                return (IFile)member;
            }
            return null;
        }

        public String getDisplayName() {
            return this.mId;
        }

        public String getName() {
            if (this.mName == null) {
                this.mName = this.mId;
                int index = this.mName.lastIndexOf("/");
                if (index != -1) {
                    this.mName = this.mName.substring(index + 1);
                }
            }
            return this.mName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.mId == null ? 0 : this.mId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Reference other = (Reference)obj;
            return !(this.mId == null ? other.mId != null : !this.mId.equals(other.mId));
        }

        public String toString() {
            return "Reference [getId()=" + this.getId() + ", getDisplayName()=" + this.getDisplayName() + ", getName()=" + this.getName() + ", getFile()=" + this.getFile() + "]";
        }

        public static Reference create(IFile file) {
            return new Reference(file.getProject(), IncludeFinder.getMapKey((IResource)file));
        }

        public String getResourceName() {
            return "@layout/" + this.getName();
        }
    }

    private static class ResourceListener
    implements ResourceManager.IResourceListener {
        private ResourceListener() {
        }

        @Override
        public void fileChanged(IProject project, ResourceFile file, int eventType) {
            if (sRefreshing) {
                return;
            }
            if ((eventType & 0x107) == 0) {
                return;
            }
            IncludeFinder finder = IncludeFinder.get(project);
            if (finder != null && finder.updateFileIncludes(file, true)) {
                finder.saveSettings();
            }
        }

        @Override
        public void folderChanged(IProject project, ResourceFolder folder, int eventType) {
        }
    }
}

