/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.Rect;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;

final class GlobalCanvasDragInfo {
    private static final GlobalCanvasDragInfo sInstance = new GlobalCanvasDragInfo();
    private SimpleElement[] mCurrentElements = null;
    private SelectionItem[] mCurrentSelection;
    private Object mSourceCanvas = null;
    private Runnable mRemoveSourceHandler;
    private Rect mDragBounds;
    private int mDragBaseline = -1;

    private GlobalCanvasDragInfo() {
    }

    public static GlobalCanvasDragInfo getInstance() {
        return sInstance;
    }

    public void startDrag(SimpleElement[] elements, SelectionItem[] selection, Object sourceCanvas, Runnable removeSourceHandler) {
        this.mCurrentElements = elements;
        this.mCurrentSelection = selection;
        this.mSourceCanvas = sourceCanvas;
        this.mRemoveSourceHandler = removeSourceHandler;
    }

    public void stopDrag() {
        this.mCurrentElements = null;
        this.mCurrentSelection = null;
        this.mSourceCanvas = null;
        this.mRemoveSourceHandler = null;
        this.mDragBounds = null;
    }

    public boolean isDragging() {
        return this.mCurrentElements != null;
    }

    public SimpleElement[] getCurrentElements() {
        return this.mCurrentElements;
    }

    public SelectionItem[] getCurrentSelection() {
        return this.mCurrentSelection;
    }

    public Object getSourceCanvas() {
        return this.mSourceCanvas;
    }

    public void removeSource() {
        if (this.mRemoveSourceHandler != null) {
            this.mRemoveSourceHandler.run();
            this.mRemoveSourceHandler = null;
        }
    }

    public Rect getDragBounds() {
        return this.mDragBounds;
    }

    public void setDragBounds(Rect dragBounds) {
        this.mDragBounds = dragBounds;
    }

    public int getDragBaseline() {
        return this.mDragBaseline;
    }

    public void setDragBaseline(int baseline) {
        this.mDragBaseline = baseline;
    }
}

