/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.IColor;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasTransform;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtDrawingStyle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class GCWrapper
implements IGraphics {
    private GC mGc;
    private SwtDrawingStyle mCurrentStyle = SwtDrawingStyle.INVALID;
    private final HashMap<Integer, ColorWrapper> mColorMap = new HashMap();
    private final Map<DrawingStyle, Color> mStyleStrokeMap = new EnumMap<DrawingStyle, Color>(DrawingStyle.class);
    private final Map<DrawingStyle, Color> mStyleFillMap = new EnumMap<DrawingStyle, Color>(DrawingStyle.class);
    private int mFontHeight = 0;
    private final CanvasTransform mHScale;
    private final CanvasTransform mVScale;
    private static final int MIN_LENGTH = 10;

    public GCWrapper(CanvasTransform hScale, CanvasTransform vScale) {
        this.mHScale = hScale;
        this.mVScale = vScale;
        this.mGc = null;
    }

    void setGC(GC gc) {
        this.mGc = gc;
    }

    private GC getGc() {
        return this.mGc;
    }

    void checkGC() {
        if (this.mGc == null) {
            throw new RuntimeException("IGraphics used without a valid context.");
        }
    }

    void dispose() {
        for (ColorWrapper colorWrapper : this.mColorMap.values()) {
            colorWrapper.getColor().dispose();
        }
        this.mColorMap.clear();
        for (Color color : this.mStyleStrokeMap.values()) {
            color.dispose();
        }
        this.mStyleStrokeMap.clear();
        for (Color color : this.mStyleFillMap.values()) {
            color.dispose();
        }
        this.mStyleFillMap.clear();
    }

    public IColor registerColor(int rgb) {
        this.checkGC();
        Integer key = rgb;
        ColorWrapper c = this.mColorMap.get(key);
        if (c == null) {
            c = new ColorWrapper(new Color(this.getGc().getDevice(), rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb >> 0 & 0xFF));
            this.mColorMap.put(key, c);
        }
        return c;
    }

    public int getFontHeight() {
        if (this.mFontHeight < 1) {
            this.checkGC();
            FontMetrics fm = this.getGc().getFontMetrics();
            this.mFontHeight = fm.getHeight();
        }
        return this.mFontHeight;
    }

    public IColor getForeground() {
        Color c = this.getGc().getForeground();
        return new ColorWrapper(c);
    }

    public IColor getBackground() {
        Color c = this.getGc().getBackground();
        return new ColorWrapper(c);
    }

    public int getAlpha() {
        return this.getGc().getAlpha();
    }

    public void setForeground(IColor color) {
        this.checkGC();
        this.getGc().setForeground(((ColorWrapper)color).getColor());
    }

    public void setBackground(IColor color) {
        this.checkGC();
        this.getGc().setBackground(((ColorWrapper)color).getColor());
    }

    public void setAlpha(int alpha) {
        this.checkGC();
        try {
            this.getGc().setAlpha(alpha);
        }
        catch (SWTException sWTException) {}
    }

    public void setLineStyle(IGraphics.LineStyle style) {
        int swtStyle = 0;
        switch (style) {
            case LINE_SOLID: {
                swtStyle = 1;
                break;
            }
            case LINE_DASH: {
                swtStyle = 2;
                break;
            }
            case LINE_DOT: {
                swtStyle = 3;
                break;
            }
            case LINE_DASHDOT: {
                swtStyle = 4;
                break;
            }
            case LINE_DASHDOTDOT: {
                swtStyle = 5;
                break;
            }
            default: {
                assert (false) : style;
                break;
            }
        }
        if (swtStyle != 0) {
            this.checkGC();
            this.getGc().setLineStyle(swtStyle);
        }
    }

    public void setLineWidth(int width) {
        this.checkGC();
        if (width > 0) {
            this.getGc().setLineWidth(width);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkGC();
        this.useStrokeAlpha();
        x1 = this.mHScale.translate(x1);
        y1 = this.mVScale.translate(y1);
        x2 = this.mHScale.translate(x2);
        y2 = this.mVScale.translate(y2);
        this.getGc().drawLine(x1, y1, x2, y2);
    }

    public void drawLine(Point p1, Point p2) {
        this.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void drawRect(int x1, int y1, int x2, int y2) {
        this.checkGC();
        this.useStrokeAlpha();
        int x = this.mHScale.translate(x1);
        int y = this.mVScale.translate(y1);
        int w = this.mHScale.scale(x2 - x1);
        int h = this.mVScale.scale(y2 - y1);
        this.getGc().drawRectangle(x, y, w, h);
    }

    public void drawRect(Point p1, Point p2) {
        this.drawRect(p1.x, p1.y, p2.x, p2.y);
    }

    public void drawRect(Rect r) {
        this.checkGC();
        this.useStrokeAlpha();
        int x = this.mHScale.translate(r.x);
        int y = this.mVScale.translate(r.y);
        int w = this.mHScale.scale(r.w);
        int h = this.mVScale.scale(r.h);
        this.getGc().drawRectangle(x, y, w, h);
    }

    public void fillRect(int x1, int y1, int x2, int y2) {
        this.checkGC();
        this.useFillAlpha();
        int x = this.mHScale.translate(x1);
        int y = this.mVScale.translate(y1);
        int w = this.mHScale.scale(x2 - x1);
        int h = this.mVScale.scale(y2 - y1);
        this.getGc().fillRectangle(x, y, w, h);
    }

    public void fillRect(Point p1, Point p2) {
        this.fillRect(p1.x, p1.y, p2.x, p2.y);
    }

    public void fillRect(Rect r) {
        this.checkGC();
        this.useFillAlpha();
        int x = this.mHScale.translate(r.x);
        int y = this.mVScale.translate(r.y);
        int w = this.mHScale.scale(r.w);
        int h = this.mVScale.scale(r.h);
        this.getGc().fillRectangle(x, y, w, h);
    }

    public void drawOval(int x1, int y1, int x2, int y2) {
        this.checkGC();
        this.useStrokeAlpha();
        int x = this.mHScale.translate(x1);
        int y = this.mVScale.translate(y1);
        int w = this.mHScale.scale(x2 - x1);
        int h = this.mVScale.scale(y2 - y1);
        this.getGc().drawOval(x, y, w, h);
    }

    public void drawOval(Point p1, Point p2) {
        this.drawOval(p1.x, p1.y, p2.x, p2.y);
    }

    public void drawOval(Rect r) {
        this.checkGC();
        this.useStrokeAlpha();
        int x = this.mHScale.translate(r.x);
        int y = this.mVScale.translate(r.y);
        int w = this.mHScale.scale(r.w);
        int h = this.mVScale.scale(r.h);
        this.getGc().drawOval(x, y, w, h);
    }

    public void fillOval(int x1, int y1, int x2, int y2) {
        this.checkGC();
        this.useFillAlpha();
        int x = this.mHScale.translate(x1);
        int y = this.mVScale.translate(y1);
        int w = this.mHScale.scale(x2 - x1);
        int h = this.mVScale.scale(y2 - y1);
        this.getGc().fillOval(x, y, w, h);
    }

    public void fillOval(Point p1, Point p2) {
        this.fillOval(p1.x, p1.y, p2.x, p2.y);
    }

    public void fillOval(Rect r) {
        this.checkGC();
        this.useFillAlpha();
        int x = this.mHScale.translate(r.x);
        int y = this.mVScale.translate(r.y);
        int w = this.mHScale.scale(r.w);
        int h = this.mVScale.scale(r.h);
        this.getGc().fillOval(x, y, w, h);
    }

    public void drawString(String string, int x, int y) {
        this.checkGC();
        this.useStrokeAlpha();
        x = this.mHScale.translate(x);
        y = this.mVScale.translate(y);
        this.getGc().drawString(string, x, y, true);
    }

    public void drawBoxedStrings(int x, int y, List<?> strings) {
        this.checkGC();
        x = this.mHScale.translate(x);
        y = this.mVScale.translate(y);
        int width = 0;
        int height = 0;
        int lineHeight = this.getGc().getFontMetrics().getHeight();
        for (Object s : strings) {
            org.eclipse.swt.graphics.Point extent = this.getGc().stringExtent(s.toString());
            height += extent.y;
            width = Math.max(width, extent.x);
        }
        int padding = 2;
        this.useFillAlpha();
        this.getGc().fillRectangle(x - padding, y - padding, width + 2 * padding, height + 2 * padding);
        this.useStrokeAlpha();
        int lineY = y;
        for (Object s : strings) {
            this.getGc().drawString(s.toString(), x, lineY, true);
            lineY += lineHeight;
        }
    }

    public void drawString(String string, Point topLeft) {
        this.drawString(string, topLeft.x, topLeft.y);
    }

    public void useStyle(DrawingStyle style) {
        RGB fill;
        this.checkGC();
        SwtDrawingStyle swtStyle = SwtDrawingStyle.of(style);
        RGB stroke = swtStyle.getStrokeColor();
        if (stroke != null) {
            Color color = this.getStrokeColor(style, stroke);
            this.mGc.setForeground(color);
        }
        if ((fill = swtStyle.getFillColor()) != null) {
            Color color = this.getFillColor(style, fill);
            this.mGc.setBackground(color);
        }
        this.mGc.setLineWidth(swtStyle.getLineWidth());
        this.mGc.setLineStyle(swtStyle.getLineStyle());
        if (swtStyle.getLineStyle() == 6) {
            this.mGc.setLineDash(new int[]{8, 4});
        }
        this.mCurrentStyle = swtStyle;
    }

    private void useStrokeAlpha() {
        this.mGc.setAlpha(this.mCurrentStyle.getStrokeAlpha());
    }

    private void useFillAlpha() {
        this.mGc.setAlpha(this.mCurrentStyle.getFillAlpha());
    }

    private Color getStrokeColor(DrawingStyle style, RGB defaultColorDesc) {
        return this.getStyleColor(style, defaultColorDesc, this.mStyleStrokeMap);
    }

    private Color getFillColor(DrawingStyle style, RGB defaultColorDesc) {
        return this.getStyleColor(style, defaultColorDesc, this.mStyleFillMap);
    }

    private Color getStyleColor(DrawingStyle style, RGB defaultColorDesc, Map<DrawingStyle, Color> map) {
        Color color = map.get(style);
        if (color == null) {
            color = new Color(this.getGc().getDevice(), defaultColorDesc);
            map.put(style, color);
        }
        return color;
    }

    public void drawPoint(int x, int y) {
        this.checkGC();
        this.useStrokeAlpha();
        x = this.mHScale.translate(x);
        y = this.mVScale.translate(y);
        this.getGc().drawPoint(x, y);
    }

    public void drawArrow(int x1, int y1, int x2, int y2, int size) {
        int delta;
        int arrowWidth = size;
        int arrowHeight = size;
        this.checkGC();
        this.useStrokeAlpha();
        x1 = this.mHScale.translate(x1);
        y1 = this.mVScale.translate(y1);
        x2 = this.mHScale.translate(x2);
        y2 = this.mVScale.translate(y2);
        GC graphics = this.getGc();
        if (x1 == x2 && Math.abs(y1 - y2) < 10) {
            delta = (10 - Math.abs(y1 - y2)) / 2;
            if (y1 < y2) {
                y1 -= delta;
                y2 += delta;
            } else {
                y1 += delta;
                y2 -= delta;
            }
        } else if (y1 == y2 && Math.abs(x1 - x2) < 10) {
            delta = (10 - Math.abs(x1 - x2)) / 2;
            if (x1 < x2) {
                x1 -= delta;
                x2 += delta;
            } else {
                x1 += delta;
                x2 -= delta;
            }
        }
        graphics.drawLine(x1, y1, x2, y2);
        if (x1 == x2) {
            if (y2 > y1) {
                graphics.drawLine(x2 - arrowWidth, y2 - arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 - arrowHeight, x2, y2);
            } else {
                graphics.drawLine(x2 - arrowWidth, y2 + arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 + arrowHeight, x2, y2);
            }
        } else if (y1 == y2) {
            if (x2 > x1) {
                graphics.drawLine(x2 - arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 - arrowHeight, y2 + arrowWidth, x2, y2);
            } else {
                graphics.drawLine(x2 + arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 + arrowHeight, y2 + arrowWidth, x2, y2);
            }
        } else {
            int dy = y2 - y1;
            int dx = x2 - x1;
            double angle = Math.atan2(dy, dx);
            double lineLength = Math.sqrt(dy * dy + dx * dx);
            double ax = (double)x1 + lineLength - (double)arrowHeight;
            double ay = y1 - arrowWidth;
            int rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            int ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
            ay = y1 + arrowWidth;
            rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
        }
    }

    private static class ColorWrapper
    implements IColor {
        private final Color mColor;

        public ColorWrapper(Color color) {
            this.mColor = color;
        }

        public Color getColor() {
            return this.mColor;
        }
    }
}

