/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.utils.Pair;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DomUtilities {
    private static final Comparator<Attr> ATTRIBUTE_COMPARATOR = new Comparator<Attr>(){

        @Override
        public int compare(Attr a1, Attr a2) {
            return a1.getName().compareTo(a2.getName());
        }
    };

    public static Node getCommonAncestor(Node node1, Node node2) {
        while (node2 != null) {
            Node current = node1;
            while (current != null && current != node2) {
                current = current.getParentNode();
            }
            if (current == node2) {
                return current;
            }
            node2 = node2.getParentNode();
        }
        return null;
    }

    public static List<Element> getAllElements(Node node) {
        ArrayList<Element> elements = new ArrayList<Element>(64);
        DomUtilities.addElements(node, elements);
        return elements;
    }

    private static void addElements(Node node, List<Element> elements) {
        if (node instanceof Element) {
            elements.add((Element)node);
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        int n = childNodes.getLength();
        while (i < n) {
            DomUtilities.addElements(childNodes.item(i), elements);
            ++i;
        }
    }

    public static int getDepth(Node node) {
        int depth = -1;
        while (node != null) {
            ++depth;
            node = node.getParentNode();
        }
        return depth;
    }

    public static boolean hasElementChildren(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            if (children.item(i).getNodeType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Document getDocument(IFile file) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager == null) {
            return null;
        }
        try {
            IStructuredModel model = modelManager.getExistingModelForRead(file);
            if (model == null) {
                model = modelManager.getModelForRead(file);
            }
            if (model != null) {
                if (model instanceof IDOMModel) {
                    IDOMModel domModel = (IDOMModel)model;
                    return domModel.getDocument();
                }
                model.releaseFromRead();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Document getDocument(AndroidXmlEditor editor) {
        IStructuredModel model = editor.getModelForRead();
        try {
            if (model instanceof IDOMModel) {
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument iDOMDocument = domModel.getDocument();
                return iDOMDocument;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Node getNode(IDocument document, int offset) {
        Node node = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager == null) {
            return null;
        }
        try {
            IStructuredModel model = modelManager.getExistingModelForRead(document);
            if (model == null) return node;
            try {
                while (offset >= 0) {
                    if (node != null) {
                        return node;
                    }
                    node = (Node)model.getIndexedRegion(offset);
                    --offset;
                }
                return node;
            }
            finally {
                model.releaseFromRead();
            }
        }
        catch (Exception exception) {}
        return node;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<Node, Node> getNodeContext(IDocument document, int offset) {
        Node node = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager == null) {
            return null;
        }
        try {
            IStructuredModel model = modelManager.getExistingModelForRead(document);
            if (model == null) return null;
            try {
                while (offset >= 0) {
                    if (node != null) {
                        return null;
                    }
                    IndexedRegion indexedRegion = model.getIndexedRegion(offset);
                    if (indexedRegion != null) {
                        IndexedRegion previousRegion;
                        node = (Node)indexedRegion;
                        if (node.getNodeType() == 3) {
                            Pair pair = Pair.of((Object)node.getParentNode(), (Object)node);
                            return pair;
                        }
                        IStructuredDocument doc = model.getStructuredDocument();
                        IStructuredDocumentRegion region = doc.getRegionAtCharacterOffset(offset);
                        ITextRegion subRegion = region.getRegionAtCharacterOffset(offset);
                        String type = subRegion.getType();
                        if (!"XML_END_TAG_OPEN".equals(type)) {
                            Pair pair = Pair.of((Object)node.getParentNode(), (Object)node);
                            return pair;
                        }
                        Node lastChild = node.getLastChild();
                        if (lastChild != null && (previousRegion = (IndexedRegion)lastChild).getEndOffset() == offset) {
                            Pair pair = Pair.of((Object)node, (Object)lastChild);
                            return pair;
                        }
                        Pair pair = Pair.of((Object)node, null);
                        return pair;
                    }
                    --offset;
                }
                return null;
            }
            finally {
                model.releaseFromRead();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Node getNode(IDocument document, int offset, boolean forward) {
        Node node = DomUtilities.getNode(document, offset);
        if (node instanceof IndexedRegion) {
            IndexedRegion region = (IndexedRegion)node;
            if (!forward && offset <= region.getStartOffset()) {
                Node left = node.getPreviousSibling();
                if (left == null) {
                    left = node.getParentNode();
                }
                node = left;
            } else if (forward && offset >= region.getEndOffset()) {
                Node right = node.getNextSibling();
                if (right == null) {
                    right = node.getParentNode();
                }
                node = right;
            }
        }
        return node;
    }

    public static Pair<Element, Element> getElementRange(IDocument document, int beginOffset, int endOffset) {
        Node beginNode;
        Element beginElement = null;
        Element endElement = null;
        Node endNode = beginNode = DomUtilities.getNode(document, beginOffset, true);
        if (endOffset > beginOffset) {
            endNode = DomUtilities.getNode(document, endOffset, false);
        }
        if (beginNode == null || endNode == null) {
            return null;
        }
        if (beginNode.getNodeType() != 1) {
            beginElement = DomUtilities.getNextElement(beginNode);
            if (beginElement == null && (beginElement = DomUtilities.getPreviousElement(beginNode)) == null) {
                beginElement = DomUtilities.getParentElement(beginNode);
            }
        } else {
            beginElement = (Element)beginNode;
        }
        if (endNode.getNodeType() != 1) {
            endElement = DomUtilities.getPreviousElement(endNode);
            if (endElement == null && (endElement = DomUtilities.getNextElement(endNode)) == null) {
                endElement = DomUtilities.getParentElement(endNode);
            }
        } else {
            endElement = (Element)endNode;
        }
        if (beginElement != null && endElement != null) {
            return Pair.of((Object)beginElement, (Object)endElement);
        }
        return null;
    }

    public static Element getNextElement(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static Element getPreviousElement(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getPreviousSibling();
        }
        return (Element)node;
    }

    public static Element getParentElement(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        return (Element)node;
    }

    private static void addLowercaseIds(Element root, Set<String> seen) {
        if (root.hasAttributeNS("http://schemas.android.com/apk/res/android", "id")) {
            String id = root.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (id.startsWith("@+id/")) {
                seen.add(id.substring("@+id/".length()).toLowerCase(Locale.US));
            } else if (id.startsWith("@id/")) {
                seen.add(id.substring("@id/".length()).toLowerCase(Locale.US));
            } else {
                seen.add(id.toLowerCase(Locale.US));
            }
        }
    }

    public static String getFreeWidgetId(Element element, Set<String> reserved, String prefix) {
        String generated;
        HashSet<String> ids = new HashSet<String>();
        if (reserved != null) {
            for (String id : reserved) {
                ids.add(id.toLowerCase(Locale.US));
            }
        }
        DomUtilities.addLowercaseIds(element.getOwnerDocument().getDocumentElement(), ids);
        if (prefix == null) {
            prefix = DescriptorsUtils.getBasename(element.getTagName());
        }
        int num = 1;
        while (ids.contains((generated = String.format("%1$s%2$d", prefix, num++)).toLowerCase(Locale.US))) {
        }
        return generated;
    }

    public static List<Element> getChildren(Element element) {
        NodeList children = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>(children.getLength());
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    public static boolean isContiguous(List<Element> elements) {
        if (elements.size() > 1) {
            Node parent = elements.get(0).getParentNode();
            if (!(parent instanceof Element)) {
                return false;
            }
            for (Element node : elements) {
                if (parent == node.getParentNode()) continue;
                return false;
            }
            List<Element> siblings = DomUtilities.getChildren((Element)parent);
            if (siblings.size() != elements.size()) {
                HashSet<Element> nodeSet = new HashSet<Element>(elements);
                boolean inRange = false;
                int remaining = elements.size();
                for (Element node : siblings) {
                    boolean in = nodeSet.contains(node);
                    if (in) {
                        if (--remaining == 0) break;
                        inRange = true;
                        continue;
                    }
                    if (!inRange) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEquivalent(Element element1, Element element2) {
        if (element1 == null || element2 == null) {
            return false;
        }
        if (!element1.getTagName().equals(element2.getTagName())) {
            return false;
        }
        NamedNodeMap attributes1 = element1.getAttributes();
        NamedNodeMap attributes2 = element2.getAttributes();
        ArrayList<Attr> attributeNodes1 = new ArrayList<Attr>();
        int i = 0;
        int n = attributes1.getLength();
        while (i < n) {
            Attr attribute = (Attr)attributes1.item(i);
            if (!"http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                attributeNodes1.add(attribute);
            }
            ++i;
        }
        ArrayList<Attr> attributeNodes2 = new ArrayList<Attr>();
        int i2 = 0;
        int n2 = attributes2.getLength();
        while (i2 < n2) {
            Attr attribute = (Attr)attributes2.item(i2);
            if (!"http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                attributeNodes2.add(attribute);
            }
            ++i2;
        }
        if (attributeNodes1.size() != attributeNodes2.size()) {
            return false;
        }
        if (attributes1.getLength() > 0) {
            Collections.sort(attributeNodes1, ATTRIBUTE_COMPARATOR);
            Collections.sort(attributeNodes2, ATTRIBUTE_COMPARATOR);
            i2 = 0;
            while (i2 < attributeNodes1.size()) {
                Attr attr1 = (Attr)attributeNodes1.get(i2);
                Attr attr2 = (Attr)attributeNodes2.get(i2);
                if (attr1.getLocalName() == null || attr2.getLocalName() == null ? !attr1.getName().equals(attr2.getName()) : !attr1.getLocalName().equals(attr2.getLocalName())) {
                    return false;
                }
                if (!attr1.getValue().equals(attr2.getValue())) {
                    return false;
                }
                if (attr1.getNamespaceURI() == null) {
                    if (attr2.getNamespaceURI() != null) {
                        return false;
                    }
                } else {
                    if (attr2.getNamespaceURI() == null) {
                        return false;
                    }
                    if (!attr1.getNamespaceURI().equals(attr2.getNamespaceURI())) {
                        return false;
                    }
                }
                ++i2;
            }
        }
        NodeList children1 = element1.getChildNodes();
        NodeList children2 = element2.getChildNodes();
        int nextIndex1 = 0;
        int nextIndex2 = 0;
        while (true) {
            if (nextIndex1 < children1.getLength() && children1.item(nextIndex1).getNodeType() != 1) {
                ++nextIndex1;
                continue;
            }
            while (nextIndex2 < children2.getLength() && children2.item(nextIndex2).getNodeType() != 1) {
                ++nextIndex2;
            }
            Element nextElement1 = (Element)(nextIndex1 < children1.getLength() ? children1.item(nextIndex1) : null);
            Element nextElement2 = (Element)(nextIndex2 < children2.getLength() ? children2.item(nextIndex2) : null);
            if (nextElement1 == null) {
                return nextElement2 == null;
            }
            if (nextElement2 == null) {
                return false;
            }
            if (!DomUtilities.isEquivalent(nextElement1, nextElement2)) {
                return false;
            }
            ++nextIndex1;
            ++nextIndex2;
        }
    }

    public static Element findCorresponding(Element element, Document document) {
        assert (element.getOwnerDocument() != document);
        String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
        if (id != null && id.length() > 0) {
            if (id.startsWith("@id/")) {
                id = "@+id/" + id.substring("@id/".length());
            }
            return DomUtilities.findCorresponding(document.getDocumentElement(), id);
        }
        return null;
    }

    private static Element findCorresponding(Element element, String targetId) {
        String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
        if (id != null) {
            if (id.equals(targetId)) {
                return element;
            }
            if (id.startsWith("@id/") && (id = "@+id/" + id.substring("@id/".length())).equals(targetId)) {
                return element;
            }
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Element child;
            Element match;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (match = DomUtilities.findCorresponding(child = (Element)node, targetId)) != null) {
                return match;
            }
            ++i;
        }
        return null;
    }

    public static Document parseStructuredDocument(String xml) {
        IStructuredModel model = DomUtilities.createStructuredModel(xml);
        if (model instanceof IDOMModel) {
            IDOMModel domModel = (IDOMModel)model;
            return domModel.getDocument();
        }
        return null;
    }

    public static IStructuredModel createStructuredModel(String xml) {
        IStructuredModel model = DomUtilities.createEmptyModel();
        IStructuredDocument document = model.getStructuredDocument();
        model.aboutToChangeModel();
        document.set(xml);
        model.changedModel();
        return model;
    }

    public static IStructuredModel createEmptyModel() {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        return modelManager.createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
    }

    public static Document createEmptyDocument() {
        IStructuredModel model = DomUtilities.createEmptyModel();
        if (model instanceof IDOMModel) {
            IDOMModel domModel = (IDOMModel)model;
            return domModel.getDocument();
        }
        return null;
    }

    public static Document createEmptyPlainDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return null;
        }
    }

    public static Document parseDocument(String xml, boolean logParserErrors) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        InputSource is = new InputSource(new StringReader(xml));
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            if (logParserErrors) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
            return null;
        }
    }
}

