/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutPoint;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public final class ControlPoint {
    private final LayoutCanvas mCanvas;
    public final int x;
    public final int y;

    public static ControlPoint create(LayoutCanvas canvas, MouseEvent event) {
        assert (event.widget == canvas) : event.widget;
        return new ControlPoint(canvas, event.x, event.y);
    }

    public static ControlPoint create(LayoutCanvas canvas, MenuDetectEvent event) {
        Point p = canvas.toControl(event.x, event.y);
        return new ControlPoint(canvas, p.x, p.y);
    }

    public static ControlPoint create(LayoutCanvas canvas, DragSourceEvent event) {
        return new ControlPoint(canvas, event.x, event.y);
    }

    public static ControlPoint create(LayoutCanvas canvas, DropTargetEvent event) {
        Point p = canvas.toControl(event.x, event.y);
        return new ControlPoint(canvas, p.x, p.y);
    }

    public static ControlPoint create(LayoutCanvas canvas, int x, int y) {
        return new ControlPoint(canvas, x, y);
    }

    private ControlPoint(LayoutCanvas canvas, int x, int y) {
        this.mCanvas = canvas;
        this.x = x;
        this.y = y;
    }

    public LayoutPoint toLayout() {
        int lx = this.mCanvas.getHorizontalTransform().inverseTranslate(this.x);
        int ly = this.mCanvas.getVerticalTransform().inverseTranslate(this.y);
        return LayoutPoint.create(this.mCanvas, lx, ly);
    }

    public String toString() {
        return "ControlPoint [x=" + this.x + ", y=" + this.y + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlPoint other = (ControlPoint)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.mCanvas == other.mCanvas;
    }

    public Point toDisplayPoint() {
        return this.mCanvas.toDisplay(this.x, this.y);
    }
}

