/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.configuration;

import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.configuration.Configuration;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationChooser;
import org.eclipse.andmore.internal.editors.layout.gle2.SubmenuAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

class OrientationMenuAction
extends SubmenuAction {
    private static final int MENU_NIGHTMODE = 1;
    private static final int MENU_UIMODE = 2;
    private final ConfigurationChooser mConfigChooser;
    private final int mType;

    OrientationMenuAction(int type, String title, ConfigurationChooser configuration) {
        super(title);
        this.mType = type;
        this.mConfigChooser = configuration;
    }

    static void showMenu(ConfigurationChooser configChooser, ToolItem combo) {
        MenuManager manager = new MenuManager();
        Configuration configuration = configChooser.getConfiguration();
        Device device = configuration.getDevice();
        State current = configuration.getDeviceState();
        if (device != null) {
            List states = device.getAllStates();
            if (states.size() > 1 && current != null) {
                State flip = configuration.getNextDeviceState(current);
                String flipName = flip != null ? flip.getName() : current.getName();
                manager.add((IAction)new DeviceConfigAction(configChooser, String.format("Switch to %1$s", flipName), flip, false, true));
                manager.add((IContributionItem)new Separator());
            }
            for (State config : states) {
                manager.add((IAction)new DeviceConfigAction(configChooser, config.getName(), config, config == current, false));
            }
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)new OrientationMenuAction(2, "UI Mode", configChooser));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new OrientationMenuAction(1, "Night Mode", configChooser));
        Menu menu = manager.createContextMenu((Control)configChooser.getShell());
        Rectangle bounds = combo.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = combo.getParent().toDisplay(location);
        menu.setLocation(location.x, location.y);
        menu.setVisible(true);
    }

    @Override
    protected void addMenuItems(Menu menu) {
        switch (this.mType) {
            case 1: {
                NightMode selected = this.mConfigChooser.getConfiguration().getNightMode();
                NightMode[] nightModeArray = NightMode.values();
                int n = nightModeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NightMode mode = nightModeArray[n2];
                    boolean checked = mode == selected;
                    SelectNightModeAction action = new SelectNightModeAction(mode, checked);
                    new ActionContributionItem((IAction)action).fill(menu, -1);
                    ++n2;
                }
                break;
            }
            case 2: {
                UiMode selected = this.mConfigChooser.getConfiguration().getUiMode();
                UiMode[] uiModeArray = UiMode.values();
                int n = uiModeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    UiMode mode = uiModeArray[n3];
                    boolean checked = mode == selected;
                    SelectUiModeAction action = new SelectUiModeAction(mode, checked);
                    new ActionContributionItem((IAction)action).fill(menu, -1);
                    ++n3;
                }
                break;
            }
        }
    }

    private static class DeviceConfigAction
    extends Action {
        private final ConfigurationChooser mConfiguration;
        private final State mState;

        private DeviceConfigAction(ConfigurationChooser configuration, String title, State state, boolean checked, boolean flip) {
            super(title, 8);
            this.mConfiguration = configuration;
            this.mState = state;
            if (checked) {
                this.setChecked(true);
            }
            ScreenOrientation orientation = configuration.getOrientation(state);
            this.setImageDescriptor(configuration.getOrientationImage(orientation, flip));
        }

        public void run() {
            this.mConfiguration.selectDeviceState(this.mState);
            this.mConfiguration.onDeviceConfigChange();
        }
    }

    private class SelectNightModeAction
    extends Action {
        private final NightMode mMode;

        private SelectNightModeAction(NightMode mode, boolean checked) {
            super(mode.getLongDisplayValue(), 8);
            this.mMode = mode;
            if (checked) {
                this.setChecked(true);
            }
        }

        public void run() {
            Configuration configuration = OrientationMenuAction.this.mConfigChooser.getConfiguration();
            configuration.setNightMode(this.mMode, false);
            OrientationMenuAction.this.mConfigChooser.notifyFolderConfigChanged();
        }
    }

    private class SelectUiModeAction
    extends Action {
        private final UiMode mMode;

        private SelectUiModeAction(UiMode mode, boolean checked) {
            super(mode.getLongDisplayValue(), 8);
            this.mMode = mode;
            if (checked) {
                this.setChecked(true);
            }
        }

        public void run() {
            Configuration configuration = OrientationMenuAction.this.mConfigChooser.getConfiguration();
            configuration.setUiMode(this.mMode, false);
        }
    }
}

