/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.google.common.base.Objects;
import org.eclipse.andmore.internal.editors.layout.configuration.Configuration;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationChooser;
import org.eclipse.andmore.internal.editors.layout.configuration.Locale;

public class NestedConfiguration
extends Configuration {
    protected Configuration mParent;
    private int mOverride;

    protected NestedConfiguration(ConfigurationChooser chooser, Configuration configuration) {
        super(chooser);
        this.mParent = configuration;
        this.mFullConfig.set(this.mParent.mFullConfig);
        if (this.mParent.getEditedConfig() != null) {
            this.mEditedConfig = new FolderConfiguration();
            this.mEditedConfig.set(this.mParent.mEditedConfig);
        }
    }

    public int getOverrideFlags() {
        return this.mOverride;
    }

    public static NestedConfiguration create(NestedConfiguration other, Configuration values, Configuration parent) {
        NestedConfiguration configuration = new NestedConfiguration(other.mConfigChooser, parent);
        NestedConfiguration.initFrom(configuration, other, values, true);
        return configuration;
    }

    protected static void initFrom(NestedConfiguration configuration, NestedConfiguration other, Configuration values, boolean sync) {
        configuration.mOverride = other.mOverride;
        configuration.setDisplayName(values.getDisplayName());
        configuration.setActivity(values.getActivity());
        if (configuration.isOverridingLocale()) {
            configuration.setLocale(values.getLocale(), true);
        }
        if (configuration.isOverridingTarget()) {
            configuration.setTarget(values.getTarget(), true);
        }
        if (configuration.isOverridingDevice()) {
            configuration.setDevice(values.getDevice(), true);
        }
        if (configuration.isOverridingDeviceState()) {
            configuration.setDeviceState(values.getDeviceState(), true);
        }
        if (configuration.isOverridingNightMode()) {
            configuration.setNightMode(values.getNightMode(), true);
        }
        if (configuration.isOverridingUiMode()) {
            configuration.setUiMode(values.getUiMode(), true);
        }
        if (sync) {
            configuration.syncFolderConfig();
        }
    }

    public void setParent(Configuration parent) {
        this.mParent = parent;
    }

    public static NestedConfiguration create(ConfigurationChooser chooser, Configuration parent) {
        return new NestedConfiguration(chooser, parent);
    }

    @Override
    public String getTheme() {
        return this.mParent.getTheme();
    }

    @Override
    public void setTheme(String theme) {
        this.mParent.setTheme(theme);
    }

    public void setOverrideLocale(boolean override) {
        this.mOverride |= 0x10;
    }

    public final boolean isOverridingLocale() {
        return (this.mOverride & 0x10) != 0;
    }

    @Override
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            return super.getLocale();
        }
        return this.mParent.getLocale();
    }

    @Override
    public void setLocale(Locale locale, boolean skipSync) {
        if (this.isOverridingLocale()) {
            super.setLocale(locale, skipSync);
        } else {
            this.mParent.setLocale(locale, skipSync);
        }
    }

    public void setOverrideTarget(boolean override) {
        this.mOverride |= 0x20;
    }

    public final boolean isOverridingTarget() {
        return (this.mOverride & 0x20) != 0;
    }

    @Override
    public IAndroidTarget getTarget() {
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        return this.mParent.getTarget();
    }

    @Override
    public void setTarget(IAndroidTarget target, boolean skipSync) {
        if (this.isOverridingTarget()) {
            super.setTarget(target, skipSync);
        } else {
            this.mParent.setTarget(target, skipSync);
        }
    }

    public void setOverrideDevice(boolean override) {
        this.mOverride |= 2;
    }

    public final boolean isOverridingDevice() {
        return (this.mOverride & 2) != 0;
    }

    @Override
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        return this.mParent.getDevice();
    }

    @Override
    public void setDevice(Device device, boolean skipSync) {
        if (this.isOverridingDevice()) {
            super.setDevice(device, skipSync);
        } else {
            this.mParent.setDevice(device, skipSync);
        }
    }

    public void setOverrideDeviceState(boolean override) {
        this.mOverride |= 4;
    }

    public final boolean isOverridingDeviceState() {
        return (this.mOverride & 4) != 0;
    }

    @Override
    public State getDeviceState() {
        Device device;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state = this.mParent.getDeviceState();
        if (this.isOverridingDevice() && state != null && (device = super.getDevice()) != null) {
            return device.getState(state.getName());
        }
        return state;
    }

    @Override
    public void setDeviceState(State state, boolean skipSync) {
        if (this.isOverridingDeviceState()) {
            super.setDeviceState(state, skipSync);
        } else {
            State equivalentState;
            Device device;
            if (this.isOverridingDevice() && (device = super.getDevice()) != null && (equivalentState = device.getState(state.getName())) != null) {
                state = equivalentState;
            }
            this.mParent.setDeviceState(state, skipSync);
        }
    }

    public void setOverrideNightMode(boolean override) {
        this.mOverride |= 0x40;
    }

    public final boolean isOverridingNightMode() {
        return (this.mOverride & 0x40) != 0;
    }

    @Override
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            return super.getNightMode();
        }
        return this.mParent.getNightMode();
    }

    @Override
    public void setNightMode(NightMode night, boolean skipSync) {
        if (this.isOverridingNightMode()) {
            super.setNightMode(night, skipSync);
        } else {
            this.mParent.setNightMode(night, skipSync);
        }
    }

    public void setOverrideUiMode(boolean override) {
        this.mOverride |= 0x80;
    }

    public final boolean isOverridingUiMode() {
        return (this.mOverride & 0x80) != 0;
    }

    @Override
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            return super.getUiMode();
        }
        return this.mParent.getUiMode();
    }

    @Override
    public void setUiMode(UiMode uiMode, boolean skipSync) {
        if (this.isOverridingUiMode()) {
            super.setUiMode(uiMode, skipSync);
        } else {
            this.mParent.setUiMode(uiMode, skipSync);
        }
    }

    public Configuration getParent() {
        return this.mParent;
    }

    @Override
    public String getActivity() {
        return this.mParent.getActivity();
    }

    @Override
    public void setActivity(String activity) {
        super.setActivity(activity);
    }

    public String computeDisplayName() {
        return NestedConfiguration.computeDisplayName(this.mOverride, this);
    }

    public static String computeDisplayName(int flags, Configuration configuration) {
        State deviceState;
        if ((flags & 0x10) != 0) {
            return ConfigurationChooser.getLocaleLabel(configuration.mConfigChooser, configuration.getLocale(), false);
        }
        if ((flags & 0x20) != 0) {
            return ConfigurationChooser.getRenderingTargetLabel(configuration.getTarget(), false);
        }
        if ((flags & 2) != 0) {
            return ConfigurationChooser.getDeviceLabel(configuration.getDevice(), true);
        }
        if ((flags & 4) != 0 && (deviceState = configuration.getDeviceState()) != null) {
            return deviceState.getName();
        }
        if ((flags & 0x40) != 0) {
            return configuration.getNightMode().getLongDisplayValue();
        }
        if ((flags & 0x80) != 0) {
            configuration.getUiMode().getLongDisplayValue();
        }
        return null;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("parent", (Object)this.mParent.getDisplayName()).add("display", (Object)this.getDisplayName()).add("overrideLocale", this.isOverridingLocale()).add("overrideTarget", this.isOverridingTarget()).add("overrideDevice", this.isOverridingDevice()).add("overrideDeviceState", this.isOverridingDeviceState()).add("persistent", (Object)this.toPersistentString()).toString();
    }
}

