/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.configuration;

import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.configuration.Configuration;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationChooser;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationClient;
import org.eclipse.andmore.internal.editors.layout.gle2.IncludeFinder;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderPreviewManager;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderPreviewMode;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

class ConfigurationMenuListener
extends SelectionAdapter {
    private static final String ICON_NEW_CONFIG = "newConfig";
    private static final int ACTION_SELECT_CONFIG = 1;
    private static final int ACTION_CREATE_CONFIG_FILE = 2;
    private static final int ACTION_ADD = 3;
    private static final int ACTION_DELETE_ALL = 4;
    private static final int ACTION_PREVIEW_MODE = 5;
    private final ConfigurationChooser mConfigChooser;
    private final int mAction;
    private final IFile mResource;
    private final RenderPreviewMode mMode;

    ConfigurationMenuListener(ConfigurationChooser configChooser, int action, IFile resource, RenderPreviewMode mode) {
        this.mConfigChooser = configChooser;
        this.mAction = action;
        this.mResource = resource;
        this.mMode = mode;
    }

    public void widgetSelected(SelectionEvent e) {
        switch (this.mAction) {
            case 1: {
                try {
                    AndmoreAndroidPlugin.openFile(this.mResource, null, false);
                }
                catch (PartInitException ex) {
                    AndmoreAndroidPlugin.log(ex, null, new Object[0]);
                }
                return;
            }
            case 2: {
                ConfigurationClient client = this.mConfigChooser.getClient();
                if (client != null) {
                    client.createConfigFile();
                }
                return;
            }
        }
        IEditorPart activeEditor = AdtUtils.getActiveEditor();
        LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor(activeEditor);
        IFile editedFile = this.mConfigChooser.getEditedFile();
        if (delegate == null || editedFile == null) {
            return;
        }
        IProject project = delegate.getEditor().getProject();
        if (project == null || !project.equals((Object)editedFile.getProject())) {
            return;
        }
        LayoutCanvas canvas = delegate.getGraphicalEditor().getCanvasControl();
        RenderPreviewManager previewManager = canvas.getPreviewManager();
        switch (this.mAction) {
            case 3: {
                previewManager.addAsThumbnail();
                break;
            }
            case 5: {
                previewManager.selectMode(this.mMode);
                break;
            }
            case 4: {
                previewManager.deleteManualPreviews();
                break;
            }
            default: {
                assert (false) : this.mAction;
                break;
            }
        }
        canvas.setFitScale(true, false);
        canvas.redraw();
    }

    static void show(ConfigurationChooser chooser, ToolItem combo) {
        Configuration configuration;
        Menu menu = new Menu((Decorations)chooser.getShell(), 8);
        RenderPreviewMode mode = AdtPrefs.getPrefs().getRenderPreviewMode();
        ConfigurationMenuListener.create(menu, "Add As Thumbnail...", new ConfigurationMenuListener(chooser, 3, null, null), 8, false);
        if (mode == RenderPreviewMode.CUSTOM) {
            LayoutCanvas canvas;
            RenderPreviewManager previewManager;
            MenuItem item = ConfigurationMenuListener.create(menu, "Delete All Thumbnails", new ConfigurationMenuListener(chooser, 4, null, null), 8, false);
            IEditorPart activeEditor = AdtUtils.getActiveEditor();
            LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor(activeEditor);
            if (delegate != null && !(previewManager = (canvas = delegate.getGraphicalEditor().getCanvasControl()).getPreviewManager()).hasManualPreviews()) {
                item.setEnabled(false);
            }
        }
        ConfigurationMenuListener.create(menu, "Preview Representative Sample", new ConfigurationMenuListener(chooser, 5, null, RenderPreviewMode.DEFAULT), 16, mode == RenderPreviewMode.DEFAULT);
        ConfigurationMenuListener.create(menu, "Preview All Screen Sizes", new ConfigurationMenuListener(chooser, 5, null, RenderPreviewMode.SCREENS), 16, mode == RenderPreviewMode.SCREENS);
        MenuItem localeItem = ConfigurationMenuListener.create(menu, "Preview All Locales", new ConfigurationMenuListener(chooser, 5, null, RenderPreviewMode.LOCALES), 16, mode == RenderPreviewMode.LOCALES);
        if (chooser.getLocaleList().size() <= 1) {
            localeItem.setEnabled(false);
        }
        boolean canPreviewIncluded = false;
        IProject project = chooser.getProject();
        if (project != null) {
            IncludeFinder finder = IncludeFinder.get(project);
            List<IncludeFinder.Reference> includedBy = finder.getIncludedBy((IResource)chooser.getEditedFile());
            canPreviewIncluded = includedBy != null && !includedBy.isEmpty();
        }
        MenuItem includedItem = ConfigurationMenuListener.create(menu, "Preview Included", new ConfigurationMenuListener(chooser, 5, null, RenderPreviewMode.INCLUDES), 16, mode == RenderPreviewMode.INCLUDES);
        if (!canPreviewIncluded) {
            includedItem.setEnabled(false);
        }
        IFile file = chooser.getEditedFile();
        List<IFile> variations = AdtUtils.getResourceVariations(file, true);
        MenuItem variationsItem = ConfigurationMenuListener.create(menu, "Preview Layout Versions", new ConfigurationMenuListener(chooser, 5, null, RenderPreviewMode.VARIATIONS), 16, mode == RenderPreviewMode.VARIATIONS);
        if (variations.size() <= 1) {
            variationsItem.setEnabled(false);
        }
        ConfigurationMenuListener.create(menu, "Manual Previews", new ConfigurationMenuListener(chooser, 5, null, RenderPreviewMode.CUSTOM), 16, mode == RenderPreviewMode.CUSTOM);
        ConfigurationMenuListener.create(menu, "None", new ConfigurationMenuListener(chooser, 5, null, RenderPreviewMode.NONE), 16, mode == RenderPreviewMode.NONE);
        if (variations.size() > 1) {
            new MenuItem(menu, 2);
            ResourceManager manager = ResourceManager.getInstance();
            for (IFile resource : variations) {
                boolean selected;
                IFolder parent = (IFolder)resource.getParent();
                ResourceFolder parentResource = manager.getResourceFolder(parent);
                FolderConfiguration configuration2 = parentResource.getConfiguration();
                String title = configuration2.toDisplayString();
                MenuItem item = ConfigurationMenuListener.create(menu, title, new ConfigurationMenuListener(chooser, 1, resource, null), 32, false);
                if (file == null || !(selected = file.equals((Object)resource))) continue;
                item.setSelection(true);
                item.setEnabled(false);
            }
        }
        if ((configuration = chooser.getConfiguration()).getEditedConfig() != null && !configuration.getEditedConfig().equals((Object)configuration.getFullConfig())) {
            if (variations.size() > 0) {
                new MenuItem(menu, 2);
            }
            MenuItem item = ConfigurationMenuListener.create(menu, "Create New...", new ConfigurationMenuListener(chooser, 2, null, null), 8, false);
            item.setImage(IconFactory.getInstance().getIcon(ICON_NEW_CONFIG));
        }
        Rectangle bounds = combo.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = combo.getParent().toDisplay(location);
        menu.setLocation(location.x, location.y);
        menu.setVisible(true);
    }

    public static MenuItem create(Menu menu, String title, ConfigurationMenuListener listener, int style, boolean selected) {
        MenuItem item = new MenuItem(menu, style);
        item.setText(title);
        item.addSelectionListener((SelectionListener)listener);
        if (selected) {
            item.setSelection(true);
        }
        return item;
    }

    static MenuItem addTogglePreviewModeAction(Menu menu, String title, ConfigurationChooser chooser, RenderPreviewMode mode) {
        boolean selected;
        boolean bl = selected = AdtPrefs.getPrefs().getRenderPreviewMode() == mode;
        if (selected) {
            mode = RenderPreviewMode.NONE;
        }
        return ConfigurationMenuListener.create(menu, title, new ConfigurationMenuListener(chooser, 5, null, mode), 32, selected);
    }
}

