/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.resources.Density;
import com.android.sdklib.IAndroidTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.internal.editors.layout.BasePullParser;
import org.eclipse.andmore.internal.editors.layout.descriptors.LayoutDescriptors;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.FragmentMenu;
import org.eclipse.andmore.internal.editors.uimodel.UiAttributeNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class UiElementPullParser
extends BasePullParser {
    private static final Pattern FLOAT_PATTERN = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private final int[] sIntOut = new int[1];
    private final ArrayList<UiElementNode> mNodeStack = new ArrayList();
    private UiElementNode mRoot;
    private final boolean mExplodedRendering;
    private boolean mZeroAttributeIsPadding = false;
    private boolean mIncreaseExistingPadding = false;
    private LayoutDescriptors mDescriptors;
    private final Density mDensity;
    private static final String DEFAULT_PADDING_VALUE = "10px";
    private static final String FIXED_PADDING_VALUE = "20px";
    private final Set<UiElementNode> mExplodeNodes;
    private static final int COMPLEX_UNIT_PX = 0;
    private static final int COMPLEX_UNIT_DIP = 1;
    private static final int COMPLEX_UNIT_SP = 2;
    private static final int COMPLEX_UNIT_PT = 3;
    private static final int COMPLEX_UNIT_IN = 4;
    private static final int COMPLEX_UNIT_MM = 5;
    private static final DimensionEntry[] sDimensions = new DimensionEntry[]{new DimensionEntry("px", 0), new DimensionEntry("dip", 1), new DimensionEntry("dp", 1), new DimensionEntry("sp", 2), new DimensionEntry("pt", 3), new DimensionEntry("in", 4), new DimensionEntry("mm", 5)};

    public UiElementPullParser(UiElementNode top, boolean explodeRendering, Set<UiElementNode> explodeNodes, Density density, IProject project) {
        this.mRoot = top;
        this.mExplodedRendering = explodeRendering;
        this.mExplodeNodes = explodeNodes;
        this.mDensity = density;
        if (this.mExplodedRendering) {
            IAndroidTarget target = Sdk.getCurrent().getTarget(project);
            AndroidTargetData data = Sdk.getCurrent().getTargetData(target);
            this.mDescriptors = data.getLayoutDescriptors();
        }
        this.push(this.mRoot);
    }

    protected UiElementNode getCurrentNode() {
        if (this.mNodeStack.size() > 0) {
            return this.mNodeStack.get(this.mNodeStack.size() - 1);
        }
        return null;
    }

    private Node getAttribute(int i) {
        if (this.mParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        UiElementNode uiNode = this.getCurrentNode();
        Node xmlNode = uiNode.getXmlNode();
        if (xmlNode != null) {
            return xmlNode.getAttributes().item(i);
        }
        return null;
    }

    private void push(UiElementNode node) {
        String xml;
        ViewElementDescriptor descriptor;
        this.mNodeStack.add(node);
        this.mZeroAttributeIsPadding = false;
        this.mIncreaseExistingPadding = false;
        if (this.mExplodedRendering && (descriptor = this.mDescriptors.findDescriptorByTag(xml = node.getDescriptor().getXmlLocalName())) != null) {
            NamedNodeMap attributes = node.getXmlNode().getAttributes();
            Node padding = attributes.getNamedItemNS("http://schemas.android.com/apk/res/android", "padding");
            if (padding == null) {
                this.mZeroAttributeIsPadding = true;
            } else {
                this.mIncreaseExistingPadding = true;
            }
        }
    }

    private UiElementNode pop() {
        return this.mNodeStack.remove(this.mNodeStack.size() - 1);
    }

    public Object getViewCookie() {
        return this.getCurrentNode();
    }

    public Object getViewKey() {
        return this.getViewCookie();
    }

    public ILayoutPullParser getParser(String layoutName) {
        return null;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.mNodeStack.size();
    }

    public int getAttributeCount() {
        UiElementNode node = this.getCurrentNode();
        if (node != null) {
            Collection<UiAttributeNode> attributes = node.getAllUiAttributes();
            int count = attributes.size();
            return count + (this.mZeroAttributeIsPadding ? 1 : 0);
        }
        return 0;
    }

    public String getAttributeName(int i) {
        Node attribute;
        if (this.mZeroAttributeIsPadding) {
            if (i == 0) {
                return "padding";
            }
            --i;
        }
        if ((attribute = this.getAttribute(i)) != null) {
            return attribute.getLocalName();
        }
        return null;
    }

    public String getAttributeNamespace(int i) {
        Node attribute;
        if (this.mZeroAttributeIsPadding) {
            if (i == 0) {
                return "http://schemas.android.com/apk/res/android";
            }
            --i;
        }
        if ((attribute = this.getAttribute(i)) != null) {
            return attribute.getNamespaceURI();
        }
        return "";
    }

    public String getAttributePrefix(int i) {
        Node attribute;
        if (this.mZeroAttributeIsPadding) {
            if (i == 0) {
                Document doc = this.mRoot.getXmlDocument();
                return doc.lookupPrefix("http://schemas.android.com/apk/res/android");
            }
            --i;
        }
        if ((attribute = this.getAttribute(i)) != null) {
            return attribute.getPrefix();
        }
        return null;
    }

    public String getAttributeValue(int i) {
        Node attribute;
        if (this.mZeroAttributeIsPadding) {
            if (i == 0) {
                return DEFAULT_PADDING_VALUE;
            }
            --i;
        }
        if ((attribute = this.getAttribute(i)) != null) {
            String value = attribute.getNodeValue();
            if (this.mIncreaseExistingPadding && "padding".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
                return this.addPaddingToValue(value);
            }
            return value;
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        UiElementNode node;
        if (this.mExplodeNodes != null && "padding".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace) && (node = this.getCurrentNode()) != null && this.mExplodeNodes.contains(node)) {
            return FIXED_PADDING_VALUE;
        }
        if (this.mZeroAttributeIsPadding && "padding".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
            return DEFAULT_PADDING_VALUE;
        }
        UiElementNode uiNode = this.getCurrentNode();
        Node xmlNode = uiNode.getXmlNode();
        if (xmlNode != null) {
            String layout;
            if ("layout".equals(localName) && "fragment".equals(xmlNode.getNodeName()) && (layout = FragmentMenu.getFragmentLayout(xmlNode)) != null) {
                return layout;
            }
            Node attribute = xmlNode.getAttributes().getNamedItemNS(namespace, localName);
            if (attribute == null && namespace != null && !namespace.equals("http://schemas.android.com/apk/res/android")) {
                attribute = xmlNode.getAttributes().getNamedItemNS("http://schemas.android.com/apk/res-auto", localName);
            }
            if (attribute != null) {
                String value = attribute.getNodeValue();
                if (this.mIncreaseExistingPadding && "padding".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return this.addPaddingToValue(value);
                }
                if ("match_parent".equals(value) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "fill_parent";
                }
                value = ValueXmlHelper.unescapeResourceString((String)value, (boolean)false, (boolean)false);
                return value;
            }
        }
        return null;
    }

    public int getDepth() {
        return this.mNodeStack.size();
    }

    public String getName() {
        if (this.mParsingState == 2 || this.mParsingState == 3) {
            String layout;
            String name = this.getCurrentNode().getDescriptor().getXmlLocalName();
            if (name.equals("fragment") && (layout = FragmentMenu.getFragmentLayout(this.getCurrentNode().getXmlNode())) != null) {
                return "include";
            }
            return name;
        }
        return null;
    }

    public String getNamespace() {
        if (this.mParsingState == 2 || this.mParsingState == 3) {
            return this.getCurrentNode().getDescriptor().getNamespace();
        }
        return null;
    }

    public String getPrefix() {
        if (this.mParsingState == 2 || this.mParsingState == 3) {
            Document doc = this.mRoot.getXmlDocument();
            return doc.lookupPrefix(this.getCurrentNode().getDescriptor().getNamespace());
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.mParsingState == 2) {
            return this.getCurrentNode().getUiChildren().size() == 0;
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    public void onNextFromStartDocument() {
        this.onNextFromStartTag();
    }

    @Override
    public void onNextFromStartTag() {
        UiElementNode node = this.getCurrentNode();
        List<UiElementNode> children = node.getUiChildren();
        if (children.size() > 0) {
            this.push(children.get(0));
            this.mParsingState = 2;
        } else {
            this.mParsingState = this.mParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    public void onNextFromEndTag() {
        UiElementNode node = this.getCurrentNode();
        if ((node = node.getUiNextSibling()) != null) {
            this.pop();
            this.push(node);
            this.mParsingState = 2;
        } else {
            this.pop();
            this.mParsingState = this.mNodeStack.size() == 1 ? 1 : 3;
        }
    }

    private String addPaddingToValue(String s) {
        int padding = 10;
        if (this.stringToPixel(s)) {
            padding += this.sIntOut[0];
        }
        return String.valueOf(padding) + "px";
    }

    private boolean stringToPixel(String s) {
        int len = (s = s.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = s.toCharArray();
        int i = 0;
        while (i < len) {
            if (buf[i] > '\u00ff') {
                return false;
            }
            ++i;
        }
        if (buf[0] < '0' && buf[0] > '9' && buf[0] != '.') {
            return false;
        }
        Matcher m = FLOAT_PATTERN.matcher(s);
        if (m.matches()) {
            DimensionEntry dimension;
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ' && (dimension = UiElementPullParser.parseDimension(end)) != null) {
                switch (dimension.type) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        f *= (float)this.mDensity.getDpiValue() / 160.0f;
                        break;
                    }
                    case 3: {
                        f *= (float)this.mDensity.getDpiValue() * 0.013888889f;
                        break;
                    }
                    case 4: {
                        f *= (float)this.mDensity.getDpiValue();
                        break;
                    }
                    case 5: {
                        f *= (float)this.mDensity.getDpiValue() * 0.03937008f;
                    }
                }
                this.sIntOut[0] = (int)((double)f + 0.5);
                return true;
            }
        }
        return false;
    }

    private static DimensionEntry parseDimension(String str) {
        str = str.trim();
        DimensionEntry[] dimensionEntryArray = sDimensions;
        int n = sDimensions.length;
        int n2 = 0;
        while (n2 < n) {
            DimensionEntry d = dimensionEntryArray[n2];
            if (d.name.equals(str)) {
                return d;
            }
            ++n2;
        }
        return null;
    }

    private static final class DimensionEntry {
        String name;
        int type;

        DimensionEntry(String name, int unit) {
            this.name = name;
            this.type = unit;
        }
    }
}

