/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout;

import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.resources.manager.GlobalProjectMonitor;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public final class LayoutReloadMonitor {
    private static final LayoutReloadMonitor sThis = new LayoutReloadMonitor();
    private final Map<IProject, List<ILayoutReloadListener>> mListenerMap = new HashMap<IProject, List<ILayoutReloadListener>>();
    private final Map<IProject, ChangeFlags> mProjectFlags = new HashMap<IProject, ChangeFlags>();
    private GlobalProjectMonitor.IFileListener mFileListener = new GlobalProjectMonitor.IFileListener(){

        @Override
        public void fileChanged(IFile file, IMarkerDelta[] markerDeltas, int kind, String extension, int flags, boolean isAndroidProject) {
            if (!("class".equals(extension) || "xml".equals(extension) && "AndroidManifest.xml".equals(file.getName()))) {
                return;
            }
            IProject project = file.getProject();
            if (isAndroidProject) {
                this.processFileChanged(file, project, extension);
            } else {
                IProject[] referencingProjects;
                IProject[] iProjectArray = referencingProjects = project.getReferencingProjects();
                int n = referencingProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    try {
                        boolean hasAndroidNature = p.hasNature("org.eclipse.andmore.AndroidNature");
                        if (hasAndroidNature) {
                            this.processFileChanged(file, p, extension);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++n2;
                }
            }
        }

        private void processFileChanged(IFile file, IProject project, String extension) {
            ChangeFlags changeFlags = (ChangeFlags)LayoutReloadMonitor.this.mProjectFlags.get(project);
            if (changeFlags != null && changeFlags.isAllTrue()) {
                return;
            }
            if ("class".equals(extension)) {
                if (file.getName().matches("R[\\$\\.](.*)")) {
                    if (changeFlags == null) {
                        changeFlags = new ChangeFlags();
                        LayoutReloadMonitor.this.mProjectFlags.put(project, changeFlags);
                    }
                    changeFlags.rClass = true;
                } else {
                    if (changeFlags == null) {
                        changeFlags = new ChangeFlags();
                        LayoutReloadMonitor.this.mProjectFlags.put(project, changeFlags);
                    }
                    changeFlags.code = true;
                }
            } else if ("AndroidManifest.xml".equals(file.getName()) && file.getParent().equals((Object)project)) {
                if (changeFlags == null) {
                    changeFlags = new ChangeFlags();
                    LayoutReloadMonitor.this.mProjectFlags.put(project, changeFlags);
                }
                changeFlags.manifest = true;
            }
        }
    };
    private GlobalProjectMonitor.IResourceEventListener mResourceEventListener = new GlobalProjectMonitor.IResourceEventListener(){

        @Override
        public void resourceChangeEventStart() {
        }

        @Override
        public void resourceChangeEventEnd() {
            for (Map.Entry entry : LayoutReloadMonitor.this.mProjectFlags.entrySet()) {
                IProject project = (IProject)entry.getKey();
                this.notifyForProject(project, (ChangeFlags)entry.getValue(), false);
                ProjectState state = Sdk.getProjectState(project);
                if (state == null || !state.isLibrary()) continue;
                Set<ProjectState> mainProjects = Sdk.getMainProjectsFor(project);
                for (ProjectState mainProject : mainProjects) {
                    this.notifyForProject(mainProject.getProject(), (ChangeFlags)entry.getValue(), true);
                }
            }
            LayoutReloadMonitor.this.mProjectFlags.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyForProject(IProject project, ChangeFlags flags, boolean libraryChanged) {
            Map map = LayoutReloadMonitor.this.mListenerMap;
            synchronized (map) {
                List listeners = (List)LayoutReloadMonitor.this.mListenerMap.get(project);
                if (listeners != null) {
                    for (ILayoutReloadListener listener : listeners) {
                        try {
                            listener.reloadLayout(flags, libraryChanged);
                        }
                        catch (Throwable t) {
                            AndmoreAndroidPlugin.log(t, "Failed to call ILayoutReloadListener.reloadLayout", new Object[0]);
                        }
                    }
                }
            }
        }
    };
    private ResourceManager.IResourceListener mResourceListener = new ResourceManager.IResourceListener(){

        @Override
        public void folderChanged(IProject project, ResourceFolder folder, int eventType) {
            ChangeFlags changeFlags = (ChangeFlags)LayoutReloadMonitor.this.mProjectFlags.get(project);
            if (changeFlags != null && changeFlags.isAllTrue()) {
                return;
            }
            if (changeFlags == null) {
                changeFlags = new ChangeFlags();
                LayoutReloadMonitor.this.mProjectFlags.put(project, changeFlags);
            }
            changeFlags.localeList = true;
        }

        @Override
        public void fileChanged(IProject project, ResourceFile file, int eventType) {
            ChangeFlags changeFlags = (ChangeFlags)LayoutReloadMonitor.this.mProjectFlags.get(project);
            if (changeFlags != null && changeFlags.isAllTrue()) {
                return;
            }
            Collection resTypes = file.getResourceTypes();
            if (resTypes.size() > 0) {
                if (changeFlags == null) {
                    changeFlags = new ChangeFlags();
                    LayoutReloadMonitor.this.mProjectFlags.put(project, changeFlags);
                }
                changeFlags.resources = true;
            }
        }
    };

    public static LayoutReloadMonitor getMonitor() {
        return sThis;
    }

    private LayoutReloadMonitor() {
        ResourceManager.getInstance().addListener(this.mResourceListener);
        GlobalProjectMonitor monitor = GlobalProjectMonitor.getMonitor();
        monitor.addFileListener(this.mFileListener, 7);
        monitor.addResourceEventListener(this.mResourceEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IProject project, ILayoutReloadListener listener) {
        Map<IProject, List<ILayoutReloadListener>> map = this.mListenerMap;
        synchronized (map) {
            List<ILayoutReloadListener> list = this.mListenerMap.get(project);
            if (list == null) {
                list = new ArrayList<ILayoutReloadListener>();
                this.mListenerMap.put(project, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IProject project, ILayoutReloadListener listener) {
        Map<IProject, List<ILayoutReloadListener>> map = this.mListenerMap;
        synchronized (map) {
            List<ILayoutReloadListener> list = this.mListenerMap.get(project);
            if (list != null) {
                list.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ILayoutReloadListener listener) {
        Map<IProject, List<ILayoutReloadListener>> map = this.mListenerMap;
        synchronized (map) {
            for (List<ILayoutReloadListener> list : this.mListenerMap.values()) {
                Iterator<ILayoutReloadListener> it = list.iterator();
                while (it.hasNext()) {
                    ILayoutReloadListener i = it.next();
                    if (i != listener) continue;
                    it.remove();
                }
            }
        }
    }

    public static final class ChangeFlags {
        public boolean code = false;
        public boolean resources = false;
        public boolean rClass = false;
        public boolean localeList = false;
        public boolean manifest = false;

        boolean isAllTrue() {
            return this.code && this.resources && this.rClass && this.localeList && this.manifest;
        }
    }

    public static interface ILayoutReloadListener {
        public void reloadLayout(ChangeFlags var1, boolean var2);
    }
}

