/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.formatting;

import java.util.ArrayList;
import org.eclipse.andmore.internal.build.AaptQuickFix;
import org.eclipse.andmore.internal.editors.layout.refactoring.RefactoringAssistant;
import org.eclipse.andmore.internal.lint.LintFixGenerator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;

public class XmlQuickAssistManager
implements IQuickAssistProcessor {
    private final IQuickAssistProcessor[] mProcessors = new IQuickAssistProcessor[]{new AaptQuickFix(), new LintFixGenerator(), new RefactoringAssistant()};

    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        IQuickAssistProcessor[] iQuickAssistProcessorArray = this.mProcessors;
        int n = this.mProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            IQuickAssistProcessor processor = iQuickAssistProcessorArray[n2];
            if (processor.canFix(annotation)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        IQuickAssistProcessor[] iQuickAssistProcessorArray = this.mProcessors;
        int n = this.mProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            IQuickAssistProcessor processor = iQuickAssistProcessorArray[n2];
            if (processor.canAssist(invocationContext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<ICompletionProposal> allProposals = null;
        IQuickAssistProcessor[] iQuickAssistProcessorArray = this.mProcessors;
        int n = this.mProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal[] proposals;
            IQuickAssistProcessor processor = iQuickAssistProcessorArray[n2];
            if (processor.canAssist(invocationContext) && (proposals = processor.computeQuickAssistProposals(invocationContext)) != null && proposals.length > 0) {
                if (allProposals == null) {
                    allProposals = new ArrayList<ICompletionProposal>();
                }
                ICompletionProposal[] iCompletionProposalArray = proposals;
                int n3 = proposals.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompletionProposal proposal = iCompletionProposalArray[n4];
                    allProposals.add(proposal);
                    ++n4;
                }
            }
            ++n2;
        }
        if (allProposals != null) {
            return allProposals.toArray(new ICompletionProposal[allProposals.size()]);
        }
        return null;
    }
}

