/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.formatting;

import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.resources.ResourceType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlAutoEditStrategy;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlFormatPreferences;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlPrettyPrinter;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLFormattingStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AndroidXmlFormattingStrategy
extends ContextBasedFormattingStrategy {
    private IRegion mRegion;
    private final Queue<IDocument> mDocuments = new LinkedList<IDocument>();
    private final LinkedList<TypedPosition> mPartitions = new LinkedList();
    private ContextBasedFormattingStrategy mDelegate = null;
    private Boolean mIsAndroid;

    private ContextBasedFormattingStrategy getDelegate() {
        if (!AdtPrefs.getPrefs().getUseCustomXmlFormatter() || this.mIsAndroid != null && !this.mIsAndroid.booleanValue()) {
            if (this.mDelegate == null) {
                this.mDelegate = new XMLFormattingStrategy();
            }
            return this.mDelegate;
        }
        return null;
    }

    public void format() {
        block10: {
            ContextBasedFormattingStrategy delegate = this.getDelegate();
            if (delegate != null) {
                delegate.format();
                return;
            }
            super.format();
            IDocument document = this.mDocuments.poll();
            TypedPosition partition = this.mPartitions.poll();
            if (document != null && partition != null && this.mRegion != null) {
                try {
                    if (!(document instanceof IStructuredDocument)) break block10;
                    IStructuredDocument structuredDocument = (IStructuredDocument)document;
                    IModelManager modelManager = StructuredModelManager.getModelManager();
                    IStructuredModel model = modelManager.getModelForEdit(structuredDocument);
                    if (model == null) break block10;
                    try {
                        TextEdit edit = AndroidXmlFormattingStrategy.format(model, this.mRegion.getOffset(), this.mRegion.getLength());
                        if (edit == null) break block10;
                        try {
                            model.aboutToChangeModel();
                            edit.apply(document);
                        }
                        finally {
                            model.changedModel();
                        }
                    }
                    finally {
                        model.releaseFromEdit();
                    }
                }
                catch (BadLocationException e) {
                    AndmoreAndroidPlugin.log(e, "Formatting error", new Object[0]);
                }
            }
        }
    }

    private static TextEdit format(IStructuredModel model, int start, int length) {
        ITextEditor editor;
        int replaceEnd;
        int replaceStart;
        int startOffset;
        IndexedRegion currentIndexedRegion;
        int end = start + length;
        MultiTextEdit edit = new MultiTextEdit();
        IStructuredDocument document = model.getStructuredDocument();
        IDOMNode startNode = null;
        Object endNode = null;
        IDOMDocument domDocument = null;
        if (!(model instanceof IDOMModel)) {
            return edit;
        }
        IDOMModel domModel = (IDOMModel)model;
        domDocument = domModel.getDocument();
        IStructuredDocumentRegion startRegion = document.getRegionAtCharacterOffset(start);
        if (startRegion != null && (currentIndexedRegion = model.getIndexedRegion(startOffset = startRegion.getStartOffset())) instanceof IDOMNode) {
            IDOMNode currentDOMNode;
            startNode = currentDOMNode = (IDOMNode)currentIndexedRegion;
        }
        boolean isOpenTagOnly = false;
        int openTagEnd = -1;
        IStructuredDocumentRegion endRegion = document.getRegionAtCharacterOffset(end);
        if (endRegion != null) {
            IDOMNode currentDOMNode;
            int endOffset = Math.max(endRegion.getStartOffset(), endRegion.getEndOffset() - 1);
            IndexedRegion currentIndexedRegion2 = model.getIndexedRegion(endOffset);
            if (currentIndexedRegion2 instanceof Text && currentIndexedRegion2.getStartOffset() == end && end > 0) {
                currentIndexedRegion2 = model.getIndexedRegion(--end);
                endRegion = document.getRegionAtCharacterOffset(currentIndexedRegion2.getStartOffset());
            }
            if (currentIndexedRegion2 instanceof IDOMNode && (endNode = (currentDOMNode = (IDOMNode)currentIndexedRegion2)) == startNode && endRegion == startRegion) {
                String type;
                ITextRegion subRegion = endRegion.getRegionAtCharacterOffset(end);
                ITextRegionList regions = endRegion.getRegions();
                int index = regions.indexOf(subRegion);
                if (index != -1 && ((type = (subRegion = regions.get(index)).getType()) == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE")) {
                    --index;
                }
                while (index >= 0) {
                    subRegion = regions.get(index);
                    type = subRegion.getType();
                    if (type == "XML_TAG_OPEN") {
                        isOpenTagOnly = true;
                    } else if (type == "XML_EMPTY_TAG_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_END_TAG_OPEN") break;
                    --index;
                }
                int max = regions.size();
                index = Math.max(0, index);
                while (index < max) {
                    subRegion = regions.get(index);
                    String type2 = subRegion.getType();
                    if (type2 == "XML_EMPTY_TAG_CLOSE" || type2 == "XML_TAG_CLOSE") {
                        openTagEnd = subRegion.getEnd() + endRegion.getStartOffset();
                    }
                    ++index;
                }
                if (openTagEnd == -1) {
                    isOpenTagOnly = false;
                }
            }
        }
        String[] indentationLevels = null;
        Object root = null;
        int initialDepth = 0;
        boolean endWithNewline = false;
        if (startNode == null || endNode == null) {
            root = domDocument;
            initialDepth = -1;
            startNode = root;
            endNode = root;
            replaceStart = 0;
            replaceEnd = document.getLength();
            try {
                endWithNewline = replaceEnd > 0 && document.getChar(replaceEnd - 1) == '\n';
            }
            catch (BadLocationException badLocationException) {}
        } else {
            root = DomUtilities.getCommonAncestor((Node)startNode, endNode);
            int n = initialDepth = root != null ? DomUtilities.getDepth((Node)root) - 1 : 0;
            assert (startRegion != null && endRegion != null);
            replaceStart = ((IndexedRegion)startNode).getStartOffset();
            replaceEnd = isOpenTagOnly ? openTagEnd : ((IndexedRegion)endNode).getEndOffset();
            if (startNode.getNodeType() == 1) {
                IndentationMeasurer m = new IndentationMeasurer((Node)startNode, (Node)endNode, document);
                indentationLevels = m.measure(initialDepth, (Node)root);
                int depth = DomUtilities.getDepth((Node)startNode) - 1;
                int i = depth + 1;
                while (i < indentationLevels.length) {
                    indentationLevels[i] = null;
                    ++i;
                }
            }
        }
        XmlFormatStyle style = AndroidXmlFormattingStrategy.guessStyle(model, (Document)domDocument);
        EclipseXmlFormatPreferences prefs = EclipseXmlFormatPreferences.create();
        String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        EclipseXmlPrettyPrinter printer = new EclipseXmlPrettyPrinter(prefs, style, delimiter);
        printer.setEndWithNewline(endWithNewline);
        if (indentationLevels != null) {
            printer.setIndentationLevels(indentationLevels);
        }
        StringBuilder sb = new StringBuilder(length);
        printer.prettyPrint(initialDepth, (Node)root, (Node)startNode, (Node)endNode, sb, isOpenTagOnly);
        String formatted = sb.toString();
        ReplaceEdit replaceEdit = AndroidXmlFormattingStrategy.createReplaceEdit((IDocument)document, replaceStart, replaceEnd, formatted, prefs);
        if (replaceEdit != null) {
            edit.addChild((TextEdit)replaceEdit);
        }
        if (replaceEdit != null && replaceStart != 0 && replaceEnd != document.getLength() && (editor = AdtUtils.getActiveTextEditor()) != null) {
            editor.setHighlightRange(replaceEdit.getOffset(), replaceEdit.getText().length(), false);
        }
        return edit;
    }

    static ReplaceEdit createReplaceEdit(IDocument document, int replaceStart, int replaceEnd, String formatted, XmlFormatPreferences prefs) {
        int j;
        int i;
        int lastDifference;
        int firstDifference;
        block41: {
            char c;
            int index;
            block38: {
                index = replaceStart;
                try {
                    while (index > 0) {
                        char c2 = document.getChar(index - 1);
                        if (c2 == '\n') {
                            if (index < replaceStart) {
                                replaceStart = index;
                            }
                            break;
                        }
                        if (!Character.isWhitespace(c2)) {
                            int i2 = 0;
                            while (i2 < formatted.length()) {
                                if (!Character.isWhitespace(formatted.charAt(i2))) {
                                    formatted = formatted.substring(i2);
                                    break block38;
                                }
                                ++i2;
                            }
                            break;
                        }
                        --index;
                    }
                }
                catch (BadLocationException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
            }
            int prevNewlineIndex = -1;
            boolean beginsWithNewline = false;
            int i3 = 0;
            int n = formatted.length();
            while (i3 < n) {
                c = formatted.charAt(i3);
                if (c == '\n') {
                    beginsWithNewline = true;
                    break;
                }
                if (!Character.isWhitespace(c)) break;
                ++i3;
            }
            try {
                index = replaceStart - 1;
                while (index > 0) {
                    char c3 = document.getChar(index);
                    if (c3 == '\n') {
                        if (prevNewlineIndex != -1) {
                            replaceStart = prevNewlineIndex;
                        }
                        prevNewlineIndex = index;
                        if (index > 0 && document.getChar(index - 1) == '\r') {
                            --prevNewlineIndex;
                        }
                    } else if (!Character.isWhitespace(c3)) break;
                    --index;
                }
            }
            catch (BadLocationException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
            if (prefs.removeEmptyLines && prevNewlineIndex != -1 && beginsWithNewline) {
                replaceStart = prevNewlineIndex + 1;
            }
            int nextNewlineIndex = -1;
            try {
                int max = document.getLength();
                index = replaceEnd;
                while (index < max) {
                    c = document.getChar(index);
                    if (c == '\n') {
                        if (nextNewlineIndex != -1) {
                            replaceEnd = nextNewlineIndex + 1;
                        }
                        nextNewlineIndex = index;
                    } else if (!Character.isWhitespace(c)) break;
                    ++index;
                }
            }
            catch (BadLocationException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
            boolean endsWithNewline = false;
            int i4 = formatted.length() - 1;
            while (i4 >= 0) {
                char c4 = formatted.charAt(i4);
                if (c4 == '\n') {
                    endsWithNewline = true;
                    break;
                }
                if (!Character.isWhitespace(c4)) break;
                --i4;
            }
            if (prefs.removeEmptyLines && nextNewlineIndex != -1 && endsWithNewline) {
                replaceEnd = nextNewlineIndex + 1;
            }
            boolean foundDifference = false;
            firstDifference = 0;
            lastDifference = formatted.length();
            i = 0;
            j = replaceStart;
            while (i < formatted.length() && j < replaceEnd) {
                if (formatted.charAt(i) != document.getChar(j)) {
                    firstDifference = i;
                    foundDifference = true;
                    break;
                }
                ++i;
                ++j;
            }
            if (foundDifference) break block41;
            return null;
        }
        try {
            lastDifference = firstDifference + 1;
            i = formatted.length() - 1;
            j = replaceEnd - 1;
            while (i > firstDifference && j > replaceStart) {
                if (formatted.charAt(i) != document.getChar(j)) {
                    lastDifference = i + 1;
                    break;
                }
                --i;
                --j;
            }
        }
        catch (BadLocationException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
        replaceEnd -= formatted.length() - lastDifference;
        replaceEnd = Math.max(replaceStart += firstDifference, replaceEnd);
        formatted = formatted.substring(firstDifference, lastDifference);
        ReplaceEdit replaceEdit = new ReplaceEdit(replaceStart, replaceEnd - replaceStart, formatted);
        return replaceEdit;
    }

    public static XmlFormatStyle guessStyle(IStructuredModel model, Document domDocument) {
        Element rootElement;
        XmlFormatStyle style = XmlFormatStyle.get((Node)domDocument);
        if (style == XmlFormatStyle.FILE) {
            style = XmlFormatStyle.LAYOUT;
        }
        if ((rootElement = domDocument.getDocumentElement()) != null && "resources".equals(rootElement.getTagName())) {
            style = XmlFormatStyle.RESOURCE;
        }
        if (rootElement != null && "selector".equals(rootElement.getTagName())) {
            return XmlFormatStyle.RESOURCE;
        }
        String baseLocation = model.getBaseLocation();
        if (baseLocation != null) {
            if (baseLocation.endsWith("AndroidManifest.xml")) {
                style = XmlFormatStyle.MANIFEST;
            } else {
                int end;
                String resourceFolder;
                String[] segments;
                ResourceType type;
                int lastSlash = baseLocation.lastIndexOf(47);
                if (lastSlash != -1 && (type = ResourceType.getEnum((String)(segments = (resourceFolder = baseLocation.substring((end = baseLocation.lastIndexOf(47, lastSlash - 1)) + 1, lastSlash)).split("-"))[0])) != null) {
                    if (type == ResourceType.XML && style == XmlFormatStyle.RESOURCE) {
                        return style;
                    }
                    style = EclipseXmlPrettyPrinter.get(type);
                }
            }
        }
        return style;
    }

    private Boolean isAndroid(IDocument document) {
        if (this.mIsAndroid == null) {
            if (document instanceof IStructuredDocument) {
                IStructuredDocument structuredDocument = (IStructuredDocument)document;
                IModelManager modelManager = StructuredModelManager.getModelManager();
                IStructuredModel model = modelManager.getModelForRead(structuredDocument);
                if (model != null) {
                    String location = model.getBaseLocation();
                    model.releaseFromRead();
                    if (location != null) {
                        IProject project;
                        IWorkspace workspace;
                        IWorkspaceRoot root;
                        IResource member;
                        if (!location.endsWith("AndroidManifest.xml") && !location.contains("/res/") && (member = (root = (workspace = ResourcesPlugin.getWorkspace()).getRoot()).findMember(location)).exists() && (project = member.getProject()).isAccessible() && !BaseProjectHelper.isAndroidProject(project)) {
                            this.mIsAndroid = false;
                            return false;
                        }
                        if (location.endsWith("/pom.xml")) {
                            this.mIsAndroid = false;
                            return false;
                        }
                    }
                }
            }
            this.mIsAndroid = true;
        }
        return (boolean)this.mIsAndroid;
    }

    public void formatterStarts(IFormattingContext context) {
        ContextBasedFormattingStrategy delegate = this.getDelegate();
        if (delegate != null) {
            delegate.formatterStarts(context);
            super.formatterStarts(context);
            return;
        }
        super.formatterStarts(context);
        this.mRegion = (IRegion)context.getProperty((Object)"formatting.context.region");
        TypedPosition partition = (TypedPosition)context.getProperty((Object)"formatting.context.partition");
        IDocument document = (IDocument)context.getProperty((Object)"formatting.context.medium");
        this.mPartitions.offer(partition);
        this.mDocuments.offer(document);
        if (!this.isAndroid(document).booleanValue() && (delegate = this.getDelegate()) != null) {
            delegate.formatterStarts(context);
        }
    }

    public void formatterStops() {
        ContextBasedFormattingStrategy delegate = this.getDelegate();
        if (delegate != null) {
            delegate.formatterStops();
            super.formatterStops();
            return;
        }
        super.formatterStops();
        this.mRegion = null;
        this.mDocuments.clear();
        this.mPartitions.clear();
    }

    static class IndentationMeasurer {
        private final Map<Integer, String> mDepth = new HashMap<Integer, String>();
        private final Node mStartNode;
        private final Node mEndNode;
        private final IStructuredDocument mDocument;
        private boolean mDone = false;
        private boolean mInRange = false;
        private int mMaxDepth;

        public IndentationMeasurer(Node mStartNode, Node mEndNode, IStructuredDocument document) {
            this.mStartNode = mStartNode;
            this.mEndNode = mEndNode;
            this.mDocument = document;
        }

        public String[] measure(int initialDepth, Node root) {
            this.visit(initialDepth, root);
            String[] indentationLevels = new String[this.mMaxDepth + 1];
            for (Map.Entry<Integer, String> entry : this.mDepth.entrySet()) {
                String indentation;
                int depth = entry.getKey();
                indentationLevels[depth] = indentation = entry.getValue();
            }
            return indentationLevels;
        }

        private void visit(int depth, Node node) {
            if (node.getNodeType() == 1 && this.mDepth.get(depth) == null) {
                try {
                    IndexedRegion region = (IndexedRegion)node;
                    int lineStart = AndroidXmlAutoEditStrategy.findLineStart((IDocument)this.mDocument, region.getStartOffset());
                    int textStart = AndroidXmlAutoEditStrategy.findTextStart((IDocument)this.mDocument, lineStart, region.getEndOffset());
                    if (textStart == region.getStartOffset()) {
                        String indent = this.mDocument.get(lineStart, Math.max(0, textStart - lineStart));
                        this.mDepth.put(depth, indent);
                        if (depth > this.mMaxDepth) {
                            this.mMaxDepth = depth;
                        }
                    }
                }
                catch (BadLocationException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
            }
            NodeList children = node.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node child = children.item(i);
                this.visit(depth + 1, child);
                if (this.mDone) {
                    return;
                }
                ++i;
            }
            if (node == this.mEndNode) {
                this.mDone = true;
            }
        }
    }
}

