/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.descriptors;

import com.android.ide.common.api.IAttributeInfo;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.uimodel.UiAttributeNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.graphics.Image;

public abstract class AttributeDescriptor
implements Comparable<AttributeDescriptor> {
    public static final String ATTRIBUTE_ICON_FILENAME = "attribute";
    private final String mXmlLocalName;
    private final String mNsUri;
    private final IAttributeInfo mAttrInfo;
    private ElementDescriptor mParent;

    public AttributeDescriptor(String xmlLocalName, String nsUri, IAttributeInfo attrInfo) {
        assert (xmlLocalName != null);
        this.mXmlLocalName = xmlLocalName;
        this.mNsUri = nsUri;
        this.mAttrInfo = attrInfo;
    }

    public final String getXmlLocalName() {
        return this.mXmlLocalName;
    }

    public final String getNamespaceUri() {
        return this.mNsUri;
    }

    final void setParent(ElementDescriptor parent) {
        this.mParent = parent;
    }

    public final ElementDescriptor getParent() {
        return this.mParent;
    }

    public boolean isDeprecated() {
        return this.mAttrInfo == null ? false : this.mAttrInfo.getDeprecatedDoc() != null;
    }

    public IAttributeInfo getAttributeInfo() {
        return this.mAttrInfo;
    }

    public Image getGenericIcon() {
        return IconFactory.getInstance().getIcon(ATTRIBUTE_ICON_FILENAME);
    }

    public abstract UiAttributeNode createUiNode(UiElementNode var1);

    @Override
    public int compareTo(AttributeDescriptor other) {
        return this.mXmlLocalName.compareTo(other.mXmlLocalName);
    }
}

