/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.common;

import com.android.ide.common.resources.ResourceFolder;
import com.android.resources.ResourceFolderType;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.animator.AnimationEditorDelegate;
import org.eclipse.andmore.internal.editors.color.ColorEditorDelegate;
import org.eclipse.andmore.internal.editors.common.CommonSourceViewerConfig;
import org.eclipse.andmore.internal.editors.common.CommonXmlDelegate;
import org.eclipse.andmore.internal.editors.drawable.DrawableEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.menu.MenuEditorDelegate;
import org.eclipse.andmore.internal.editors.otherxml.OtherXmlEditorDelegate;
import org.eclipse.andmore.internal.editors.otherxml.PlainXmlEditorDelegate;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.editors.values.ValuesEditorDelegate;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.w3c.dom.Document;

public class CommonXmlEditor
extends AndroidXmlEditor
implements IShowEditorInput {
    public static final String ID = "org.eclipse.andmore.editors.CommonXmlEditor";
    private static final CommonXmlDelegate.IDelegateCreator[] DELEGATES = new CommonXmlDelegate.IDelegateCreator[]{new LayoutEditorDelegate.Creator(), new ValuesEditorDelegate.Creator(), new AnimationEditorDelegate.Creator(), new ColorEditorDelegate.Creator(), new DrawableEditorDelegate.Creator(), new MenuEditorDelegate.Creator(), new OtherXmlEditorDelegate.Creator()};
    public static final String[] LEGACY_EDITOR_IDS = new String[]{"org.eclipse.andmore.editors.layout.LayoutEditor", "org.eclipse.andmore.editors.resources.ResourcesEditor", "org.eclipse.andmore.editors.animator.AnimationEditor", "org.eclipse.andmore.editors.color.ColorEditor", "org.eclipse.andmore.editors.drawable.DrawableEditor", "org.eclipse.andmore.editors.menu.MenuEditor", "org.eclipse.andmore.editors.xml.XmlEditor"};
    private CommonXmlDelegate mDelegate = null;

    @Override
    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof IFileEditorInput) {
            ResourceFolder resFolder;
            ResourceFolderType type;
            boolean mustChange;
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            IFile file = fileInput.getFile();
            IEditorDescriptor file_desc = IDE.getDefaultEditor((IFile)file);
            String id = file_desc == null ? null : file_desc.getId();
            boolean bl = mustChange = id != null && !id.equals(ID) && id.startsWith("org.eclipse.andmore.editors");
            if (!mustChange) {
                id = site.getId();
                boolean bl2 = mustChange = id != null && !id.equals(ID) && id.startsWith("org.eclipse.andmore.editors");
            }
            if (mustChange) {
                IDE.setDefaultEditor((IFile)file, (String)ID);
                AndmoreAndroidPlugin.log(1, "Changed legacy editor ID %s for %s", id, file.getFullPath());
            }
            ResourceFolderType resourceFolderType = type = (resFolder = ResourceManager.getInstance().getResourceFolder(file)) == null ? null : resFolder.getType();
            if (type == null) {
                String folderName = AdtUtils.getParentFolderName(editorInput);
                type = ResourceFolderType.getFolderType((String)folderName);
            }
            if (type != null) {
                CommonXmlDelegate.IDelegateCreator[] iDelegateCreatorArray = DELEGATES;
                int n = DELEGATES.length;
                int n2 = 0;
                while (n2 < n) {
                    CommonXmlDelegate.IDelegateCreator creator = iDelegateCreatorArray[n2];
                    this.mDelegate = creator.createForFile(this, type);
                    if (this.mDelegate != null) break;
                    ++n2;
                }
            }
            if (this.mDelegate == null) {
                AndmoreAndroidPlugin.log(1, "No valid Android XML Editor Delegate found for file %1$s [Res %2$s, type %3$s]", file.getFullPath(), resFolder, type);
                this.mDelegate = new PlainXmlEditorDelegate(this);
            }
        } else if (editorInput instanceof IURIEditorInput) {
            String folderName = AdtUtils.getParentFolderName(editorInput);
            ResourceFolderType type = ResourceFolderType.getFolderType((String)folderName);
            if (type == ResourceFolderType.LAYOUT) {
                this.mDelegate = new OtherXmlEditorDelegate(this);
            } else if (type != null) {
                CommonXmlDelegate.IDelegateCreator[] iDelegateCreatorArray = DELEGATES;
                int n = DELEGATES.length;
                int n3 = 0;
                while (n3 < n) {
                    CommonXmlDelegate.IDelegateCreator creator = iDelegateCreatorArray[n3];
                    this.mDelegate = creator.createForFile(this, type);
                    if (this.mDelegate != null) break;
                    ++n3;
                }
            }
            if (this.mDelegate == null) {
                AndmoreAndroidPlugin.log(1, "No valid Android XML Editor Delegate found for file %1$s [Res %2$s, type %3$s]", ((IURIEditorInput)editorInput).getURI().toString(), folderName, type);
                this.mDelegate = new PlainXmlEditorDelegate(this);
            }
        }
        if (this.mDelegate == null) {
            AndmoreAndroidPlugin.log(1, "Android XML Editor cannot process non-file input %1$s", editorInput == null ? "null" : editorInput.toString());
            throw new PartInitException("Android XML Editor cannot process this input.");
        }
        super.init(site, editorInput);
    }

    @Override
    public UiElementNode getUiRootNode() {
        return this.mDelegate == null ? null : this.mDelegate.getUiRootNode();
    }

    public CommonXmlDelegate getDelegate() {
        return this.mDelegate;
    }

    @Override
    public void dispose() {
        if (this.mDelegate != null) {
            this.mDelegate.dispose();
        }
        super.dispose();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.mDelegate != null) {
            this.mDelegate.delegateDoSave(monitor);
        }
    }

    @Override
    public boolean isSaveAsAllowed() {
        return this.mDelegate == null ? false : this.mDelegate.isSaveAsAllowed();
    }

    @Override
    protected void createFormPages() {
        if (this.mDelegate != null) {
            this.mDelegate.delegateCreateFormPages();
        }
    }

    @Override
    protected void postCreatePages() {
        super.postCreatePages();
        if (this.mDelegate != null) {
            this.mDelegate.delegatePostCreatePages();
        }
    }

    @Override
    protected void addPages() {
        super.addPages();
        ISourceViewer ssv = this.getStructuredSourceViewer();
        if (this.mDelegate != null && ssv instanceof ISourceViewerExtension2) {
            ((ISourceViewerExtension2)ssv).unconfigure();
            ssv.configure((SourceViewerConfiguration)new CommonSourceViewerConfig(this.mDelegate.getAndroidContentAssistProcessor()));
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        assert (this.mDelegate != null);
        if (this.mDelegate != null) {
            this.mDelegate.delegateSetInput(input);
        }
    }

    public void setInputWithNotify(IEditorInput input) {
        super.setInputWithNotify(input);
        if (this.mDelegate instanceof LayoutEditorDelegate) {
            ((LayoutEditorDelegate)this.mDelegate).delegateSetInputWithNotify(input);
        }
    }

    @Override
    protected void xmlModelChanged(Document xml_doc) {
        if (this.mDelegate != null) {
            this.mDelegate.delegateXmlModelChanged(xml_doc);
        }
    }

    @Override
    protected Job runLint() {
        if (this.mDelegate != null && this.getEditorInput() instanceof IFileEditorInput) {
            return this.mDelegate.delegateRunLint();
        }
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object value;
        if (this.mDelegate != null && (value = this.mDelegate.delegateGetAdapter(adapter)) != null) {
            return value;
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void pageChange(int newPageIndex) {
        if (this.mDelegate != null) {
            this.mDelegate.delegatePageChange(newPageIndex);
        }
        super.pageChange(newPageIndex);
        if (this.mDelegate != null) {
            this.mDelegate.delegatePostPageChange(newPageIndex);
        }
    }

    @Override
    protected int getPersistenceCategory() {
        if (this.mDelegate != null) {
            return this.mDelegate.delegateGetPersistenceCategory();
        }
        return 4;
    }

    @Override
    public void initUiRootNode(boolean force) {
        if (this.mDelegate != null) {
            this.mDelegate.delegateInitUiRootNode(force);
        }
    }

    @Override
    public IFormPage setActivePage(String pageId) {
        IFormPage page = super.setActivePage(pageId);
        if (this.mDelegate != null) {
            return this.mDelegate.delegatePostSetActivePage(page, pageId);
        }
        return page;
    }

    public void showEditorInput(IEditorInput editorInput) {
        if (this.mDelegate instanceof LayoutEditorDelegate) {
            ((LayoutEditorDelegate)this.mDelegate).showEditorInput(editorInput);
        }
    }

    @Override
    public boolean supportsFormatOnGuiEdit() {
        if (this.mDelegate != null) {
            return this.mDelegate.delegateSupportsFormatOnGuiEdit();
        }
        return super.supportsFormatOnGuiEdit();
    }

    @Override
    public void activated() {
        super.activated();
        if (this.mDelegate != null) {
            this.mDelegate.delegateActivated();
        }
    }

    @Override
    public void deactivated() {
        super.deactivated();
        if (this.mDelegate != null) {
            this.mDelegate.delegateDeactivated();
        }
    }

    public String getPartName() {
        String name;
        if (this.mDelegate != null && (name = this.mDelegate.delegateGetPartName()) != null) {
            return name;
        }
        return super.getPartName();
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public void setPageText(int pageIndex, String text) {
        super.setPageText(pageIndex, text);
    }

    public void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    public int getCurrentPage() {
        return super.getCurrentPage();
    }
}

