/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.common;

import com.android.ide.common.resources.ResourceFolder;
import com.android.resources.ResourceFolderType;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorMatchingStrategy;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class CommonMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IFile file = fileInput.getFile();
            if (file.getParent().getName().startsWith("layout")) {
                ResourceFolder resFolder = ResourceManager.getInstance().getResourceFolder(file);
                if (resFolder != null && resFolder.getType() == ResourceFolderType.LAYOUT) {
                    if (AdtPrefs.getPrefs().isSharedLayoutEditor()) {
                        LayoutEditorMatchingStrategy m = new LayoutEditorMatchingStrategy();
                        return m.matches(editorRef, (IEditorInput)fileInput);
                    }
                    if (!editorRef.getName().endsWith(file.getName()) || !editorRef.getId().equals("org.eclipse.andmore.editors.CommonXmlEditor")) {
                        return false;
                    }
                }
            } else if (!file.getName().equals(editorRef.getName()) || !editorRef.getId().equals("org.eclipse.andmore.editors.CommonXmlEditor")) {
                return false;
            }
            try {
                return input.equals(editorRef.getEditorInput());
            }
            catch (PartInitException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
        }
        return false;
    }
}

