/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.animator;

import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.internal.editors.AndroidContentAssist;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.IDescriptorProvider;
import org.eclipse.andmore.internal.editors.descriptors.SeparatorAttributeDescriptor;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.w3c.dom.Node;

public final class AnimationContentAssist
extends AndroidContentAssist {
    private static final String OBJECT_ANIMATOR = "objectAnimator";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String INTERPOLATOR_PROPERTY_NAME = "interpolator";
    private static final String INTERPOLATOR_NAME_SUFFIX = "_interpolator";

    public AnimationContentAssist() {
        super(10);
    }

    @Override
    protected int getRootDescriptorId() {
        String folderName = AdtUtils.getParentFolderName(this.mEditor.getEditorInput());
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
        if (folderType == ResourceFolderType.ANIM) {
            return 11;
        }
        return 10;
    }

    @Override
    protected boolean computeAttributeValues(List<ICompletionProposal> proposals, int offset, String parentTagName, String attributeName, Node node, String wordPrefix, boolean skipEndTag, int replaceLength) {
        if (attributeName.endsWith(INTERPOLATOR_PROPERTY_NAME)) {
            if (!wordPrefix.startsWith("@android:anim/")) {
                AndroidTargetData data = this.mEditor.getTargetData();
                ResourceRepository repository = data.getFrameworkResources();
                ArrayList<String> interpolators = new ArrayList<String>();
                String base = "@android:" + ResourceType.ANIM.getName() + '/';
                for (ResourceItem item : repository.getResourceItemsOfType(ResourceType.ANIM)) {
                    String name = item.getName();
                    if (!name.endsWith(INTERPOLATOR_NAME_SUFFIX)) continue;
                    interpolators.add(String.valueOf(base) + item.getName());
                }
                this.addMatchingProposals(proposals, interpolators.toArray(), offset, node, wordPrefix, '\u0000', true, false, skipEndTag, replaceLength);
            }
            return super.computeAttributeValues(proposals, offset, parentTagName, attributeName, node, wordPrefix, skipEndTag, replaceLength);
        }
        if (parentTagName.equals(OBJECT_ANIMATOR) && attributeName.endsWith(PROPERTY_NAME)) {
            IDescriptorProvider descriptorProvider;
            AndroidTargetData data;
            String attributePrefix = wordPrefix;
            if (AnimationContentAssist.startsWith(attributePrefix, "android:")) {
                attributePrefix = attributePrefix.substring("android:".length());
            }
            if ((data = this.mEditor.getTargetData()) != null && (descriptorProvider = data.getDescriptorProvider(2)) != null) {
                ElementDescriptor[] rootElementDescriptors = descriptorProvider.getRootElementDescriptors();
                HashMap<String, AttributeDescriptor> matches = new HashMap<String, AttributeDescriptor>(180);
                ElementDescriptor[] elementDescriptorArray = rootElementDescriptors;
                int n = rootElementDescriptors.length;
                int name = 0;
                while (name < n) {
                    ElementDescriptor elementDesc = elementDescriptorArray[name];
                    AttributeDescriptor[] attributeDescriptorArray = elementDesc.getAttributes();
                    int n2 = attributeDescriptorArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        EnumSet formats;
                        String name2;
                        AttributeDescriptor desc = attributeDescriptorArray[n3];
                        if (!(desc instanceof SeparatorAttributeDescriptor) && AnimationContentAssist.startsWith(name2 = desc.getXmlLocalName(), attributePrefix) && ((formats = desc.getAttributeInfo().getFormats()).contains(IAttributeInfo.Format.INTEGER) || formats.contains(IAttributeInfo.Format.FLOAT))) {
                            matches.put(name2, desc);
                        }
                        ++n3;
                    }
                    ++name;
                }
                ArrayList sorted = new ArrayList(matches.size());
                sorted.addAll(matches.values());
                Collections.sort(sorted);
                ArrayList<Pair> pairs = new ArrayList<Pair>(sorted.size());
                for (AttributeDescriptor d : sorted) {
                    pairs.add(Pair.of((Object)d.getXmlLocalName(), (Object)d.getAttributeInfo().getJavaDoc()));
                }
                this.addMatchingProposals(proposals, pairs.toArray(), offset, node, wordPrefix, '\u0000', true, false, skipEndTag, replaceLength);
            }
            return false;
        }
        return super.computeAttributeValues(proposals, offset, parentTagName, attributeName, node, wordPrefix, skipEndTag, replaceLength);
    }
}

