/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class AndroidTextEditor
extends FormEditor
implements IResourceChangeListener {
    private static final String PREF_CURRENT_PAGE = "_current_page";
    private static String BROWSER_ID = "android";
    public static final String TEXT_EDITOR_ID = "editor_part";
    public static final int TEXT_WIDTH_HINT = 50;
    private int mTextPageIndex;
    private TextEditor mTextEditor;
    private boolean mIsCreatingPage = false;
    private IDocument mDocument;

    protected abstract void createFormPages();

    protected void postCreatePages() {
    }

    protected void onDocumentChanged(DocumentEvent event) {
    }

    protected void addPages() {
        this.createAndroidPages();
        this.selectDefaultPage(null);
    }

    protected void createAndroidPages() {
        this.mIsCreatingPage = true;
        this.createFormPages();
        this.createTextEditor();
        this.createUndoRedoActions();
        this.postCreatePages();
        this.mIsCreatingPage = false;
    }

    public boolean isCreatingPages() {
        return this.mIsCreatingPage;
    }

    private void createUndoRedoActions() {
        IActionBars bars = this.getEditorSite().getActionBars();
        if (bars != null) {
            IAction action = this.mTextEditor.getAction(ActionFactory.UNDO.getId());
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), action);
            action = this.mTextEditor.getAction(ActionFactory.REDO.getId());
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), action);
            bars.updateActionBars();
        }
    }

    protected void selectDefaultPage(String defaultPageId) {
        if (defaultPageId == null && this.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            QualifiedName qname = new QualifiedName("org.eclipse.andmore", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + PREF_CURRENT_PAGE);
            try {
                String pageId = file.getPersistentProperty(qname);
                if (pageId != null) {
                    defaultPageId = pageId;
                }
            }
            catch (CoreException coreException) {}
        }
        if (defaultPageId != null) {
            try {
                this.setActivePage(Integer.parseInt(defaultPageId));
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "Selecting page '%s' in AndroidXmlEditor failed", defaultPageId);
            }
        }
    }

    protected void removePages() {
        int count = this.getPageCount();
        int i = count - 1;
        while (i >= 0) {
            this.removePage(i);
            --i;
        }
    }

    public IFormPage setActivePage(String pageId) {
        if (pageId.equals(TEXT_EDITOR_ID)) {
            super.setActivePage(this.mTextPageIndex);
            return null;
        }
        return super.setActivePage(pageId);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (this.mIsCreatingPage) {
            return;
        }
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            QualifiedName qname = new QualifiedName("org.eclipse.andmore", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + PREF_CURRENT_PAGE);
            try {
                file.setPersistentProperty(qname, Integer.toString(newPageIndex));
            }
            catch (CoreException coreException) {}
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = AndroidTextEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)AndroidTextEditor.this.mTextEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(AndroidTextEditor.this.mTextEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public IFile getFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return null;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        this.getEditor(this.mTextPageIndex).doSave(monitor);
    }

    public void doSaveAs() {
        this.commitPages(true);
        IEditorPart editor = this.getEditor(this.mTextPageIndex);
        editor.doSaveAs();
        this.setPageText(this.mTextPageIndex, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void commitPages(boolean onSave) {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                IFormPage form_page;
                IManagedForm managed_form;
                Object page = this.pages.get(i);
                if (page != null && page instanceof IFormPage && (managed_form = (form_page = (IFormPage)page).getManagedForm()) != null && managed_form.isDirty()) {
                    managed_form.commit(onSave);
                }
                ++i;
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public final IHyperlinkListener createHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                super.linkActivated(e);
                String link = e.data.toString();
                if (link.startsWith("http") || link.startsWith("file:/")) {
                    AndroidTextEditor.this.openLinkInBrowser(link);
                } else if (link.startsWith("page:")) {
                    AndroidTextEditor.this.setActivePage(link.substring(5));
                }
            }
        };
    }

    private void openLinkInBrowser(String link) {
        try {
            IWorkbenchBrowserSupport wbs = WorkbenchBrowserSupport.getInstance();
            wbs.createBrowser(BROWSER_ID).openURL(new URL(link));
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void createTextEditor() {
        try {
            int index;
            this.mTextEditor = new TextEditor();
            this.mTextPageIndex = index = this.addPage((IEditorPart)this.mTextEditor, this.getEditorInput());
            this.setPageText(index, this.mTextEditor.getTitle());
            IDocumentProvider provider = this.mTextEditor.getDocumentProvider();
            this.mDocument = provider.getDocument((Object)this.getEditorInput());
            this.mDocument.addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    AndroidTextEditor.this.onDocumentChanged(event);
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Android Text Editor Error", null, (IStatus)e.getStatus());
        }
    }

    public IDocument getDocument() {
        return this.mDocument;
    }

    public IProject getProject() {
        FileEditorInput fileInput;
        IFile inputFile;
        IEditorInput input;
        if (this.mTextEditor != null && (input = this.mTextEditor.getEditorInput()) instanceof FileEditorInput && (inputFile = (fileInput = (FileEditorInput)input).getFile()) != null) {
            return inputFile.getProject();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void wrapRewriteSession(Runnable operation) {
        if (this.mDocument instanceof IDocumentExtension4) {
            IDocumentExtension4 doc4 = (IDocumentExtension4)this.mDocument;
            DocumentRewriteSession session = null;
            try {
                try {
                    session = doc4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                    operation.run();
                    return;
                }
                catch (IllegalStateException e) {
                    AndmoreAndroidPlugin.log(e, "wrapRewriteSession failed", new Object[0]);
                    e.printStackTrace();
                    if (session == null) return;
                    doc4.stopRewriteSession(session);
                }
                return;
            }
            finally {
                if (session != null) {
                    doc4.stopRewriteSession(session);
                }
            }
        } else {
            operation.run();
        }
    }
}

