/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build.builders;

import com.android.SdkConstants;
import com.android.io.IAbstractFolder;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.build.RenderScriptChecker;
import com.android.sdklib.build.RenderScriptProcessor;
import com.android.sdklib.internal.build.BuildConfigGenerator;
import com.android.sdklib.internal.build.SymbolLoader;
import com.android.sdklib.internal.build.SymbolWriter;
import com.android.sdklib.io.FileOp;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.xml.AndroidManifest;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.AaptParser;
import org.eclipse.andmore.internal.build.AidlProcessor;
import org.eclipse.andmore.internal.build.Messages;
import org.eclipse.andmore.internal.build.RenderScriptLauncher;
import org.eclipse.andmore.internal.build.RsSourceChangeHandler;
import org.eclipse.andmore.internal.build.builders.BaseBuilder;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.resources.manager.ProjectResources;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.andmore.internal.sdk.AdtManifestMergeCallback;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.io.IFolderWrapper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;

public class PreCompilerBuilder
extends BaseBuilder {
    public static final String ID = "org.eclipse.andmore.PreCompilerBuilder";
    public static final String RELEASE_REQUESTED = "android.releaseBuild";
    private static final String PROPERTY_PACKAGE = "manifestPackage";
    private static final String PROPERTY_MERGE_MANIFEST = "mergeManifest";
    private static final String PROPERTY_COMPILE_RESOURCES = "compileResources";
    private static final String PROPERTY_COMPILE_BUILDCONFIG = "createBuildConfig";
    private static final String PROPERTY_BUILDCONFIG_MODE = "buildConfigMode";
    private static final boolean MANIFEST_MERGER_ENABLED_DEFAULT = false;
    private static final String MANIFEST_MERGER_PROPERTY = "manifestmerger.enabled";
    private boolean mMustMergeManifest = false;
    private boolean mMustCompileResources = false;
    private boolean mMustCreateBuildConfig = false;
    private boolean mLastBuildConfigMode;
    private String mManifestPackage;
    private IFolder mGenFolder;
    private DerivedProgressMonitor mDerivedProgressMonitor;
    private AidlProcessor mAidlProcessor;
    private RsSourceChangeHandler mRenderScriptSourceChangeHandler;

    /*
     * Exception decompiling
     */
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IFolder getResOutFolder(IFolder androidOutputFolder) {
        return androidOutputFolder.getFolder("res/bc");
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        if (DEBUG_LOG) {
            AndmoreAndroidPlugin.log(1, "%s CLEAN(PRE)", this.getProject().getName());
        }
        this.doClean(this.getProject(), monitor);
        if (this.mGenFolder != null) {
            this.mGenFolder.refreshLocal(2, monitor);
        }
    }

    private void doClean(IProject project, IProgressMonitor monitor) throws CoreException {
        AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.Removing_Generated_Classes);
        if (this.mGenFolder != null && this.mGenFolder.exists()) {
            this.mGenFolder.setDerived(false, monitor);
            this.removeDerivedResources((IResource)this.mGenFolder, monitor);
        }
        this.removeMarkersFromContainer((IContainer)project, "org.eclipse.andmore.common.aaptProblem");
        this.removeMarkersFromContainer((IContainer)project, "org.eclipse.andmore.common.xmlProblem");
        this.removeMarkersFromContainer((IContainer)project, "org.eclipse.andmore.common.aidlProblem");
        this.removeMarkersFromContainer((IContainer)project, "org.eclipse.andmore.common.rsProblem");
        this.removeMarkersFromContainer((IContainer)project, "org.eclipse.andmore.manifMergerProblem");
        this.removeMarkersFromContainer((IContainer)project, "org.eclipse.andmore.common.androidProblem");
        EclipseLintClient.clearMarkers((IResource)project);
        ProjectResources res = ResourceManager.getInstance().getProjectResources(project);
        res.clear();
    }

    protected void startupOnInitialize() {
        try {
            super.startupOnInitialize();
            IProject project = this.getProject();
            this.mManifestPackage = this.loadProjectStringProperty(PROPERTY_PACKAGE);
            this.mGenFolder = project.getFolder("gen");
            this.mDerivedProgressMonitor = new DerivedProgressMonitor(this.mGenFolder);
            this.mMustMergeManifest = this.loadProjectBooleanProperty(PROPERTY_MERGE_MANIFEST, true);
            this.mMustCompileResources = this.loadProjectBooleanProperty(PROPERTY_COMPILE_RESOURCES, true);
            this.mMustCreateBuildConfig = this.loadProjectBooleanProperty(PROPERTY_COMPILE_BUILDCONFIG, true);
            Boolean v = ProjectHelper.loadBooleanProperty((IResource)project, PROPERTY_BUILDCONFIG_MODE);
            if (v == null) {
                this.mMustCreateBuildConfig = true;
            } else {
                this.mLastBuildConfigMode = v;
            }
        }
        catch (Throwable throwable) {
            AndmoreAndroidPlugin.log(throwable, "Failed to finish PrecompilerBuilder#startupOnInitialize()", new Object[0]);
        }
    }

    private void setupSourceProcessors(IJavaProject javaProject, ProjectState projectState, List<IPath> sourceFolderPathList, IFolder androidOutputFolder) {
        if (this.mAidlProcessor == null) {
            this.mAidlProcessor = new AidlProcessor(javaProject, this.mBuildToolInfo, this.mGenFolder);
        } else {
            this.mAidlProcessor.setBuildToolInfo(this.mBuildToolInfo);
        }
        ArrayList sourceFolders = Lists.newArrayListWithCapacity((int)sourceFolderPathList.size());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath path : sourceFolderPathList) {
            IPath fullPath;
            IResource resource = root.findMember(path);
            if (resource == null || !resource.exists() || resource.getType() != 2 || (fullPath = resource.getLocation()) == null) continue;
            sourceFolders.add(fullPath.toFile());
        }
        RenderScriptChecker checker = new RenderScriptChecker((List)sourceFolders, androidOutputFolder.getLocation().toFile());
        this.mRenderScriptSourceChangeHandler = new RsSourceChangeHandler(checker);
    }

    private int compileRs(int minSdkValue, ProjectState projectState, IFolder androidOutputFolder, IFolder resOutFolder, IProgressMonitor monitor) throws IOException, InterruptedException {
        if (!this.mRenderScriptSourceChangeHandler.mustCompile()) {
            return 0;
        }
        RenderScriptChecker checker = this.mRenderScriptSourceChangeHandler.getChecker();
        List inputs = checker.findInputFiles();
        List importFolders = checker.getSourceFolders();
        File buildFolder = androidOutputFolder.getLocation().toFile();
        int rsTarget = minSdkValue == -1 ? 11 : minSdkValue;
        String rsTargetStr = projectState.getProperty("renderscript.target");
        if (rsTargetStr != null) {
            try {
                rsTarget = Integer.parseInt(rsTargetStr);
            }
            catch (NumberFormatException e) {
                this.handleException(e, String.format("Property %s is not an integer.", "renderscript.target"));
                return 0;
            }
        }
        RenderScriptProcessor processor = new RenderScriptProcessor(inputs, importFolders, buildFolder, this.mGenFolder.getLocation().toFile(), resOutFolder.getLocation().toFile(), new File(buildFolder, "rsObj"), new File(buildFolder, "rsLibs"), this.mBuildToolInfo, rsTarget, false, 3, projectState.getRenderScriptSupportMode());
        checker.cleanDependencies();
        processor.cleanOldOutput((Collection)checker.getOldOutputs());
        RenderScriptLauncher launcher = new RenderScriptLauncher(this.getProject(), this.mGenFolder, resOutFolder, monitor, AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE);
        processor.build((RenderScriptProcessor.CommandLineLauncher)launcher);
        return 3;
    }

    private void handleBuildConfig(Map args) throws IOException, CoreException {
        boolean debugMode = !args.containsKey(RELEASE_REQUESTED);
        BuildConfigGenerator generator = new BuildConfigGenerator(this.mGenFolder.getLocation().toOSString(), this.mManifestPackage, debugMode);
        if (!this.mMustCreateBuildConfig) {
            IFolder folder = this.getGenManifestPackageFolder();
            if (!folder.exists((IPath)new Path("BuildConfig.java"))) {
                this.mMustCreateBuildConfig = true;
                AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, this.getProject(), String.format("Class %1$s is missing!", "BuildConfig.java"));
            } else if (debugMode != this.mLastBuildConfigMode) {
                this.mMustCreateBuildConfig = true;
                AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, this.getProject(), String.format("Different build mode, must update %1$s!", "BuildConfig.java"));
            }
        }
        if (this.mMustCreateBuildConfig) {
            if (DEBUG_LOG) {
                AndmoreAndroidPlugin.log(1, "%s generating BuilderConfig!", this.getProject().getName());
            }
            AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, this.getProject(), String.format("Generating %1$s...", "BuildConfig.java"));
            generator.generate();
            this.mMustCreateBuildConfig = false;
            this.saveProjectBooleanProperty(PROPERTY_COMPILE_BUILDCONFIG, this.mMustCreateBuildConfig);
            this.mLastBuildConfigMode = debugMode;
            this.saveProjectBooleanProperty(PROPERTY_BUILDCONFIG_MODE, this.mLastBuildConfigMode);
        }
    }

    private boolean mergeManifest(IFolder androidOutFolder, List<IProject> libProjects, boolean enabled) throws CoreException {
        if (DEBUG_LOG) {
            AndmoreAndroidPlugin.log(1, "%s merging manifests!", this.getProject().getName());
        }
        IFile outFile = androidOutFolder.getFile("AndroidManifest.xml");
        IFile manifest = this.getProject().getFile("AndroidManifest.xml");
        this.removeMarkersFromResource((IResource)this.getProject(), "org.eclipse.andmore.manifMergerProblem");
        if (!enabled || libProjects.size() == 0) {
            try {
                new FileOp().copyFile(manifest.getLocation().toFile(), outFile.getLocation().toFile());
                outFile.refreshLocal(2, (IProgressMonitor)this.mDerivedProgressMonitor);
                this.mMustMergeManifest = false;
                this.saveProjectBooleanProperty(PROPERTY_MERGE_MANIFEST, false);
            }
            catch (IOException e) {
                this.handleException(e, "Failed to copy Manifest");
                return false;
            }
        } else {
            final ArrayList errors = new ArrayList();
            ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)new ILogger(){

                public void warning(String warningFormat, Object ... args) {
                    AndmoreAndroidPlugin.printToConsole(PreCompilerBuilder.this.getProject(), String.format(warningFormat, args));
                }

                public void info(String msgFormat, Object ... args) {
                    AndmoreAndroidPlugin.printToConsole(PreCompilerBuilder.this.getProject(), String.format(msgFormat, args));
                }

                public void verbose(String msgFormat, Object ... args) {
                    this.info(msgFormat, args);
                }

                public void error(Throwable t, String errorFormat, Object ... args) {
                    errors.add(String.format(errorFormat, args));
                }
            }), (ICallback)new AdtManifestMergeCallback());
            File[] libManifests = new File[libProjects.size()];
            int libIndex = 0;
            for (IProject lib : libProjects) {
                libManifests[libIndex++] = lib.getFile("AndroidManifest.xml").getLocation().toFile();
            }
            if (!merger.process(outFile.getLocation().toFile(), manifest.getLocation().toFile(), libManifests, null, null)) {
                if (errors.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (String s : errors) {
                        sb.append(s).append('\n');
                    }
                    this.markProject("org.eclipse.andmore.manifMergerProblem", sb.toString(), 2);
                } else if (errors.size() == 1) {
                    this.markProject("org.eclipse.andmore.manifMergerProblem", (String)errors.get(0), 2);
                } else {
                    this.markProject("org.eclipse.andmore.manifMergerProblem", "Unknown error merging manifest", 2);
                }
                return false;
            }
            outFile.refreshLocal(2, (IProgressMonitor)this.mDerivedProgressMonitor);
            this.mMustMergeManifest = false;
            this.saveProjectBooleanProperty(PROPERTY_MERGE_MANIFEST, false);
        }
        return true;
    }

    private void handleResources(IProject project, String javaPackage, IAndroidTarget projectTarget, IFile manifest, IFolder resOutFolder, List<IProject> libProjects, boolean isLibrary, IFile proguardFile) throws CoreException, BaseBuilder.AbortBuildException {
        IPath manifestLocation;
        IFolder resFolder = project.getFolder("/res");
        IPath outputLocation = this.mGenFolder.getLocation();
        IPath resLocation = resFolder.getLocation();
        IPath iPath = manifestLocation = manifest == null ? null : manifest.getLocation();
        if (outputLocation != null && resLocation != null && manifestLocation != null) {
            String osOutputPath = outputLocation.toOSString();
            String osResPath = resLocation.toOSString();
            String osManifestPath = manifestLocation.toOSString();
            this.removeMarkersFromResource((IResource)manifest, "org.eclipse.andmore.common.aaptProblem");
            this.removeMarkersFromContainer((IContainer)resFolder, "org.eclipse.andmore.common.aaptProblem");
            AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.Preparing_Generated_Files);
            IFolder mainPackageFolder = this.getGenManifestPackageFolder();
            ArrayList libResFolders = Lists.newArrayList();
            ArrayList libRFiles = Lists.newArrayList();
            if (libProjects != null) {
                for (IProject lib : libProjects) {
                    IFolder libResFolder = lib.getFolder("res");
                    if (libResFolder.exists()) {
                        libResFolders.add(libResFolder);
                    }
                    try {
                        String libJavaPackage = AndroidManifest.getPackage((IAbstractFolder)new IFolderWrapper((IContainer)lib));
                        if (libJavaPackage.equals(javaPackage)) continue;
                        IFolder libOutput = BaseProjectHelper.getAndroidOutputFolder(lib);
                        File libOutputFolder = libOutput.getLocation().toFile();
                        libRFiles.add(Pair.of((Object)new File(libOutputFolder, "R.txt"), (Object)libJavaPackage));
                    }
                    catch (Exception exception) {}
                }
            }
            String proguardFilePath = proguardFile != null ? proguardFile.getLocation().toOSString() : null;
            File resOutFile = resOutFolder.getLocation().toFile();
            String resOutPath = resOutFile.isDirectory() ? resOutFile.getAbsolutePath() : null;
            this.execAapt(project, projectTarget, osOutputPath, resOutPath, osResPath, osManifestPath, mainPackageFolder, libResFolders, libRFiles, isLibrary, proguardFilePath);
        }
    }

    private void execAapt(IProject project, IAndroidTarget projectTarget, String osOutputPath, String osBcOutPath, String osResPath, String osManifestPath, IFolder packageFolder, ArrayList<IFolder> libResFolders, List<Pair<File, String>> libRFiles, boolean isLibrary, String proguardFile) throws BaseBuilder.AbortBuildException {
        IFile manifestJavaFile = packageFolder.getFile("Manifest.java");
        manifestJavaFile.getLocation().toFile().delete();
        ArrayList<String> array = new ArrayList<String>();
        String aaptPath = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        array.add(aaptPath);
        array.add("package");
        array.add("-m");
        if (AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE) {
            array.add("-v");
        }
        if (isLibrary) {
            array.add("--non-constant-id");
        }
        if (libResFolders.size() > 0) {
            array.add("--auto-add-overlay");
        }
        File outputFolder = BaseProjectHelper.getAndroidOutputFolder(project).getLocation().toFile();
        if (isLibrary || !libRFiles.isEmpty()) {
            array.add("--output-text-symbols");
            array.add(outputFolder.getAbsolutePath());
        }
        array.add("-J");
        array.add(osOutputPath);
        array.add("-M");
        array.add(osManifestPath);
        if (osBcOutPath != null) {
            array.add("-S");
            array.add(osBcOutPath);
        }
        array.add("-S");
        array.add(osResPath);
        for (IFolder libResFolder : libResFolders) {
            array.add("-S");
            array.add(libResFolder.getLocation().toOSString());
        }
        array.add("-I");
        array.add(projectTarget.getPath(1));
        if (proguardFile != null && proguardFile.length() > 0) {
            array.add("-G");
            array.add(proguardFile);
        }
        if (AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE) {
            StringBuilder sb = new StringBuilder();
            for (String c : array) {
                sb.append(c);
                sb.append(' ');
            }
            String cmd_line = sb.toString();
            AndmoreAndroidPlugin.printToConsole(project, cmd_line);
        }
        try {
            try {
                File rFile;
                Process process = Runtime.getRuntime().exec(array.toArray(new String[array.size()]));
                ArrayList<String> stdErr = new ArrayList<String>();
                int returnCode = this.grabProcessOutput(process, stdErr);
                boolean parsingError = AaptParser.parseOutput(stdErr, project);
                if (parsingError) {
                    if (returnCode != 0) {
                        AndmoreAndroidPlugin.printErrorToConsole(project, stdErr.toArray());
                    } else {
                        AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.NORMAL, project, stdErr.toArray());
                    }
                }
                if (returnCode != 0) {
                    if (parsingError) {
                        this.markProject("org.eclipse.andmore.adtProblem", Messages.Unparsed_AAPT_Errors, 2);
                    } else if (stdErr.size() == 0) {
                        this.markProject("org.eclipse.andmore.adtProblem", String.format(Messages.AAPT_Exec_Error_d, returnCode), 2);
                    }
                    AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.AAPT_Error);
                    throw new BaseBuilder.AbortBuildException();
                }
                if (!isLibrary && !libRFiles.isEmpty() && (rFile = new File(outputFolder, "R.txt")).isFile()) {
                    SymbolLoader fullSymbolValues = new SymbolLoader(rFile);
                    fullSymbolValues.load();
                    ArrayListMultimap libMap = ArrayListMultimap.create();
                    for (Pair<File, String> lib : libRFiles) {
                        String libPackage = (String)lib.getSecond();
                        File rText = (File)lib.getFirst();
                        if (!rText.isFile()) continue;
                        SymbolLoader libSymbols = new SymbolLoader(rText);
                        libSymbols.load();
                        libMap.put((Object)libPackage, (Object)libSymbols);
                    }
                    for (String packageName : libMap.keySet()) {
                        Collection symbols = libMap.get((Object)packageName);
                        SymbolWriter writer = new SymbolWriter(osOutputPath, packageName, fullSymbolValues);
                        for (SymbolLoader symbolLoader : symbols) {
                            writer.addSymbolsToWrite(symbolLoader);
                        }
                        writer.write();
                    }
                }
            }
            catch (IOException e1) {
                String msg;
                String path = (String)array.get(0);
                if (!new File(path).exists()) {
                    msg = String.format(Messages.AAPT_Exec_Error_s, path);
                } else {
                    String description = e1.getLocalizedMessage();
                    if (e1.getCause() != null && e1.getCause() != e1) {
                        description = String.valueOf(description) + ": " + e1.getCause().getLocalizedMessage();
                    }
                    msg = String.format(Messages.AAPT_Exec_Error_Other_s, description);
                }
                this.markProject("org.eclipse.andmore.adtProblem", msg, 2);
                if (SdkConstants.CURRENT_PLATFORM == 1 && System.getProperty("os.arch").endsWith("64") && new File(aaptPath).exists() && new File("/usr/bin/apt-get").exists()) {
                    this.markProject("org.eclipse.andmore.adtProblem", "Hint: On 64-bit systems, make sure the 32-bit libraries are installed: \"sudo apt-get install ia32-libs\" or on some systems, \"sudo apt-get install lib32z1\"", 2);
                }
                throw new BaseBuilder.AbortBuildException();
            }
            catch (InterruptedException interruptedException) {
                String msg = String.format(Messages.AAPT_Exec_Error_s, array.get(0));
                this.markProject("org.eclipse.andmore.adtProblem", msg, 2);
                throw new BaseBuilder.AbortBuildException();
            }
        }
        finally {
            this.mMustCompileResources = false;
            this.saveProjectBooleanProperty(PROPERTY_COMPILE_RESOURCES, false);
            ResourceManager.clearAaptRequest(project);
        }
    }

    private IPath getJavaPackagePath(String javaPackageName) {
        String[] segments = javaPackageName.split("\\.");
        StringBuilder path = new StringBuilder();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            path.append('/');
            path.append(s);
            ++n2;
        }
        return new Path(path.toString());
    }

    private IFolder getGenManifestPackageFolder() throws CoreException {
        IPath packagePath = this.getJavaPackagePath(this.mManifestPackage);
        return this.mGenFolder.getFolder(packagePath);
    }

    private static class DerivedProgressMonitor
    implements IProgressMonitor {
        private boolean mCancelled = false;
        private boolean mDone = false;
        private final IFolder mGenFolder;

        public DerivedProgressMonitor(IFolder genFolder) {
            this.mGenFolder = genFolder;
        }

        void reset() {
            this.mDone = false;
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
            if (!this.mDone) {
                this.mDone = true;
                this.processChildrenOf(this.mGenFolder);
            }
        }

        private void processChildrenOf(IFolder folder) {
            IResource[] list;
            try {
                list = folder.members();
            }
            catch (CoreException coreException) {
                return;
            }
            IResource[] iResourceArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.exists()) {
                    if (member.getType() == 2) {
                        this.processChildrenOf((IFolder)member);
                    }
                    try {
                        member.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {}
                }
                ++n2;
            }
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return this.mCancelled;
        }

        public void setCanceled(boolean value) {
            this.mCancelled = value;
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

