/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build.builders;

import com.android.ide.common.sdk.LoadStatus;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.BuildHelper;
import org.eclipse.andmore.internal.build.Messages;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.project.XmlErrorHandler;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.io.IFileWrapper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseBuilder
extends IncrementalProjectBuilder {
    protected static final boolean DEBUG_LOG = "1".equals(System.getenv("ANDROID_BUILD_DEBUG"));
    private SAXParserFactory mParserFactory = SAXParserFactory.newInstance();
    protected BuildToolInfo mBuildToolInfo;

    public BaseBuilder() {
        this.mParserFactory.setNamespaceAware(false);
    }

    protected final void checkXML(IResource resource, BaseDeltaVisitor visitor) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            this.removeMarkersFromResource((IResource)file, "org.eclipse.andmore.common.xmlProblem");
            XmlErrorHandler reporter = new XmlErrorHandler(file, visitor);
            try {
                this.getParser().parse(file.getContents(), (DefaultHandler)reporter);
            }
            catch (Exception exception) {}
        }
    }

    protected final SAXParser getParser() throws ParserConfigurationException, SAXException {
        return this.mParserFactory.newSAXParser();
    }

    protected final IMarker markProject(String markerId, String message, int severity) {
        return BaseProjectHelper.markResource((IResource)this.getProject(), markerId, message, severity);
    }

    public final void removeMarkersFromResource(IResource resource, String markerId) {
        try {
            if (resource.exists()) {
                resource.deleteMarkers(markerId, true, 0);
            }
        }
        catch (CoreException coreException) {
            String msg = String.format(Messages.Marker_Delete_Error, markerId, resource.toString());
            AndmoreAndroidPlugin.printErrorToConsole(this.getProject(), new Object[]{msg});
        }
    }

    protected final void removeMarkersFromContainer(IContainer folder, String markerId) {
        try {
            if (folder.exists()) {
                folder.deleteMarkers(markerId, true, 2);
            }
        }
        catch (CoreException coreException) {
            String msg = String.format(Messages.Marker_Delete_Error, markerId, folder.toString());
            AndmoreAndroidPlugin.printErrorToConsole(this.getProject(), new Object[]{msg});
        }
    }

    protected final int grabProcessOutput(Process process, ArrayList<String> stdErr) throws InterruptedException {
        return BuildHelper.grabProcessOutput(this.getProject(), process, stdErr);
    }

    protected boolean saveProjectStringProperty(String propertyName, String value) {
        IProject project = this.getProject();
        return ProjectHelper.saveStringProperty((IResource)project, propertyName, value);
    }

    protected String loadProjectStringProperty(String propertyName) {
        IProject project = this.getProject();
        return ProjectHelper.loadStringProperty((IResource)project, propertyName);
    }

    protected boolean saveProjectBooleanProperty(String propertyName, boolean value) {
        IProject project = this.getProject();
        return ProjectHelper.saveStringProperty((IResource)project, propertyName, Boolean.toString(value));
    }

    protected boolean loadProjectBooleanProperty(String propertyName, boolean defaultValue) {
        IProject project = this.getProject();
        return ProjectHelper.loadBooleanProperty((IResource)project, propertyName, defaultValue);
    }

    protected void abortOnBadSetup(IJavaProject javaProject, ProjectState projectState) throws AbortBuildException, CoreException {
        IAndroidTarget target;
        IProject iProject = javaProject.getProject();
        Sdk sdk = Sdk.getCurrent();
        if (sdk == null) {
            throw new AbortBuildException();
        }
        if (projectState == null) {
            projectState = Sdk.getProjectState(javaProject.getProject());
        }
        if ((target = projectState.getTarget()) == null) {
            throw new AbortBuildException();
        }
        if (sdk.checkAndLoadTargetData(target, javaProject) != LoadStatus.LOADED) {
            throw new AbortBuildException();
        }
        this.mBuildToolInfo = projectState.getBuildToolInfo();
        if (this.mBuildToolInfo == null) {
            this.mBuildToolInfo = sdk.getLatestBuildTool();
            if (this.mBuildToolInfo == null) {
                AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, iProject, "No \"Build Tools\" package available; use SDK Manager to install one.");
                throw new AbortBuildException();
            }
            AndmoreAndroidPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, iProject, String.format("Using default Build Tools revision %s", this.mBuildToolInfo.getRevision()));
        }
        this.stopOnMarker(iProject, "org.eclipse.andmore.targetProblem", 0, false);
        this.stopOnMarker(iProject, "org.eclipse.andmore.adtProblem", 0, false);
    }

    protected void stopOnMarker(IProject project, String markerType, int depth, boolean checkSeverity) throws AbortBuildException {
        try {
            IMarker[] markers = project.findMarkers(markerType, false, depth);
            if (markers.length > 0) {
                if (!checkSeverity) {
                    throw new AbortBuildException();
                }
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    int severity = marker.getAttribute("severity", -1);
                    if (severity == 2) {
                        throw new AbortBuildException();
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected void handleStreamException(StreamException e) {
        String msg;
        IAbstractFile file = e.getFile();
        IProject target = this.getProject();
        if (file instanceof IFileWrapper) {
            target = ((IFileWrapper)file).getIFile();
            msg = e.getError() == StreamException.Error.OUTOFSYNC ? "File is Out of sync" : "Error reading file. Read log for details";
        } else {
            msg = e.getError() == StreamException.Error.OUTOFSYNC ? String.format("Out of sync file: %s", file.getOsLocation()) : String.format("Error reading file %s. Read log for details", file.getOsLocation());
        }
        AndmoreAndroidPlugin.logAndPrintError(e, this.getProject().getName(), msg, new Object[0]);
        BaseProjectHelper.markResource((IResource)target, "org.eclipse.andmore.adtProblem", msg, 2);
    }

    protected void handleException(Throwable t, String message) {
        AndmoreAndroidPlugin.logAndPrintError(t, this.getProject().getName(), message, new Object[0]);
        this.markProject("org.eclipse.andmore.adtProblem", message, 2);
    }

    protected void removeDerivedResources(IResource rootResource, IProgressMonitor monitor) throws CoreException {
        this.removeDerivedResources(rootResource, false, monitor);
    }

    private void removeDerivedResources(IResource rootResource, boolean deleteRoot, IProgressMonitor monitor) throws CoreException {
        if (rootResource.exists()) {
            if (rootResource.getType() == 2) {
                IFolder folder = (IFolder)rootResource;
                IResource[] members = folder.members();
                boolean wasNotEmpty = members.length > 0;
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.removeDerivedResources(member, true, monitor);
                    ++n2;
                }
                if (deleteRoot && wasNotEmpty && folder.members().length == 0) {
                    rootResource.getLocation().toFile().delete();
                }
            }
            if (rootResource.isDerived()) {
                rootResource.getLocation().toFile().delete();
            }
        }
    }

    protected void launchJob(Job newJob) {
        newJob.setPriority(40);
        newJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        newJob.schedule();
    }

    protected static class AbortBuildException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected AbortBuildException() {
        }
    }

    protected static class BaseDeltaVisitor
    implements XmlErrorHandler.XmlErrorListener {
        protected BaseBuilder mBuilder;
        public boolean mXmlError = false;

        public BaseDeltaVisitor(BaseBuilder builder) {
            this.mBuilder = builder;
        }

        protected static String[] findMatchingSourceFolder(ArrayList<IPath> sourceFolders, String[] pathSegments) {
            for (IPath p : sourceFolders) {
                String[] srcSegments = p.segments();
                boolean valid = true;
                int segmentCount = pathSegments.length;
                int i = 0;
                while (i < segmentCount) {
                    String s1 = pathSegments[i];
                    String s2 = srcSegments[i];
                    if (!s1.equalsIgnoreCase(s2)) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
                if (!valid) continue;
                return srcSegments;
            }
            return null;
        }

        @Override
        public void errorFound() {
            this.mXmlError = true;
        }
    }
}

