/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class DexWrapper {
    public static final String DEX_MAIN = "com.android.dx.command.dexer.Main";
    public static final String DEX_CONSOLE = "com.android.dx.command.DxConsole";
    public static final String DEX_ARGS = "com.android.dx.command.dexer.Main$Arguments";
    public static final String DEX_MAIN_FIELD_OUTPUT_FUTURES = "dexOutputFutures";
    public static final String DEX_MAIN_FIELD_OUTPUT_ARRAYS = "dexOutputArrays";
    public static final String DEX_MAIN_FIELD_CLASSES_IN_MAIN_DEX = "classesInMainDex";
    public static final String DEX_MAIN_FIELD_OUTPUT_RESOURCES = "outputResources";
    public static final String DEX_ARGUMENTS_FIELD_OUT_NAME = "outName";
    public static final String DEX_ARGUMENTS_FIELD_JAR_OUTPUT = "jarOutput";
    public static final String DEX_ARGUMENTS_FIELD_FILES_NAMES = "fileNames";
    public static final String DEX_ARGUMENTS_FIELD_VERBOSE = "verbose";
    public static final String DEX_ARGUMENTS_FIELD_FORCE_JUMBO = "forceJumbo";
    public static final String DEX_ARGUMENTS_FIELD_MULTI_DEX = "multiDex";
    public static final String DEX_ARGUMENTS_FIELD_MAIN_DEX_LIST_FILE = "mainDexListFile";
    public static final String DEX_ARGUMENTS_FIELD_MINIMAL_MAIN_DEX = "minimalMainDex";
    private static final String MAIN_RUN = "run";
    private Method mRunMethod;
    private Field mDexOutputFutures;
    private Field mDexOutputArrays;
    private Field mClassesInMainDex;
    private Field mOutputResources;
    private Constructor<?> mArgConstructor;
    private Field mArgOutName;
    private Field mArgVerbose;
    private Field mArgJarOutput;
    private Field mArgFileNames;
    private Field mArgForceJumbo;
    private Field mArgMultiDex;
    private Field mArgMainDexListFile;
    private Field mArgMinimalMainDex;
    private Field mConsoleOut;
    private Field mConsoleErr;

    public synchronized IStatus loadDex(String osFilepath) {
        try {
            File f = new File(osFilepath);
            if (!f.isFile()) {
                return new Status(4, "org.eclipse.andmore", String.format(Messages.DexWrapper_s_does_not_exists, osFilepath));
            }
            URL url = f.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, DexWrapper.class.getClassLoader());
            Class<?> mainClass = loader.loadClass(DEX_MAIN);
            Class<?> consoleClass = loader.loadClass(DEX_CONSOLE);
            Class<?> argClass = loader.loadClass(DEX_ARGS);
            try {
                this.mRunMethod = mainClass.getMethod(MAIN_RUN, argClass);
                try {
                    this.mDexOutputFutures = mainClass.getDeclaredField(DEX_MAIN_FIELD_OUTPUT_FUTURES);
                }
                catch (Exception exception) {}
                this.mDexOutputArrays = mainClass.getDeclaredField(DEX_MAIN_FIELD_OUTPUT_ARRAYS);
                this.mClassesInMainDex = mainClass.getDeclaredField(DEX_MAIN_FIELD_CLASSES_IN_MAIN_DEX);
                this.mOutputResources = mainClass.getDeclaredField(DEX_MAIN_FIELD_OUTPUT_RESOURCES);
                this.mArgConstructor = argClass.getConstructor(new Class[0]);
                this.mArgOutName = argClass.getField(DEX_ARGUMENTS_FIELD_OUT_NAME);
                this.mArgJarOutput = argClass.getField(DEX_ARGUMENTS_FIELD_JAR_OUTPUT);
                this.mArgFileNames = argClass.getField(DEX_ARGUMENTS_FIELD_FILES_NAMES);
                this.mArgVerbose = argClass.getField(DEX_ARGUMENTS_FIELD_VERBOSE);
                this.mArgForceJumbo = argClass.getField(DEX_ARGUMENTS_FIELD_FORCE_JUMBO);
                this.mArgMultiDex = argClass.getField(DEX_ARGUMENTS_FIELD_MULTI_DEX);
                this.mArgMainDexListFile = argClass.getField(DEX_ARGUMENTS_FIELD_MAIN_DEX_LIST_FILE);
                this.mArgMinimalMainDex = argClass.getField(DEX_ARGUMENTS_FIELD_MINIMAL_MAIN_DEX);
                this.mConsoleOut = consoleClass.getField("out");
                this.mConsoleErr = consoleClass.getField("err");
            }
            catch (SecurityException e) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_API, e);
            }
            catch (NoSuchMethodException e) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_Method, e);
            }
            catch (NoSuchFieldException e) {
                return DexWrapper.createErrorStatus(Messages.DexWrapper_SecuryEx_Unable_To_Find_Field, e);
            }
            return Status.OK_STATUS;
        }
        catch (MalformedURLException e) {
            return DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Failed_to_load_s, osFilepath), e);
        }
        catch (ClassNotFoundException e) {
            return DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Failed_to_load_s, osFilepath), e);
        }
    }

    public synchronized void unload() {
        this.mRunMethod = null;
        this.mDexOutputFutures = null;
        this.mDexOutputArrays = null;
        this.mClassesInMainDex = null;
        this.mOutputResources = null;
        this.mArgConstructor = null;
        this.mArgOutName = null;
        this.mArgJarOutput = null;
        this.mArgFileNames = null;
        this.mArgVerbose = null;
        this.mArgMultiDex = null;
        this.mArgMainDexListFile = null;
        this.mArgMinimalMainDex = null;
        this.mConsoleOut = null;
        this.mConsoleErr = null;
        System.gc();
    }

    private synchronized void resetDexMain() throws Exception {
        assert (this.mDexOutputArrays != null);
        assert (this.mClassesInMainDex != null);
        assert (this.mOutputResources != null);
        if (this.mDexOutputFutures != null) {
            if (!this.mDexOutputFutures.isAccessible()) {
                this.mDexOutputFutures.setAccessible(true);
            }
            this.mDexOutputFutures.set(null, new ArrayList());
        }
        if (!this.mDexOutputArrays.isAccessible()) {
            this.mDexOutputArrays.setAccessible(true);
        }
        if (!this.mClassesInMainDex.isAccessible()) {
            this.mClassesInMainDex.setAccessible(true);
        }
        if (!this.mOutputResources.isAccessible()) {
            this.mOutputResources.setAccessible(true);
        }
        this.mDexOutputArrays.set(null, new ArrayList());
        this.mClassesInMainDex.set(null, null);
        this.mOutputResources.set(null, null);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int run(String osOutFilePath, Collection<String> osFilenames, boolean forceJumbo, boolean enableMultiDex, String mainDexListFile, boolean minimalMainDex, boolean verbose, PrintStream outStream, PrintStream errStream) throws CoreException {
        if (!DexWrapper.$assertionsDisabled && this.mRunMethod == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgConstructor == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgOutName == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgJarOutput == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgFileNames == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgForceJumbo == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgVerbose == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgMultiDex == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgMainDexListFile == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mArgMinimalMainDex == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mConsoleOut == null) {
            throw new AssertionError();
        }
        if (!DexWrapper.$assertionsDisabled && this.mConsoleErr == null) {
            throw new AssertionError();
        }
        if (this.mRunMethod == null) {
            throw new CoreException(DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Unable_To_Execute_Dex_s, new Object[]{"wrapper was not properly loaded first"}), null));
        }
        try {
            this.mConsoleErr.set(null, errStream);
            this.mConsoleOut.set(null, outStream);
            args = this.mArgConstructor.newInstance(new Object[0]);
            this.mArgMultiDex.set(args, enableMultiDex);
            if (enableMultiDex) {
                this.resetDexMain();
                this.mArgMainDexListFile.set(args, mainDexListFile);
                this.mArgMinimalMainDex.set(args, minimalMainDex);
            }
            this.mArgFileNames.set(args, osFilenames.toArray(new String[osFilenames.size()]));
            this.mArgOutName.set(args, osOutFilePath);
            this.mArgJarOutput.set(args, osOutFilePath.endsWith(".jar"));
            this.mArgForceJumbo.set(args, forceJumbo);
            this.mArgVerbose.set(args, verbose);
            res = this.mRunMethod.invoke(null, new Object[]{args});
            if (res instanceof Integer) {
                return (Integer)res;
            }
            return -1;
        }
        catch (Exception e) {
            t = e;
            ** while (t.getCause() != null)
        }
lbl-1000:
        // 1 sources

        {
            t = t.getCause();
            continue;
        }
lbl50:
        // 1 sources

        msg = t.getMessage();
        if (msg == null) {
            msg = String.format("%s. Check the Eclipse log for stack trace.", new Object[]{t.getClass().getName()});
        }
        throw new CoreException(DexWrapper.createErrorStatus(String.format(Messages.DexWrapper_Unable_To_Execute_Dex_s, new Object[]{msg}), t));
    }

    private static IStatus createErrorStatus(String message, Throwable e) {
        AndmoreAndroidPlugin.log(e, message, new Object[0]);
        AndmoreAndroidPlugin.printErrorToConsole(Messages.DexWrapper_Dex_Loader, message);
        return new Status(4, "org.eclipse.andmore", message, e);
    }
}

