/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.grid;

import com.android.ide.common.api.INode;
import com.android.ide.common.api.SegmentType;

class GridMatch
implements Comparable<GridMatch> {
    public final int distance;
    public final SegmentType type;
    public int cellIndex;
    public boolean createCell;
    public int matchedLine;
    public int margin;

    GridMatch(SegmentType type, int distance, int matchedLine, int cellIndex, boolean createCell, int margin) {
        this.type = type;
        this.distance = distance;
        this.matchedLine = matchedLine;
        this.cellIndex = cellIndex;
        this.createCell = createCell;
        this.margin = margin;
    }

    @Override
    public int compareTo(GridMatch o) {
        if (this.distance != o.distance) {
            return this.distance - o.distance;
        }
        return this.getPriority() - o.getPriority();
    }

    public String getDisplayName(INode layout) {
        switch (this.type) {
            case BASELINE: {
                return String.format("Align baseline in row %1$d", this.cellIndex + 1);
            }
            case CENTER_HORIZONTAL: {
                return "Center horizontally";
            }
            case LEFT: {
                if (!this.createCell) {
                    return String.format("Insert into column %1$d", this.cellIndex + 1);
                }
                if (this.margin != Integer.MIN_VALUE) {
                    if (this.cellIndex == 0 && this.margin != 0) {
                        return "Add one margin distance from the left";
                    }
                    return String.format("Add next to column %1$d", this.cellIndex + 1);
                }
                return String.format("Align left at x=%1$d", this.matchedLine - layout.getBounds().x);
            }
            case RIGHT: {
                if (!this.createCell) {
                    return String.format("Insert right-aligned into column %1$d", this.cellIndex + 1);
                }
                return String.format("Align right at x=%1$d", this.matchedLine - layout.getBounds().x);
            }
            case TOP: {
                if (!this.createCell) {
                    return String.format("Insert into row %1$d", this.cellIndex + 1);
                }
                if (this.margin != Integer.MIN_VALUE) {
                    if (this.cellIndex == 0 && this.margin != 0) {
                        return "Add one margin distance from the top";
                    }
                    return String.format("Add below row %1$d", this.cellIndex + 1);
                }
                return String.format("Align top at y=%1d", this.matchedLine - layout.getBounds().y);
            }
            case BOTTOM: {
                if (!this.createCell) {
                    return String.format("Insert into bottom of row %1$d", this.cellIndex + 1);
                }
                return String.format("Align bottom at y=%1d", this.matchedLine - layout.getBounds().y);
            }
            case CENTER_VERTICAL: {
                return "Center vertically";
            }
        }
        return null;
    }

    private int getPriority() {
        switch (this.type) {
            case BASELINE: {
                return 0;
            }
            case CENTER_VERTICAL: 
            case CENTER_HORIZONTAL: {
                return 1;
            }
            case LEFT: 
            case TOP: 
            case RIGHT: 
            case BOTTOM: {
                return 2;
            }
        }
        return 3;
    }
}

