/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.RuleAction;
import com.android.ide.common.api.SegmentType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.layout.BaseLayoutRule;
import org.eclipse.andmore.common.layout.PropertyCallback;
import org.eclipse.andmore.common.layout.ResizeState;

public class LinearLayoutRule
extends BaseLayoutRule {
    private static final String ACTION_ORIENTATION = "_orientation";
    private static final String ACTION_WEIGHT = "_weight";
    private static final String ACTION_DISTRIBUTE = "_distribute";
    private static final String ACTION_BASELINE = "_baseline";
    private static final String ACTION_CLEAR = "_clear";
    private static final String ACTION_DOMINATE = "_dominate";
    private static final URL ICON_HORIZONTAL = LinearLayoutRule.class.getResource("hlinear.png");
    private static final URL ICON_VERTICAL = LinearLayoutRule.class.getResource("vlinear.png");
    private static final URL ICON_WEIGHTS = LinearLayoutRule.class.getResource("weights.png");
    private static final URL ICON_DISTRIBUTE = LinearLayoutRule.class.getResource("distribute.png");
    private static final URL ICON_BASELINE = LinearLayoutRule.class.getResource("baseline.png");
    private static final URL ICON_CLEAR_WEIGHTS = LinearLayoutRule.class.getResource("clearweights.png");
    private static final URL ICON_DOMINATE = LinearLayoutRule.class.getResource("allweight.png");

    private String getCurrentOrientation(INode node) {
        String orientation = node.getStringAttr("http://schemas.android.com/apk/res/android", "orientation");
        if (orientation == null || orientation.length() == 0) {
            orientation = "horizontal";
        }
        return orientation;
    }

    protected boolean isVertical(INode node) {
        return "vertical".equals(node.getStringAttr("http://schemas.android.com/apk/res/android", "orientation"));
    }

    protected boolean supportsOrientation() {
        return true;
    }

    @Override
    public void addLayoutActions(List<RuleAction> actions, final INode parentNode, final List<? extends INode> children) {
        super.addLayoutActions(actions, parentNode, children);
        if (this.supportsOrientation()) {
            RuleAction.Choices action = RuleAction.createChoices((String)ACTION_ORIENTATION, (String)"Orientation", (IMenuCallback)new PropertyCallback(Collections.singletonList(parentNode), "Change LinearLayout Orientation", "http://schemas.android.com/apk/res/android", "orientation"), Arrays.asList("Set Horizontal Orientation", "Set Vertical Orientation"), Arrays.asList(ICON_HORIZONTAL, ICON_VERTICAL), Arrays.asList("horizontal", "vertical"), (String)this.getCurrentOrientation(parentNode), null, (int)-10, (boolean)false);
            action.setRadio(true);
            actions.add((RuleAction)action);
        }
        if (!this.isVertical(parentNode)) {
            String current = parentNode.getStringAttr("http://schemas.android.com/apk/res/android", "baselineAligned");
            boolean isAligned = current == null || Boolean.valueOf(current) != false;
            actions.add((RuleAction)RuleAction.createToggle((String)ACTION_BASELINE, (String)"Toggle Baseline Alignment", (boolean)isAligned, (IMenuCallback)new PropertyCallback(Collections.singletonList(parentNode), "Change Baseline Alignment", "http://schemas.android.com/apk/res/android", "baselineAligned"), (URL)ICON_BASELINE, (int)38, (boolean)false));
        }
        if (children != null && children.size() > 0) {
            actions.add((RuleAction)RuleAction.createSeparator((int)35));
            actions.add(this.createMarginAction(parentNode, children));
            actions.add(this.createGravityAction(children, "layout_gravity"));
            IMenuCallback actionCallback = new IMenuCallback(){

                public void action(final RuleAction action, List<? extends INode> selectedNodes, String valueId, Boolean newValue) {
                    parentNode.editXml("Change Weight", new INodeHandler(){

                        public void handle(INode n) {
                            String id = action.getId();
                            if (id.equals(LinearLayoutRule.ACTION_WEIGHT)) {
                                String weight = ((INode)children.get(0)).getStringAttr("http://schemas.android.com/apk/res/android", "layout_weight");
                                if (weight == null || weight.length() == 0) {
                                    weight = "0.0";
                                }
                                if ((weight = (this).LinearLayoutRule.this.mRulesEngine.displayInput("Enter Weight Value:", weight, null)) != null) {
                                    if (weight.isEmpty()) {
                                        weight = null;
                                    }
                                    for (INode child : children) {
                                        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", weight);
                                    }
                                }
                            } else if (id.equals(LinearLayoutRule.ACTION_DISTRIBUTE)) {
                                LinearLayoutRule.this.distributeWeights(parentNode, parentNode.getChildren());
                            } else if (id.equals(LinearLayoutRule.ACTION_CLEAR)) {
                                LinearLayoutRule.this.clearWeights(parentNode);
                            } else if (id.equals(LinearLayoutRule.ACTION_CLEAR) || id.equals(LinearLayoutRule.ACTION_DOMINATE)) {
                                LinearLayoutRule.this.clearWeights(parentNode);
                                LinearLayoutRule.this.distributeWeights(parentNode, children.toArray(new INode[children.size()]));
                            } else if (!$assertionsDisabled && !id.equals(LinearLayoutRule.ACTION_BASELINE)) {
                                throw new AssertionError();
                            }
                        }
                    });
                }
            };
            actions.add((RuleAction)RuleAction.createSeparator((int)50));
            actions.add(RuleAction.createAction((String)ACTION_DISTRIBUTE, (String)"Distribute Weights Evenly", (IMenuCallback)actionCallback, (URL)ICON_DISTRIBUTE, (int)60, (boolean)false));
            actions.add(RuleAction.createAction((String)ACTION_DOMINATE, (String)"Assign All Weight", (IMenuCallback)actionCallback, (URL)ICON_DOMINATE, (int)70, (boolean)false));
            actions.add(RuleAction.createAction((String)ACTION_WEIGHT, (String)"Change Layout Weight", (IMenuCallback)actionCallback, (URL)ICON_WEIGHTS, (int)80, (boolean)false));
            actions.add(RuleAction.createAction((String)ACTION_CLEAR, (String)"Clear All Weights", (IMenuCallback)actionCallback, (URL)ICON_CLEAR_WEIGHTS, (int)90, (boolean)false));
        }
    }

    private void distributeWeights(INode parentNode, INode[] targets) {
        String weightSum = parentNode.getStringAttr("http://schemas.android.com/apk/res/android", "weightSum");
        double sum = -1.0;
        if (weightSum != null) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int numTargets = targets.length;
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value = AdtUtils.formatFloatAttribute((float)share);
        String sizeAttribute = this.isVertical(parentNode) ? "layout_height" : "layout_width";
        INode[] iNodeArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            INode target = iNodeArray[n2];
            target.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
            if ("wrap_content".equals(target.getStringAttr("http://schemas.android.com/apk/res/android", sizeAttribute))) {
                target.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
            }
            ++n2;
        }
    }

    private void clearWeights(INode parentNode) {
        String sizeAttribute = this.isVertical(parentNode) ? "layout_height" : "layout_width";
        INode[] iNodeArray = parentNode.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode target = iNodeArray[n2];
            target.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            String size = target.getStringAttr("http://schemas.android.com/apk/res/android", sizeAttribute);
            if (size != null && size.startsWith("0")) {
                target.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "wrap_content");
            }
            ++n2;
        }
    }

    public DropFeedback onDropEnter(INode targetNode, Object targetView, final IDragElement[] elements) {
        if (elements.length == 0) {
            return null;
        }
        Rect bn = targetNode.getBounds();
        if (!bn.isValid()) {
            return null;
        }
        boolean isVertical = this.isVertical(targetNode);
        ArrayList<MatchPos> indexes = new ArrayList<MatchPos>();
        int last = isVertical ? bn.y : bn.x;
        int pos = 0;
        boolean lastDragged = false;
        int selfPos = -1;
        INode[] iNodeArray = targetNode.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode it = iNodeArray[n2];
            Rect bc = it.getBounds();
            if (bc.isValid()) {
                boolean isDragged = false;
                IDragElement[] iDragElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDragElement element = iDragElementArray[n4];
                    if (element.isSame(it)) {
                        isDragged = true;
                        break;
                    }
                    ++n4;
                }
                if (isDragged) {
                    int v = isVertical ? bc.y + bc.h / 2 : bc.x + bc.w / 2;
                    selfPos = pos;
                    indexes.add(new MatchPos(v, pos++));
                } else if (lastDragged) {
                    ++pos;
                } else {
                    int v = isVertical ? bc.y : bc.x;
                    v = (last + v) / 2;
                    indexes.add(new MatchPos(v, pos++));
                }
                last = isVertical ? bc.y + bc.h : bc.x + bc.w;
                lastDragged = isDragged;
            } else {
                ++pos;
            }
            ++n2;
        }
        if (!lastDragged) {
            int v = last + 1;
            indexes.add(new MatchPos(v, pos));
        }
        int posCount = targetNode.getChildren().length + 1;
        return new DropFeedback((Object)new LinearDropData(indexes, posCount, isVertical, selfPos), new IFeedbackPainter(){

            public void paint(IGraphics gc, INode node, DropFeedback feedback) {
                LinearLayoutRule.this.drawFeedback(gc, node, elements, feedback);
            }
        });
    }

    void drawFeedback(IGraphics gc, INode node, IDragElement[] elements, DropFeedback feedback) {
        Rect b = node.getBounds();
        if (!b.isValid()) {
            return;
        }
        gc.useStyle(DrawingStyle.DROP_RECIPIENT);
        gc.drawRect(b);
        gc.useStyle(DrawingStyle.DROP_ZONE);
        LinearDropData data = (LinearDropData)feedback.userData;
        boolean isVertical = data.isVertical();
        int selfPos = data.getSelfPos();
        for (MatchPos it : data.getIndexes()) {
            int i = it.getDistance();
            int pos = it.getPosition();
            if (pos == selfPos) continue;
            if (isVertical) {
                gc.drawLine(b.x, i, b.x + b.w, i);
                continue;
            }
            gc.drawLine(i, b.y, i, b.y + b.h);
        }
        Integer currX = data.getCurrX();
        Integer currY = data.getCurrY();
        if (currX != null && currY != null) {
            gc.useStyle(DrawingStyle.DROP_ZONE_ACTIVE);
            int x = currX;
            int y = currY;
            Rect be = elements[0].getBounds();
            if (data.getInsertPos() != selfPos || selfPos == -1) {
                gc.useStyle(DrawingStyle.DROP_PREVIEW);
                if (data.getWidth() != null) {
                    int width = data.getWidth();
                    int fromX = x - width / 2;
                    int toX = x + width / 2;
                    gc.drawLine(fromX, y, toX, y);
                } else if (data.getHeight() != null) {
                    int height = data.getHeight();
                    int fromY = y - height / 2;
                    int toY = y + height / 2;
                    gc.drawLine(x, fromY, x, toY);
                }
            }
            if (be.isValid()) {
                int offsetY;
                int offsetX;
                boolean isLast = data.isLastPosition();
                if (isVertical) {
                    offsetX = b.x - be.x;
                    offsetY = currY - be.y - (isLast ? 0 : be.h / 2);
                } else {
                    offsetX = currX - be.x - (isLast ? 0 : be.w / 2);
                    offsetY = b.y - be.y;
                }
                gc.useStyle(DrawingStyle.DROP_PREVIEW);
                IDragElement[] iDragElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IDragElement element = iDragElementArray[n2];
                    Rect bounds = element.getBounds();
                    if (bounds.isValid() && (bounds.w > b.w || bounds.h > b.h) && node.getChildren().length == 0) {
                        int ph;
                        int py;
                        int pw;
                        int px;
                        if (bounds.w > b.w) {
                            px = b.x;
                            pw = b.w;
                        } else {
                            px = bounds.x + offsetX;
                            pw = bounds.w;
                        }
                        if (bounds.h > b.h) {
                            py = b.y;
                            ph = b.h;
                        } else {
                            py = bounds.y + offsetY;
                            ph = bounds.h;
                        }
                        Rect within = new Rect(px, py, pw, ph);
                        gc.drawRect(within);
                    } else {
                        this.drawElement(gc, element, offsetX, offsetY);
                    }
                    ++n2;
                }
            }
        }
    }

    public DropFeedback onDropMove(INode targetNode, IDragElement[] elements, DropFeedback feedback, Point p) {
        Rect b = targetNode.getBounds();
        if (!b.isValid()) {
            return feedback;
        }
        LinearDropData data = (LinearDropData)feedback.userData;
        boolean isVertical = data.isVertical();
        int bestDist = Integer.MAX_VALUE;
        int bestIndex = Integer.MIN_VALUE;
        Integer bestPos = null;
        for (MatchPos index : data.getIndexes()) {
            int i = index.getDistance();
            int pos = index.getPosition();
            int dist = (isVertical ? p.y : p.x) - i;
            if (dist < 0) {
                dist = -dist;
            }
            if (dist >= bestDist) continue;
            bestDist = dist;
            bestIndex = i;
            bestPos = pos;
            if (bestDist <= 0) break;
        }
        if (bestIndex != Integer.MIN_VALUE) {
            Integer oldX = data.getCurrX();
            Integer oldY = data.getCurrY();
            if (isVertical) {
                data.setCurrX(b.x + b.w / 2);
                data.setCurrY(bestIndex);
                data.setWidth(b.w);
                data.setHeight(null);
            } else {
                data.setCurrX(bestIndex);
                data.setCurrY(b.y + b.h / 2);
                data.setWidth(null);
                data.setHeight(b.h);
            }
            data.setInsertPos(bestPos);
            feedback.requestPaint = !LinearLayoutRule.equals(oldX, data.getCurrX()) || !LinearLayoutRule.equals(oldY, data.getCurrY());
        }
        return feedback;
    }

    private static boolean equals(Integer i1, Integer i2) {
        if (i1 == i2) {
            return true;
        }
        if (i1 != null) {
            return i1.equals(i2);
        }
        return i2.equals(i1);
    }

    public void onDropLeave(INode targetNode, IDragElement[] elements, DropFeedback feedback) {
    }

    public void onDropped(INode targetNode, IDragElement[] elements, DropFeedback feedback, Point p) {
        LinearDropData data = (LinearDropData)feedback.userData;
        int initialInsertPos = data.getInsertPos();
        LinearLayoutRule.insertAt(targetNode, elements, feedback.isCopy || !feedback.sameCanvas, initialInsertPos);
    }

    public void onChildInserted(INode node, INode parent, InsertType insertType) {
        if (insertType == InsertType.MOVE_WITHIN) {
            return;
        }
        String fqcn = node.getFqcn();
        IViewMetadata metadata = this.mRulesEngine.getMetadata(fqcn);
        if (metadata != null) {
            boolean vertical = this.isVertical(parent);
            IViewMetadata.FillPreference fill = metadata.getFillPreference();
            String fillParent = this.getFillParentValueName();
            if (fill.fillHorizontally(vertical)) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
            } else if (!vertical && fill == IViewMetadata.FillPreference.WIDTH_IN_VERTICAL) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", "1");
            }
            if (fill.fillVertically(vertical)) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
            }
        }
        boolean duplicateWeight = true;
        boolean duplicate0dip = true;
        String sameWeight = null;
        String sizeAttribute = this.isVertical(parent) ? "layout_height" : "layout_width";
        INode[] iNodeArray = parent.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode target = iNodeArray[n2];
            if (target != node) {
                String weight = target.getStringAttr("http://schemas.android.com/apk/res/android", "layout_weight");
                if (weight == null || weight.length() == 0) {
                    duplicateWeight = false;
                    break;
                }
                if (sameWeight != null && !sameWeight.equals(weight)) {
                    duplicateWeight = false;
                } else {
                    sameWeight = weight;
                }
                String size = target.getStringAttr("http://schemas.android.com/apk/res/android", sizeAttribute);
                if (size != null && !size.startsWith("0")) {
                    duplicate0dip = false;
                    break;
                }
            }
            ++n2;
        }
        if (duplicateWeight && sameWeight != null) {
            node.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", sameWeight);
            if (duplicate0dip) {
                node.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
            }
        }
    }

    @Override
    protected ResizeState createResizeState(INode layout, Object layoutView, INode node) {
        return new LinearResizeState(this, layout, layoutView, node);
    }

    protected void updateResizeState(LinearResizeState resizeState, INode node, INode layout, Rect oldBounds, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        Map<INode, Rect> sizes;
        Rect nodePreferredSize;
        float sum;
        resizeState.reset();
        if (oldBounds.equals((Object)newBounds)) {
            return;
        }
        boolean isVertical = this.isVertical(layout);
        if (!isVertical && verticalEdge != null) {
            if (resizeState.wrapWidth || resizeState.fillWidth) {
                resizeState.clearWeight(node);
                return;
            }
            if (newBounds.w == oldBounds.w) {
                return;
            }
        }
        if (isVertical && horizontalEdge != null) {
            if (resizeState.wrapHeight || resizeState.fillHeight) {
                resizeState.clearWeight(node);
                return;
            }
            if (newBounds.h == oldBounds.h) {
                return;
            }
        }
        if ((sum = LinearLayoutRule.getWeightSum(layout)) <= 0.0f) {
            sum = 1.0f;
            resizeState.setWeightSum(sum);
        }
        if ((nodePreferredSize = (sizes = resizeState.unweightedSizes).get(node)) != null && (horizontalEdge != null && newBounds.h < nodePreferredSize.h || verticalEdge != null && newBounds.w < nodePreferredSize.w)) {
            return;
        }
        Rect layoutBounds = layout.getBounds();
        int remaining = (isVertical ? layoutBounds.h : layoutBounds.w) - resizeState.totalLength;
        Rect nodeBounds = sizes.get(node);
        if (nodeBounds == null) {
            return;
        }
        if (remaining > 0) {
            int missing = 0;
            if (isVertical) {
                if (newBounds.h > nodeBounds.h) {
                    missing = newBounds.h - nodeBounds.h;
                } else if (newBounds.h > resizeState.wrapBounds.h) {
                    missing = newBounds.h - resizeState.wrapBounds.h;
                    remaining += nodeBounds.h - resizeState.wrapBounds.h;
                    resizeState.wrapHeight = true;
                }
            } else if (newBounds.w > nodeBounds.w) {
                missing = newBounds.w - nodeBounds.w;
            } else if (newBounds.w > resizeState.wrapBounds.w) {
                missing = newBounds.w - resizeState.wrapBounds.w;
                remaining += nodeBounds.w - resizeState.wrapBounds.w;
                resizeState.wrapWidth = true;
            }
            if (missing > 0) {
                float weight = (float)missing * sum / (float)remaining;
                resizeState.setWeight(weight);
            }
        }
    }

    @Override
    protected void setNewSizeBounds(ResizeState state, INode node, INode layout, Rect oldBounds, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        LinearResizeState resizeState = (LinearResizeState)state;
        this.updateResizeState(resizeState, node, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
        if (resizeState.useWeight) {
            resizeState.apply();
            boolean isVertical = this.isVertical(layout);
            if (!isVertical && horizontalEdge != null && (newBounds.h != oldBounds.h || resizeState.wrapHeight || resizeState.fillHeight)) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", resizeState.getHeightAttribute());
            }
            if (isVertical && verticalEdge != null && (newBounds.w != oldBounds.w || resizeState.wrapWidth || resizeState.fillWidth)) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", resizeState.getWidthAttribute());
            }
        } else {
            node.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            super.setNewSizeBounds(resizeState, node, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
        }
    }

    @Override
    protected String getResizeUpdateMessage(ResizeState state, INode child, INode parent, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        LinearResizeState resizeState = (LinearResizeState)state;
        this.updateResizeState(resizeState, child, parent, child.getBounds(), newBounds, horizontalEdge, verticalEdge);
        if (resizeState.useWeight) {
            String height;
            String width;
            String weight = AdtUtils.formatFloatAttribute(resizeState.mWeight);
            String dimension = String.format("weight %1$s", weight);
            if (this.isVertical(parent)) {
                width = resizeState.getWidthAttribute();
                height = dimension;
            } else {
                width = dimension;
                height = resizeState.getHeightAttribute();
            }
            if (horizontalEdge == null) {
                return width;
            }
            if (verticalEdge == null) {
                return height;
            }
            return String.format("%s \u00d7 %s", width, height);
        }
        return super.getResizeUpdateMessage(state, child, parent, newBounds, horizontalEdge, verticalEdge);
    }

    private static float getWeight(INode linearLayoutChild) {
        String weight = linearLayoutChild.getStringAttr("http://schemas.android.com/apk/res/android", "layout_weight");
        if (weight != null && weight.length() > 0) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException nfe) {
                AndmoreAndroidPlugin.log(nfe, "Invalid weight %1$s", weight);
            }
        }
        return 0.0f;
    }

    private static float getWeightSum(INode linearLayout) {
        String weightSum = linearLayout.getStringAttr("http://schemas.android.com/apk/res/android", "weightSum");
        float sum = -1.0f;
        if (weightSum != null) {
            try {
                sum = Float.parseFloat(weightSum);
                return sum;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return LinearLayoutRule.getSumOfWeights(linearLayout);
    }

    private static float getSumOfWeights(INode linearLayout) {
        float sum = 0.0f;
        INode[] iNodeArray = linearLayout.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            sum += LinearLayoutRule.getWeight(child);
            ++n2;
        }
        return sum;
    }

    private static class LinearDropData {
        private final boolean mVertical;
        private final List<MatchPos> mIndexes;
        private final int mNumPositions;
        private Integer mCurrX;
        private Integer mCurrY;
        private final int mSelfPos;
        private int mInsertPos = -1;
        private Integer mWidth;
        private Integer mHeight;

        public LinearDropData(List<MatchPos> indexes, int numPositions, boolean isVertical, int selfPos) {
            this.mIndexes = indexes;
            this.mNumPositions = numPositions;
            this.mVertical = isVertical;
            this.mSelfPos = selfPos;
        }

        public String toString() {
            return "LinearDropData [currX=" + this.mCurrX + ", currY=" + this.mCurrY + ", height=" + this.mHeight + ", indexes=" + this.mIndexes + ", insertPos=" + this.mInsertPos + ", isVertical=" + this.mVertical + ", selfPos=" + this.mSelfPos + ", width=" + this.mWidth + "]";
        }

        private boolean isVertical() {
            return this.mVertical;
        }

        private void setCurrX(Integer currX) {
            this.mCurrX = currX;
        }

        private Integer getCurrX() {
            return this.mCurrX;
        }

        private void setCurrY(Integer currY) {
            this.mCurrY = currY;
        }

        private Integer getCurrY() {
            return this.mCurrY;
        }

        private int getSelfPos() {
            return this.mSelfPos;
        }

        private void setInsertPos(int insertPos) {
            this.mInsertPos = insertPos;
        }

        private int getInsertPos() {
            return this.mInsertPos;
        }

        private List<MatchPos> getIndexes() {
            return this.mIndexes;
        }

        private void setWidth(Integer width) {
            this.mWidth = width;
        }

        private Integer getWidth() {
            return this.mWidth;
        }

        private void setHeight(Integer height) {
            this.mHeight = height;
        }

        private Integer getHeight() {
            return this.mHeight;
        }

        public boolean isLastPosition() {
            return this.mInsertPos == this.mNumPositions - 1;
        }
    }

    private class LinearResizeState
    extends ResizeState {
        public boolean useWeight;
        private float mNewWeightSum;
        private float mWeight;
        public final Map<INode, Rect> unweightedSizes;
        public int totalLength;
        public List<INode> mClearWeights;

        private LinearResizeState(BaseLayoutRule rule, INode layout, Object layoutView, INode node) {
            super(rule, layout, layoutView, node);
            this.unweightedSizes = LinearLayoutRule.this.mRulesEngine.measureChildren(layout, new IClientRulesEngine.AttributeFilter(){

                public String getAttribute(INode n, String namespace, String localName) {
                    if ("layout_weight".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                        return "";
                    }
                    return null;
                }
            });
            this.totalLength = 0;
            boolean isVertical = LinearLayoutRule.this.isVertical(layout);
            for (Map.Entry<INode, Rect> entry : this.unweightedSizes.entrySet()) {
                Rect preferredSize = entry.getValue();
                if (isVertical) {
                    this.totalLength += preferredSize.h;
                    continue;
                }
                this.totalLength += preferredSize.w;
            }
        }

        void reset() {
            this.mNewWeightSum = -1.0f;
            this.useWeight = false;
            this.mClearWeights = null;
        }

        void setWeight(float weight) {
            this.useWeight = true;
            this.mWeight = weight;
        }

        void setWeightSum(float weightSum) {
            this.mNewWeightSum = weightSum;
        }

        void clearWeight(INode n) {
            if (this.mClearWeights == null) {
                this.mClearWeights = new ArrayList<INode>();
            }
            this.mClearWeights.add(n);
        }

        public void apply() {
            assert (this.useWeight);
            String value = this.mWeight > 0.0f ? AdtUtils.formatFloatAttribute(this.mWeight) : null;
            this.node.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
            if (this.mClearWeights != null) {
                for (INode n : this.mClearWeights) {
                    if (!(LinearLayoutRule.getWeight(n) > 0.0f)) continue;
                    n.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
                }
            }
            if ((double)this.mNewWeightSum > 0.0) {
                this.layout.setAttribute("http://schemas.android.com/apk/res/android", "weightSum", AdtUtils.formatFloatAttribute(this.mNewWeightSum));
            }
        }
    }

    private static class MatchPos {
        private int mDistance;
        private int mPosition;

        public MatchPos(int distance, int position) {
            this.mDistance = distance;
            this.mPosition = position;
        }

        public String toString() {
            return "MatchPos [distance=" + this.mDistance + ", position=" + this.mPosition + "]";
        }

        private int getDistance() {
            return this.mDistance;
        }

        private int getPosition() {
            return this.mPosition;
        }
    }
}

