/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout;

import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.RuleAction;
import java.util.List;
import org.eclipse.andmore.common.layout.BaseViewRule;

public class EditTextRule
extends BaseViewRule {
    public void onCreate(INode node, INode parent, InsertType insertType) {
        super.onCreate(node, parent, insertType);
        if (parent != null) {
            INode focus = EditTextRule.findFocus(EditTextRule.findRoot(parent));
            if (focus == null) {
                node.appendChild("requestFocus");
            }
            if (parent.getBounds().w >= 320) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "ems", "10");
            }
        }
    }

    @Override
    public void addContextMenuActions(List<RuleAction> actions, final INode selectedNode) {
        super.addContextMenuActions(actions, selectedNode);
        final boolean hasFocus = EditTextRule.hasFocus(selectedNode);
        final String label = hasFocus ? "Clear Focus" : "Request Focus";
        IMenuCallback onChange = new IMenuCallback(){

            public void action(RuleAction menuAction, List<? extends INode> selectedNodes, String valueId, Boolean newValue) {
                selectedNode.editXml(label, new INodeHandler(){

                    public void handle(INode node) {
                        INode focus = EditTextRule.findFocus(EditTextRule.findRoot(node));
                        if (focus != null && focus.getParent() != null) {
                            focus.getParent().removeChild(focus);
                        }
                        if (!hasFocus) {
                            node.appendChild("requestFocus");
                        }
                    }
                });
            }
        };
        actions.add(RuleAction.createAction((String)"_setfocus", (String)label, (IMenuCallback)onChange, null, (int)5, (boolean)false));
        actions.add((RuleAction)RuleAction.createSeparator((int)7));
    }

    private static boolean hasFocus(INode node) {
        INode focus = EditTextRule.findFocus(node);
        if (focus != null) {
            return focus.getParent() == node;
        }
        return false;
    }

    private static INode findRoot(INode node) {
        INode root = node;
        while (root != null) {
            INode parent = root.getParent();
            if (parent == null) break;
            root = parent;
        }
        return root;
    }

    private static INode findFocus(INode node) {
        if (node.getFqcn().equals("requestFocus")) {
            return node;
        }
        INode[] iNodeArray = node.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            INode focus = EditTextRule.findFocus(child);
            if (focus != null) {
                return focus;
            }
            ++n2;
        }
        return null;
    }
}

