/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.ddms.ISourceRevealer;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.ide.IDE;

public class SourceRevealer
implements ISourceRevealer {
    private static final Predicate<SearchMatch> MATCH_IS_FILE_PREDICATE = new Predicate<SearchMatch>(){

        public boolean apply(SearchMatch match) {
            return match.getResource() instanceof IFile;
        }
    };
    private static final Predicate<SearchMatch> MATCH_IS_METHOD_PREDICATE = new Predicate<SearchMatch>(){

        public boolean apply(SearchMatch match) {
            return match.getResource() instanceof IFile;
        }
    };

    public boolean reveal(String applicationName, String className, int line) {
        IProject project = ProjectHelper.findAndroidProjectByAppName(applicationName);
        if (project != null) {
            return BaseProjectHelper.revealSource(project, className, line);
        }
        return false;
    }

    public boolean revealMethod(String fqmn, String fileName, int lineNumber, String perspective) {
        List<Object> fileMatches = Collections.emptyList();
        if (fileName != null && lineNumber >= 0 && (fileMatches = this.searchForFile(fileName)).size() == 1) {
            return this.revealLineMatch(fileMatches, fileName, lineNumber, perspective);
        }
        List<SearchMatch> methodMatches = this.searchForMethod(fqmn);
        if (methodMatches.size() == 1) {
            if (fileMatches.size() > 0) {
                List<SearchMatch> filteredMatches = this.filterMatchByResource(fileMatches, methodMatches.get(0).getResource());
                if (filteredMatches.size() == 1) {
                    return this.revealLineMatch(filteredMatches, fileName, lineNumber, perspective);
                }
            } else if (fileName != null && lineNumber > 0) {
                IMethod method;
                IMethod element = method = (IMethod)methodMatches.get(0).getElement();
                while (element != null) {
                    ICompilationUnit unit;
                    IResource resource;
                    if (element instanceof ICompilationUnit && (resource = (unit = ((ICompilationUnit)element).getPrimary()).getResource()) instanceof IFile) {
                        IFile file = (IFile)resource;
                        try {
                            ISourceRange sourceRange = method.getSourceRange();
                            IRegion region = AdtUtils.getRegionOfLine(file, lineNumber - 1);
                            boolean isConstructor = fqmn.endsWith("<init>");
                            if (isConstructor || region != null && region.getOffset() >= sourceRange.getOffset() && region.getOffset() < sourceRange.getOffset() + sourceRange.getLength()) {
                                if (perspective != null) {
                                    SourceRevealer.switchToPerspective(perspective);
                                }
                                return this.displayFile(file, lineNumber);
                            }
                        }
                        catch (JavaModelException e) {
                            AndmoreAndroidPlugin.log(e, null, new Object[0]);
                        }
                    }
                    element = element.getParent();
                }
            }
            return this.displayMethod((IMethod)methodMatches.get(0).getElement(), perspective);
        }
        if (methodMatches.size() == 0) {
            if (fileMatches.size() > 0) {
                return this.revealLineMatch(fileMatches, fileName, lineNumber, perspective);
            }
            if (fileMatches.isEmpty() && fqmn.indexOf(46) != -1) {
                String className = fqmn.substring(0, fqmn.lastIndexOf(46));
                IJavaProject[] iJavaProjectArray = BaseProjectHelper.getAndroidProjects(null);
                int n = iJavaProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject project = iJavaProjectArray[n2];
                    try {
                        IResource resource;
                        IType type = project.findType(className);
                        if (type != null && type.exists() && (resource = type.getResource()) instanceof IFile) {
                            if (perspective != null) {
                                SourceRevealer.switchToPerspective(perspective);
                            }
                            return this.displayFile((IFile)resource, lineNumber);
                        }
                    }
                    catch (JavaModelException e) {
                        AndmoreAndroidPlugin.log(e, null, new Object[0]);
                    }
                    ++n2;
                }
            }
            return false;
        }
        if (fileName != null) {
            return this.revealLineMatch(this.filterMatchByFileName(methodMatches, fileName), fileName, lineNumber, perspective);
        }
        SearchMatch match = this.getMatchToDisplay(methodMatches, fqmn);
        if (match == null) {
            return false;
        }
        return this.displayMethod((IMethod)match.getElement(), perspective);
    }

    private boolean revealLineMatch(List<SearchMatch> matches, String fileName, int lineNumber, String perspective) {
        SearchMatch match = this.getMatchToDisplay(matches, String.format("%s:%d", fileName, lineNumber));
        if (match == null) {
            return false;
        }
        if (perspective != null) {
            SourceRevealer.switchToPerspective(perspective);
        }
        return this.displayFile((IFile)match.getResource(), lineNumber);
    }

    private boolean displayFile(IFile file, int lineNumber) {
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttribute("lineNumber", lineNumber);
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
            marker.delete();
            return true;
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.printErrorToConsole(e.getMessage(), new Object[0]);
            return false;
        }
    }

    private boolean displayMethod(IMethod method, String perspective) {
        if (perspective != null) {
            SourceRevealer.switchToPerspective(perspective);
        }
        try {
            JavaUI.openInEditor((IJavaElement)method);
            return true;
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.printErrorToConsole(e.getMessage(), new Object[0]);
            return false;
        }
    }

    private List<SearchMatch> filterMatchByFileName(List<SearchMatch> matches, String fileName) {
        if (fileName == null) {
            return matches;
        }
        HashMap<IResource, SearchMatch> matchesPerFile = new HashMap<IResource, SearchMatch>(matches.size());
        for (SearchMatch m : matches) {
            if (!(m.getResource() instanceof IFile) || !m.getResource().getName().startsWith(fileName)) continue;
            matchesPerFile.put(m.getResource(), m);
        }
        ArrayList<SearchMatch> filteredMatches = new ArrayList<SearchMatch>(matchesPerFile.values());
        Collections.sort(filteredMatches, new Comparator<SearchMatch>(){

            @Override
            public int compare(SearchMatch m1, SearchMatch m2) {
                String p2;
                String p1 = m1.getResource().getProject().getName();
                if (!p1.equals(p2 = m2.getResource().getProject().getName())) {
                    return p1.compareTo(p2);
                }
                String r1 = m1.getResource().getName();
                String r2 = m2.getResource().getName();
                return r1.compareTo(r2);
            }
        });
        return filteredMatches;
    }

    private List<SearchMatch> filterMatchByResource(List<SearchMatch> matches, IResource resource) {
        ArrayList<SearchMatch> filteredMatches = new ArrayList<SearchMatch>(matches.size());
        for (SearchMatch m : matches) {
            if (!m.getResource().equals((Object)resource)) continue;
            filteredMatches.add(m);
        }
        return filteredMatches;
    }

    private SearchMatch getMatchToDisplay(List<SearchMatch> matches, String searchTerm) {
        Object[] selectedMatches;
        if (matches.size() == 0) {
            return null;
        }
        if (matches.size() == 1) {
            return matches.get(0);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ListDialog dlg = new ListDialog(window.getShell());
        dlg.setMessage("Multiple files match search: " + searchTerm);
        dlg.setTitle("Select file to open");
        dlg.setInput(matches);
        dlg.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                SearchMatch m = (SearchMatch)element;
                return String.format("/%s/%s", m.getResource().getProject().getName(), m.getResource().getProjectRelativePath().toString());
            }
        });
        dlg.setInitialSelections(new Object[]{matches.get(0)});
        dlg.setHelpAvailable(false);
        if (dlg.open() == 0 && (selectedMatches = dlg.getResult()).length > 0) {
            return (SearchMatch)selectedMatches[0];
        }
        return null;
    }

    private List<SearchMatch> searchForFile(String fileName) {
        return this.searchForPattern(fileName, 5, MATCH_IS_FILE_PREDICATE);
    }

    private List<SearchMatch> searchForMethod(String fqmn) {
        if (fqmn.endsWith("<init>")) {
            fqmn = fqmn.substring(0, fqmn.length() - "<init>".length() - 1);
            return this.searchForPattern(fqmn, 3, MATCH_IS_METHOD_PREDICATE);
        }
        if (fqmn.endsWith("<clinit>")) {
            return Collections.emptyList();
        }
        return this.searchForPattern(fqmn, 1, MATCH_IS_METHOD_PREDICATE);
    }

    private List<SearchMatch> searchForPattern(String pattern, int searchFor, Predicate<SearchMatch> filterPredicate) {
        SearchEngine se = new SearchEngine();
        SearchPattern searchPattern = SearchPattern.createPattern((String)pattern, (int)searchFor, (int)0, (int)8);
        SearchResultAccumulator requestor = new SearchResultAccumulator(filterPredicate);
        try {
            se.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.printErrorToConsole(e.getMessage(), new Object[0]);
            return Collections.emptyList();
        }
        return requestor.getMatches();
    }

    private static void switchToPerspective(String perspectiveId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IPerspectiveRegistry perspectiveRegistry = workbench.getPerspectiveRegistry();
        if (perspectiveId != null && perspectiveId.length() > 0 && perspectiveRegistry.findPerspectiveWithId(perspectiveId) != null) {
            try {
                workbench.showPerspective(perspectiveId, window);
            }
            catch (WorkbenchException e) {
                AndmoreAndroidPlugin.printErrorToConsole(e.getMessage(), new Object[0]);
            }
        }
    }

    private static class SearchResultAccumulator
    extends SearchRequestor {
        private final List<SearchMatch> mSearchMatches = new ArrayList<SearchMatch>();
        private final Predicate<SearchMatch> mPredicate;

        public SearchResultAccumulator(Predicate<SearchMatch> filterPredicate) {
            this.mPredicate = filterPredicate;
        }

        public List<SearchMatch> getMatches() {
            return this.mSearchMatches;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (this.mPredicate.apply((Object)match)) {
                this.mSearchMatches.add(match);
            }
        }
    }
}

