/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdkuilib.internal.widgets.ResolutionChooserDialog;
import com.android.sdkuilib.ui.GridDialog;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

final class AvdStartDialog
extends GridDialog {
    private static boolean sWipeData = false;
    private static boolean sSnapshotSave = true;
    private static boolean sSnapshotLaunch = true;
    private static int sMonitorDpi = 72;
    private static final Map<String, String> sSkinScaling = new HashMap<String, String>();
    private static final Pattern sScreenSizePattern = Pattern.compile("\\d*(\\.\\d?)?");
    private final AvdInfo mAvd;
    private final File mSdkLocation;
    private final SettingsController mSettingsController;
    private final DeviceManager mDeviceManager;
    private Text mScreenSize;
    private Text mMonitorDpi;
    private Button mScaleButton;
    private float mScale = 0.0f;
    private boolean mWipeData = false;
    private int mDensity = 160;
    private int mSize1 = -1;
    private int mSize2 = -1;
    private String mSkinDisplay;
    private boolean mEnableScaling = true;
    private Label mScaleField;
    private boolean mHasSnapshot = true;
    private boolean mSnapshotSave = true;
    private boolean mSnapshotLaunch = true;
    private Button mSnapshotLaunchCheckbox;

    AvdStartDialog(Shell parentShell, AvdInfo avd, File sdkLocation, SettingsController settingsController, ILogger sdkLog) {
        super(parentShell, 2, false);
        this.mAvd = avd;
        this.mSdkLocation = sdkLocation;
        this.mSettingsController = settingsController;
        this.mDeviceManager = DeviceManager.createInstance((File)this.mSdkLocation, (ILogger)sdkLog);
        if (this.mAvd == null) {
            throw new IllegalArgumentException("avd cannot be null");
        }
        if (this.mSdkLocation == null) {
            throw new IllegalArgumentException("sdkLocation cannot be null");
        }
        this.computeSkinData();
    }

    public boolean hasWipeData() {
        return this.mWipeData;
    }

    public float getScale() {
        return this.mScale;
    }

    @Override
    public void createDialogContent(final Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Skin:");
        l = new Label(parent, 0);
        l.setText(this.mSkinDisplay == null ? "None" : this.mSkinDisplay);
        l.setLayoutData((Object)new GridData(768));
        l = new Label(parent, 0);
        l.setText("Density:");
        l = new Label(parent, 0);
        l.setText(this.getDensityText());
        l.setLayoutData((Object)new GridData(768));
        this.mScaleButton = new Button(parent, 32);
        this.mScaleButton.setText("Scale display to real size");
        this.mScaleButton.setEnabled(this.mEnableScaling);
        boolean defaultState = this.mEnableScaling && sSkinScaling.get(this.mAvd.getName()) != null;
        this.mScaleButton.setSelection(defaultState);
        GridData gd = new GridData(768);
        this.mScaleButton.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        final Group scaleGroup = new Group(parent, 0);
        gd = new GridData(768);
        scaleGroup.setLayoutData((Object)gd);
        gd.horizontalIndent = 30;
        gd.horizontalSpan = 2;
        scaleGroup.setLayout((Layout)new GridLayout(3, false));
        l = new Label((Composite)scaleGroup, 0);
        l.setText("Screen Size (in):");
        this.mScreenSize = new Text((Composite)scaleGroup, 2048);
        this.mScreenSize.setText(this.getScreenSize());
        this.mScreenSize.setLayoutData((Object)new GridData(768));
        this.mScreenSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String text = AvdStartDialog.this.mScreenSize.getText();
                text = text.substring(0, event.start) + event.text + text.substring(event.end);
                event.doit = sScreenSizePattern.matcher(text).matches();
            }
        });
        this.mScreenSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AvdStartDialog.this.onScaleChange();
            }
        });
        gd = new GridData();
        new Composite((Composite)scaleGroup, 0).setLayoutData((Object)gd);
        gd.heightHint = 0;
        gd.widthHint = 0;
        l = new Label((Composite)scaleGroup, 0);
        l.setText("Monitor dpi:");
        this.mMonitorDpi = new Text((Composite)scaleGroup, 2048);
        this.mMonitorDpi.setText(Integer.toString(this.getMonitorDpi()));
        gd = new GridData(768);
        this.mMonitorDpi.setLayoutData((Object)gd);
        gd.widthHint = 50;
        this.mMonitorDpi.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                for (int i = 0; i < event.text.length(); ++i) {
                    char letter = event.text.charAt(i);
                    if (letter >= '0' && letter <= '9') continue;
                    event.doit = false;
                    return;
                }
            }
        });
        this.mMonitorDpi.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AvdStartDialog.this.onScaleChange();
            }
        });
        Button button = new Button((Composite)scaleGroup, 0x800008);
        button.setText("?");
        button.setToolTipText("Click to figure out your monitor's pixel density");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ResolutionChooserDialog dialog = new ResolutionChooserDialog(parent.getShell());
                if (dialog.open() == 0) {
                    AvdStartDialog.this.mMonitorDpi.setText(Integer.toString(dialog.getDensity()));
                }
            }
        });
        l = new Label((Composite)scaleGroup, 0);
        l.setText("Scale:");
        this.mScaleField = new Label((Composite)scaleGroup, 0);
        this.mScaleField.setLayoutData((Object)new GridData(4, 2, true, true, 2, 1));
        this.setScale(this.mScale);
        this.enableGroup(scaleGroup, defaultState);
        this.mScaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean enabled = AvdStartDialog.this.mScaleButton.getSelection();
                AvdStartDialog.this.enableGroup(scaleGroup, enabled);
                if (enabled) {
                    AvdStartDialog.this.onScaleChange();
                } else {
                    AvdStartDialog.this.setScale(0.0f);
                }
            }
        });
        final Button wipeButton = new Button(parent, 32);
        gd = new GridData(768);
        wipeButton.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        wipeButton.setText("Wipe user data");
        this.mWipeData = sWipeData;
        wipeButton.setSelection(this.mWipeData);
        wipeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdStartDialog.this.mWipeData = wipeButton.getSelection();
                AvdStartDialog.this.updateSnapshotLaunchAvailability();
            }
        });
        Map prop = this.mAvd.getProperties();
        String snapshotPresent = (String)prop.get("snapshot.present");
        this.mHasSnapshot = snapshotPresent != null && snapshotPresent.equals("true");
        this.mSnapshotLaunchCheckbox = new Button(parent, 32);
        gd = new GridData(768);
        this.mSnapshotLaunchCheckbox.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.mSnapshotLaunchCheckbox.setText("Launch from snapshot");
        this.updateSnapshotLaunchAvailability();
        this.mSnapshotLaunchCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdStartDialog.this.mSnapshotLaunch = AvdStartDialog.this.mSnapshotLaunchCheckbox.getSelection();
            }
        });
        final Button snapshotSaveCheckbox = new Button(parent, 32);
        gd = new GridData(768);
        snapshotSaveCheckbox.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        snapshotSaveCheckbox.setText("Save to snapshot");
        this.mSnapshotSave = sSnapshotSave;
        snapshotSaveCheckbox.setSelection(this.mSnapshotSave && this.mHasSnapshot);
        snapshotSaveCheckbox.setEnabled(this.mHasSnapshot);
        snapshotSaveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvdStartDialog.this.mSnapshotSave = snapshotSaveCheckbox.getSelection();
            }
        });
        l = new Label(parent, 258);
        gd = new GridData(768);
        l.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        if (defaultState) {
            this.onScaleChange();
        }
    }

    private void enableGroup(Group group, boolean enabled) {
        group.setEnabled(enabled);
        for (Control c : group.getChildren()) {
            c.setEnabled(enabled);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Launch Options");
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = "Launch";
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void okPressed() {
        String size;
        String dpi = this.mMonitorDpi.getText();
        if (dpi.length() > 0) {
            sMonitorDpi = Integer.parseInt(dpi);
            if (this.mSettingsController != null) {
                this.mSettingsController.setMonitorDensity(sMonitorDpi);
                this.mSettingsController.saveSettings();
            }
        }
        String key = this.mAvd.getName();
        sSkinScaling.remove(key);
        if (this.mScaleButton.getSelection() && (size = this.mScreenSize.getText()).length() > 0) {
            sSkinScaling.put(key, size);
        }
        sWipeData = this.mWipeData;
        if (this.mHasSnapshot) {
            sSnapshotSave = this.mSnapshotSave;
            if (!this.mWipeData) {
                sSnapshotLaunch = this.mSnapshotLaunch;
            }
        }
        super.okPressed();
    }

    private void computeSkinData() {
        Map prop = this.mAvd.getProperties();
        String dpi = (String)prop.get("hw.lcd.density");
        if (dpi != null && dpi.length() > 0) {
            this.mDensity = Integer.parseInt(dpi);
        }
        this.findSkinResolution();
    }

    private void onScaleChange() {
        float size;
        String sizeStr = this.mScreenSize.getText();
        if (sizeStr.length() == 0) {
            this.setScale(0.0f);
            return;
        }
        String dpiStr = this.mMonitorDpi.getText();
        if (dpiStr.length() == 0) {
            this.setScale(0.0f);
            return;
        }
        int dpi = Integer.parseInt(dpiStr);
        try {
            size = (float)SdkUtils.parseLocalizedDouble((String)sizeStr);
        }
        catch (ParseException e) {
            this.setScale(0.0f);
            return;
        }
        float diagonalPx = (float)Math.sqrt(this.mSize1 * this.mSize1 + this.mSize2 * this.mSize2);
        this.setScale(size * (float)dpi / diagonalPx);
    }

    private void setScale(float scale) {
        this.mScale = scale;
        scale = Math.round(scale * 100.0f);
        if ((scale /= 100.0f) == 0.0f) {
            this.mScaleField.setText("default");
        } else {
            this.mScaleField.setText(String.format(Locale.getDefault(), "%.2f", Float.valueOf(scale)));
        }
    }

    private int getMonitorDpi() {
        if (this.mSettingsController != null) {
            sMonitorDpi = this.mSettingsController.getSettings().getMonitorDensity();
        }
        if (sMonitorDpi == -1) {
            sMonitorDpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return sMonitorDpi;
    }

    private String getScreenSize() {
        String size = sSkinScaling.get(this.mAvd.getName());
        if (size != null) {
            return size;
        }
        Map properties = this.mAvd.getProperties();
        if (properties != null) {
            Device d;
            String name = (String)properties.get("hw.device.name");
            String mfctr = (String)properties.get("hw.device.manufacturer");
            if (name != null && mfctr != null && (d = this.mDeviceManager.getDevice(name, mfctr)) != null) {
                double screenSize = d.getDefaultHardware().getScreen().getDiagonalLength();
                return String.format(Locale.getDefault(), "%.1f", screenSize);
            }
        }
        return "3";
    }

    private String getDensityText() {
        switch (this.mDensity) {
            case 120: {
                return "Low (120)";
            }
            case 160: {
                return "Medium (160)";
            }
            case 240: {
                return "High (240)";
            }
        }
        return Integer.toString(this.mDensity);
    }

    private void findSkinResolution() {
        File layoutFile;
        File skinFolder;
        Matcher m;
        Map prop = this.mAvd.getProperties();
        String skinName = (String)prop.get("skin.name");
        if (skinName != null && (m = AvdManager.NUMERIC_SKIN_SIZE.matcher(skinName)) != null && m.matches()) {
            this.mSize1 = Integer.parseInt(m.group(1));
            this.mSize2 = Integer.parseInt(m.group(2));
            this.mSkinDisplay = skinName;
            this.mEnableScaling = true;
            return;
        }
        this.mEnableScaling = false;
        String skinPath = (String)prop.get("skin.path");
        if (skinPath != null && (skinFolder = new File(this.mSdkLocation, skinPath)).isDirectory() && (layoutFile = new File(skinFolder, "layout")).isFile()) {
            if (this.parseLayoutFile(layoutFile)) {
                this.mSkinDisplay = String.format("%1$s (%2$dx%3$d)", skinName, this.mSize1, this.mSize2);
                this.mEnableScaling = true;
            } else {
                this.mSkinDisplay = skinName;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseLayoutFile(File layoutFile) {
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(layoutFile));
            while (true) {
                String line;
                if ((line = input.readLine()) != null) {
                    String[] tokens;
                    int len = (line = line.trim()).length();
                    if (len == 0) continue;
                    if (line.charAt(len - 1) != '{' || !"display".equals((tokens = line.split(" "))[0])) continue;
                    while ((this.mSize1 == -1 || this.mSize2 == -1) && (line = input.readLine()) != null) {
                        len = (line = line.trim()).length();
                        if (len == 0) continue;
                        if ("}".equals(line)) break;
                        tokens = line.split(" ");
                        if (tokens.length < 2) continue;
                        if ("width".equals(tokens[0])) {
                            this.mSize1 = Integer.parseInt(tokens[tokens.length - 1]);
                            continue;
                        }
                        if (!"height".equals(tokens[0])) continue;
                        this.mSize2 = Integer.parseInt(tokens[tokens.length - 1]);
                    }
                    boolean bl = this.mSize1 != -1 && this.mSize2 != -1;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    public boolean hasSnapshot() {
        return this.mHasSnapshot;
    }

    public boolean hasSnapshotLaunch() {
        return this.mSnapshotLaunch && !this.hasWipeData();
    }

    public boolean hasSnapshotSave() {
        return this.mSnapshotSave;
    }

    private void updateSnapshotLaunchAvailability() {
        boolean enabled = !this.mWipeData && this.mHasSnapshot;
        this.mSnapshotLaunchCheckbox.setEnabled(enabled);
        this.mSnapshotLaunch = enabled && sSnapshotLaunch;
        this.mSnapshotLaunchCheckbox.setSelection(this.mSnapshotLaunch);
    }
}

