/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.sdkuilib.ui.SwtBaseDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

final class AvdDetailsDialog
extends SwtBaseDialog {
    private final AvdInfo mAvdInfo;

    public AvdDetailsDialog(Shell shell, AvdInfo avdInfo) {
        super(shell, 65536, "AVD details");
        this.mAvdInfo = avdInfo;
    }

    @Override
    protected void createContents() {
        Shell shell = this.getShell();
        GridLayoutBuilder.create((Composite)shell).columns(2);
        GridDataBuilder.create((Control)shell).fill();
        Composite c = new Composite((Composite)shell, 0);
        GridLayout gl = new GridLayout(2, false);
        c.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayoutData((Object)new GridData(768));
        if (this.mAvdInfo != null) {
            this.displayValue(c, "Name:", this.mAvdInfo.getName());
            this.displayValue(c, "CPU/ABI:", AvdInfo.getPrettyAbiType((AvdInfo)this.mAvdInfo));
            this.displayValue(c, "Path:", this.mAvdInfo.getDataFolderPath());
            if (this.mAvdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
                this.displayValue(c, "Error:", this.mAvdInfo.getErrorMessage());
            } else {
                IAndroidTarget target = this.mAvdInfo.getTarget();
                AndroidVersion version = target.getVersion();
                this.displayValue(c, "Target:", String.format("%s (API level %s)", target.getName(), version.getApiString()));
                Map properties = this.mAvdInfo.getProperties();
                if (properties != null) {
                    String snapshot;
                    String sdcard;
                    String skin = (String)properties.get("skin.name");
                    if (skin != null) {
                        this.displayValue(c, "Skin:", skin);
                    }
                    if ((sdcard = (String)properties.get("sdcard.size")) == null) {
                        sdcard = (String)properties.get("sdcard.path");
                    }
                    if (sdcard != null) {
                        this.displayValue(c, "SD Card:", sdcard);
                    }
                    if ((snapshot = (String)properties.get("snapshot.present")) != null) {
                        this.displayValue(c, "Snapshot:", snapshot);
                    }
                    HashMap copy = new HashMap(properties);
                    copy.remove("abi.type");
                    copy.remove("hw.cpu.arch");
                    copy.remove("skin.name");
                    copy.remove("skin.path");
                    copy.remove("sdcard.size");
                    copy.remove("sdcard.path");
                    copy.remove("image.sysdir.1");
                    copy.remove("image.sysdir.2");
                    if (copy.size() > 0) {
                        Label l = new Label((Composite)shell, 258);
                        l.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
                        c = new Composite((Composite)shell, 0);
                        gl = new GridLayout(2, false);
                        c.setLayout((Layout)gl);
                        gl.marginWidth = 0;
                        gl.marginHeight = 0;
                        c.setLayoutData((Object)new GridData(1808));
                        for (Map.Entry entry : copy.entrySet()) {
                            this.displayValue(c, (String)entry.getKey() + ":", (String)entry.getValue());
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void postCreate() {
    }

    private void displayValue(Composite parent, String label, String value) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(3, 2, false, false));
        l = new Label(parent, 0);
        l.setText(value);
        l.setLayoutData((Object)new GridData(4, 2, true, false));
    }
}

