/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.UserCredentials;
import com.android.sdkuilib.internal.tasks.ILogUiProvider;
import com.android.sdkuilib.internal.tasks.IProgressUiProvider;
import com.android.sdkuilib.internal.tasks.TaskMonitorImpl;
import com.android.sdkuilib.ui.AuthenticationDialog;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class ProgressView
implements IProgressUiProvider {
    private State mState = State.IDLE;
    private final Label mLabel;
    private final Control mStopButton;
    private final ProgressBar mProgressBar;
    private final ILogUiProvider mLog;

    public ProgressView(Label label, ProgressBar progressBar, Control stopButton, ILogUiProvider log) {
        this.mLabel = label;
        this.mProgressBar = progressBar;
        this.mLog = log;
        this.mProgressBar.setEnabled(false);
        this.mStopButton = stopButton;
        if (this.mStopButton != null) {
            this.mStopButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (ProgressView.this.mState == State.ACTIVE) {
                        ProgressView.this.changeState(State.STOP_PENDING);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTask(String title, final ITaskMonitor parentMonitor, final ITask task) {
        if (task != null) {
            try {
                if (parentMonitor == null && !this.mProgressBar.isDisposed()) {
                    this.mLabel.setText(title);
                    this.mProgressBar.setSelection(0);
                    this.mProgressBar.setEnabled(true);
                    this.changeState(State.ACTIVE);
                }
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (parentMonitor == null) {
                            task.run((ITaskMonitor)new TaskMonitorImpl(ProgressView.this));
                        } else {
                            if (parentMonitor.getProgressMax() == 0) {
                                parentMonitor.setProgressMax(1);
                            }
                            ITaskMonitor sub = parentMonitor.createSubMonitor(parentMonitor.getProgressMax() - parentMonitor.getProgress());
                            try {
                                task.run(sub);
                            }
                            finally {
                                int delta = sub.getProgressMax() - sub.getProgress();
                                if (delta > 0) {
                                    sub.incProgress(delta);
                                }
                            }
                        }
                    }
                };
                if (this.mProgressBar.isDisposed()) {
                    return;
                }
                if (TaskMonitorImpl.isTaskMonitorImpl(parentMonitor)) {
                    r.run();
                } else {
                    Thread t = new Thread(r, title);
                    t.start();
                    while (!this.mProgressBar.isDisposed() && t.isAlive()) {
                        Display display = this.mProgressBar.getDisplay();
                        if (this.mProgressBar.isDisposed() || display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                if (parentMonitor == null && !this.mProgressBar.isDisposed()) {
                    this.changeState(State.IDLE);
                    this.mProgressBar.setSelection(0);
                    this.mProgressBar.setEnabled(false);
                }
            }
        }
    }

    private void syncExec(final Widget widget, final Runnable runnable) {
        if (widget != null && !widget.isDisposed()) {
            widget.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!widget.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private void changeState(State state) {
        if (this.mState != null) {
            this.mState = state;
        }
        this.syncExec((Widget)this.mStopButton, new Runnable(){

            @Override
            public void run() {
                ProgressView.this.mStopButton.setEnabled(ProgressView.this.mState == State.ACTIVE);
            }
        });
    }

    @Override
    public boolean isCancelRequested() {
        return this.mState != State.ACTIVE;
    }

    @Override
    public void setDescription(final String description) {
        this.syncExec((Widget)this.mLabel, new Runnable(){

            @Override
            public void run() {
                ProgressView.this.mLabel.setText(description);
            }
        });
        this.mLog.setDescription(description);
    }

    @Override
    public void log(String log) {
        this.mLog.log(log);
    }

    @Override
    public void logError(String log) {
        this.mLog.logError(log);
    }

    @Override
    public void logVerbose(String log) {
        this.mLog.logVerbose(log);
    }

    @Override
    public void setProgressMax(final int max) {
        this.syncExec((Widget)this.mProgressBar, new Runnable(){

            @Override
            public void run() {
                ProgressView.this.mProgressBar.setMaximum(max);
            }
        });
    }

    @Override
    public void setProgress(final int value) {
        this.syncExec((Widget)this.mProgressBar, new Runnable(){

            @Override
            public void run() {
                ProgressView.this.mProgressBar.setSelection(value);
            }
        });
    }

    @Override
    public int getProgress() {
        final int[] result = new int[]{0};
        if (!this.mProgressBar.isDisposed()) {
            this.mProgressBar.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ProgressView.this.mProgressBar.isDisposed()) {
                        result[0] = ProgressView.this.mProgressBar.getSelection();
                    }
                }
            });
        }
        return result[0];
    }

    @Override
    public boolean displayPrompt(final String title, final String message) {
        final boolean[] result = new boolean[]{false};
        this.syncExec((Widget)this.mProgressBar, new Runnable(){

            @Override
            public void run() {
                Shell shell = ProgressView.this.mProgressBar.getShell();
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return result[0];
    }

    @Override
    public UserCredentials displayLoginCredentialsPrompt(final String title, final String message) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.syncExec((Widget)this.mProgressBar, new Runnable(){

            @Override
            public void run() {
                Shell shell = ProgressView.this.mProgressBar.getShell();
                AuthenticationDialog authenticationDialog = new AuthenticationDialog(shell, title, message);
                int dlgResult = authenticationDialog.open();
                if (dlgResult == 0) {
                    result.set(new UserCredentials(authenticationDialog.getLogin(), authenticationDialog.getPassword(), authenticationDialog.getWorkstation(), authenticationDialog.getDomain()));
                }
            }
        });
        return result.get();
    }

    private static enum State {
        IDLE,
        ACTIVE,
        STOP_PENDING;

    }
}

