/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.SdkConstants;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.updater.PackageLoader;
import com.android.sdklib.internal.repository.updater.PkgItem;
import com.android.sdklib.internal.repository.updater.UpdaterData;
import com.android.sdklib.repository.IDescription;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.core.PackagesDiffLogic;
import com.android.sdkuilib.internal.repository.core.PkgCategory;
import com.android.sdkuilib.internal.repository.core.PkgCategoryApi;
import com.android.sdkuilib.internal.repository.core.PkgContentProvider;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.repository.ui.PkgTreeColumnViewerLabelProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IInputProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

abstract class PackagesPageImpl {
    final SwtUpdaterData mSwtUpdaterData;
    final PackagesDiffLogic mDiffLogic;
    private ICheckboxTreeViewer mITreeViewer;
    private ITreeViewerColumn mIColumnName;
    private ITreeViewerColumn mIColumnApi;
    private ITreeViewerColumn mIColumnRevision;
    private ITreeViewerColumn mIColumnStatus;

    PackagesPageImpl(SwtUpdaterData swtUpdaterData) {
        this.mSwtUpdaterData = swtUpdaterData;
        this.mDiffLogic = new PackagesDiffLogic(swtUpdaterData);
    }

    protected abstract boolean isUiDisposed();

    protected abstract void syncExec(Runnable var1);

    protected abstract void syncViewerSelection();

    void performFirstLoad() {
        this.loadPackages(true, false);
        this.loadPackages(false, true);
    }

    public void setITreeViewer(ICheckboxTreeViewer iTreeViewer) {
        this.mITreeViewer = iTreeViewer;
    }

    public void setIColumns(ITreeViewerColumn columnName, ITreeViewerColumn columnApi, ITreeViewerColumn columnRevision, ITreeViewerColumn columnStatus) {
        this.mIColumnName = columnName;
        this.mIColumnApi = columnApi;
        this.mIColumnRevision = columnRevision;
        this.mIColumnStatus = columnStatus;
    }

    void postCreate() {
        assert (this.mITreeViewer != null);
        assert (this.mIColumnApi != null);
        assert (this.mIColumnName != null);
        assert (this.mIColumnStatus != null);
        assert (this.mIColumnRevision != null);
        this.mITreeViewer.setContentProvider(new PkgContentProvider(this.mITreeViewer));
        this.mIColumnApi.setLabelProvider((ColumnLabelProvider)new PkgTreeColumnViewerLabelProvider(new PkgCellLabelProvider(this.mIColumnApi)));
        this.mIColumnName.setLabelProvider((ColumnLabelProvider)new PkgTreeColumnViewerLabelProvider(new PkgCellLabelProvider(this.mIColumnName)));
        this.mIColumnStatus.setLabelProvider((ColumnLabelProvider)new PkgTreeColumnViewerLabelProvider(new PkgCellLabelProvider(this.mIColumnStatus)));
        this.mIColumnRevision.setLabelProvider((ColumnLabelProvider)new PkgTreeColumnViewerLabelProvider(new PkgCellLabelProvider(this.mIColumnRevision)));
    }

    void fullReload() {
        this.mSwtUpdaterData.getSources().clearAllPackages();
        this.localReload();
    }

    void localReload() {
        this.mSwtUpdaterData.getLocalSdkParser().clearPackages();
        this.mSwtUpdaterData.getSdkManager().reloadSdk(this.mSwtUpdaterData.getSdkLog());
        this.loadPackages();
    }

    void loadPackages() {
        this.loadPackages(false, false);
    }

    protected abstract void loadPackages(boolean var1, boolean var2);

    void loadPackagesImpl(final boolean useLocalCache, boolean overrideExisting) {
        if (this.mSwtUpdaterData == null) {
            return;
        }
        PackageLoader packageLoader = this.getPackageLoader(useLocalCache);
        assert (packageLoader != null);
        this.mDiffLogic.updateStart();
        packageLoader.loadPackages(overrideExisting, new PackageLoader.ISourceLoadedCallback(){

            public boolean onUpdateSource(SdkSource source, Package[] newPackages) {
                final boolean changed = PackagesPageImpl.this.mDiffLogic.updateSourcePackages(source, newPackages);
                PackagesPageImpl.this.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (changed || PackagesPageImpl.this.mITreeViewer.getInput() != PackagesPageImpl.this.mDiffLogic.getCategories()) {
                            PackagesPageImpl.this.refreshViewerInput();
                        }
                    }
                });
                return !PackagesPageImpl.this.isUiDisposed();
            }

            public void onLoadCompleted() {
                final boolean changed = PackagesPageImpl.this.mDiffLogic.updateEnd();
                PackagesPageImpl.this.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Object[] checked;
                        if (changed || PackagesPageImpl.this.mITreeViewer.getInput() != PackagesPageImpl.this.mDiffLogic.getCategories()) {
                            try {
                                PackagesPageImpl.this.refreshViewerInput();
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        if (!(useLocalCache || !PackagesPageImpl.this.mDiffLogic.isFirstLoadComplete() || PackagesPageImpl.this.isUiDisposed() || (checked = PackagesPageImpl.this.mITreeViewer.getCheckedElements()) != null && checked.length != 0)) {
                            PackagesPageImpl.this.onSelectNewUpdates(false, true, true);
                        }
                    }
                });
            }
        });
    }

    protected PackageLoader getPackageLoader(boolean useLocalCache) {
        if (useLocalCache) {
            return new PackageLoader((UpdaterData)this.mSwtUpdaterData, new DownloadCache(DownloadCache.Strategy.ONLY_CACHE));
        }
        return this.mSwtUpdaterData.getPackageLoader();
    }

    protected abstract void refreshViewerInput();

    protected void setViewerInput() {
        List<PkgCategory> cats = this.mDiffLogic.getCategories();
        if (this.mITreeViewer.getInput() != cats) {
            this.mITreeViewer.setInput(cats);
        } else {
            this.mITreeViewer.refresh();
        }
    }

    void onSelectNewUpdates(boolean selectNew, boolean selectUpdates, boolean selectTop) {
        this.mDiffLogic.checkNewUpdateItems(selectNew, selectUpdates, selectTop, SdkConstants.CURRENT_PLATFORM);
        this.syncViewerSelection();
    }

    void onDeselectAll() {
        this.mDiffLogic.uncheckAllItems();
    }

    protected abstract Font getTreeFontItalic();

    static interface ITreeViewerColumn {
        public void setLabelProvider(ColumnLabelProvider var1);
    }

    static interface ICheckboxTreeViewer
    extends IInputProvider {
        public void setContentProvider(PkgContentProvider var1);

        public void refresh();

        public void setInput(List<PkgCategory> var1);

        public Object[] getCheckedElements();
    }

    class PkgCellLabelProvider
    extends ColumnLabelProvider
    implements ITableFontProvider {
        private final ITreeViewerColumn mColumn;

        public PkgCellLabelProvider(ITreeViewerColumn column) {
            this.mColumn = column;
        }

        public String getText(Object element) {
            if (this.mColumn == PackagesPageImpl.this.mIColumnName) {
                if (element instanceof PkgCategory) {
                    return ((PkgCategory)element).getLabel();
                }
                if (element instanceof PkgItem) {
                    return this.getPkgItemName((PkgItem)element);
                }
                if (element instanceof IDescription) {
                    return ((IDescription)element).getShortDescription();
                }
            } else if (this.mColumn == PackagesPageImpl.this.mIColumnApi) {
                AndroidVersion version = null;
                if (element instanceof PkgItem) {
                    version = ((PkgItem)element).getAndroidVersion();
                }
                if (version != null) {
                    return version.getApiString();
                }
            } else if (this.mColumn == PackagesPageImpl.this.mIColumnRevision) {
                if (element instanceof PkgItem) {
                    PkgItem pkg = (PkgItem)element;
                    return pkg.getRevision().toShortString();
                }
            } else if (this.mColumn == PackagesPageImpl.this.mIColumnStatus) {
                if (element instanceof PkgItem) {
                    PkgItem pkg = (PkgItem)element;
                    switch (pkg.getState()) {
                        case INSTALLED: {
                            Package update = pkg.getUpdatePkg();
                            if (update != null) {
                                return String.format("Update available: rev. %1$s", update.getRevision().toShortString());
                            }
                            return "Installed";
                        }
                        case NEW: {
                            Package p = pkg.getMainPackage();
                            if (p != null && p.hasCompatibleArchive()) {
                                return "Not installed";
                            }
                            return String.format("Not compatible with %1$s", SdkConstants.currentPlatformName());
                        }
                    }
                    return pkg.getState().toString();
                }
                if (element instanceof Package) {
                    return "New revision " + ((Package)element).getRevision().toShortString();
                }
            }
            return "";
        }

        private String getPkgItemName(PkgItem item) {
            String name = item.getName().trim();
            PkgCategoryApi cat = (PkgCategoryApi)this.findCategoryForItem(item);
            String apiLabel = cat.getApiLabel();
            String platLabel = cat.getPlatformName();
            if (platLabel != null && name.endsWith(platLabel)) {
                return name.substring(0, name.length() - platLabel.length());
            }
            if (apiLabel != null && name.endsWith(apiLabel)) {
                return name.substring(0, name.length() - apiLabel.length());
            }
            if (platLabel != null && item.isObsolete() && name.indexOf(platLabel) > 0) {
                name = name.replace(platLabel, "");
            }
            name = name.replaceAll(" +", " ");
            return name;
        }

        private PkgCategory findCategoryForItem(PkgItem item) {
            List<PkgCategory> cats = PackagesPageImpl.this.mDiffLogic.getCategories();
            for (PkgCategory cat : cats) {
                for (PkgItem i : cat.getItems()) {
                    if (i != item) continue;
                    return cat;
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            ImageFactory imgFactory = PackagesPageImpl.this.mSwtUpdaterData.getImageFactory();
            if (imgFactory != null) {
                if (this.mColumn == PackagesPageImpl.this.mIColumnName) {
                    if (element instanceof PkgCategory) {
                        return imgFactory.getImageForObject(((PkgCategory)element).getIconRef());
                    }
                    if (element instanceof PkgItem) {
                        return imgFactory.getImageForObject(((PkgItem)element).getMainPackage());
                    }
                    return imgFactory.getImageForObject(element);
                }
                if (this.mColumn == PackagesPageImpl.this.mIColumnStatus && element instanceof PkgItem) {
                    PkgItem pi = (PkgItem)element;
                    switch (pi.getState()) {
                        case INSTALLED: {
                            if (pi.hasUpdatePkg()) {
                                return imgFactory.getImageByName("pkg_update_16.png");
                            }
                            return imgFactory.getImageByName("pkg_installed_16.png");
                        }
                        case NEW: {
                            Package p = pi.getMainPackage();
                            if (p != null && p.hasCompatibleArchive()) {
                                return imgFactory.getImageByName("pkg_new_16.png");
                            }
                            return imgFactory.getImageByName("pkg_incompat_16.png");
                        }
                    }
                }
            }
            return super.getImage(element);
        }

        public Font getFont(Object element, int columnIndex) {
            if (element instanceof PkgItem ? ((PkgItem)element).getState() == PkgItem.PkgState.NEW : element instanceof Package) {
                return PackagesPageImpl.this.getTreeFontItalic();
            }
            return super.getFont(element);
        }

        public String getToolTipText(Object element) {
            PkgItem pi;
            PkgItem pkgItem = pi = element instanceof PkgItem ? (PkgItem)element : null;
            if (pi != null) {
                element = pi.getMainPackage();
            }
            if (element instanceof IDescription) {
                String s = this.getTooltipDescription((IDescription)element);
                if (pi != null && pi.hasUpdatePkg()) {
                    s = s + "\n-----------------\nUpdate Available:\n" + this.getTooltipDescription((IDescription)pi.getUpdatePkg());
                }
                return s;
            }
            return super.getToolTipText(element);
        }

        private String getTooltipDescription(IDescription element) {
            String s = element.getLongDescription();
            if (element instanceof Package) {
                SdkSource src;
                Package p = (Package)element;
                if (!p.isLocal()) {
                    for (Archive a : p.getArchives()) {
                        if (a.isLocal() || !a.isCompatible()) continue;
                        s = s + '\n' + a.getSizeDescription();
                        break;
                    }
                }
                if ((src = p.getParentSource()) != null) {
                    try {
                        URL url = new URL(src.getUrl());
                        String host = url.getHost();
                        s = p.isLocal() ? s + String.format("\nInstalled from %1$s", host) : s + String.format("\nProvided by %1$s", host);
                    }
                    catch (MalformedURLException ignore) {
                        // empty catch block
                    }
                }
            }
            return s;
        }

        public Point getToolTipShift(Object object) {
            return new Point(15, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }
    }
}

