/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PlatformPackage;
import com.android.sdklib.internal.repository.packages.PlatformToolPackage;
import com.android.sdklib.internal.repository.packages.ToolPackage;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.updater.PackageLoader;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.internal.repository.updater.UpdaterData;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.core.SdkLogAdapter;
import com.android.sdkuilib.internal.tasks.ProgressView;
import com.android.sdkuilib.internal.tasks.ProgressViewFactory;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.sdkuilib.ui.SwtBaseDialog;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class AdtUpdateDialog
extends SwtBaseDialog {
    public static final int USE_MAX_REMOTE_API_LEVEL = 0;
    private static final String APP_NAME = "Android SDK Manager";
    private final SwtUpdaterData mUpdaterData;
    private Boolean mResultCode = Boolean.FALSE;
    private Map<Package, File> mResultPaths = null;
    private SettingsController mSettingsController;
    private PackageFilter mPackageFilter;
    private PackageLoader mPackageLoader;
    private ProgressBar mProgressBar;
    private Label mStatusText;

    public AdtUpdateDialog(Shell parentShell, ILogger sdkLog, String osSdkRoot) {
        super(parentShell, 0, APP_NAME);
        this.mUpdaterData = new SwtUpdaterData(osSdkRoot, sdkLog);
    }

    public Pair<Boolean, File> installExtraPackage(String vendor, String path) {
        this.mPackageFilter = AdtUpdateDialog.createExtraFilter(vendor, path);
        this.open();
        File installPath = null;
        if (this.mResultPaths != null) {
            for (Map.Entry<Package, File> entry : this.mResultPaths.entrySet()) {
                if (!(entry.getKey() instanceof ExtraPackage)) continue;
                installPath = entry.getValue();
                break;
            }
        }
        return Pair.of((Object)this.mResultCode, installPath);
    }

    public Pair<Boolean, File> installPlatformTools() {
        this.mPackageFilter = this.createPlatformToolsFilter();
        this.open();
        File installPath = null;
        if (this.mResultPaths != null) {
            for (Map.Entry<Package, File> entry : this.mResultPaths.entrySet()) {
                if (!(entry.getKey() instanceof ExtraPackage)) continue;
                installPath = entry.getValue();
                break;
            }
        }
        return Pair.of((Object)this.mResultCode, installPath);
    }

    public Pair<Boolean, File> installPlatformPackage(int apiLevel) {
        this.mPackageFilter = AdtUpdateDialog.createPlatformFilter(apiLevel);
        this.open();
        File installPath = null;
        if (this.mResultPaths != null) {
            for (Map.Entry<Package, File> entry : this.mResultPaths.entrySet()) {
                if (!(entry.getKey() instanceof PlatformPackage)) continue;
                installPath = entry.getValue();
                break;
            }
        }
        return Pair.of((Object)this.mResultCode, installPath);
    }

    public boolean installNewSdk(Set<Integer> apiLevels) {
        this.mPackageFilter = AdtUpdateDialog.createNewSdkFilter(apiLevels);
        this.open();
        return this.mResultCode;
    }

    @Override
    protected void createContents() {
        Shell shell = this.getShell();
        shell.setMinimumSize(new Point(450, 100));
        shell.setSize(450, 100);
        this.mUpdaterData.setWindowShell(shell);
        GridLayoutBuilder.create((Composite)shell).columns(1);
        Composite composite1 = new Composite((Composite)shell, 0);
        composite1.setLayout((Layout)new GridLayout(1, false));
        GridDataBuilder.create((Control)composite1).fill().grab();
        this.mProgressBar = new ProgressBar(composite1, 0);
        GridDataBuilder.create((Control)this.mProgressBar).hFill().hGrab();
        this.mStatusText = new Label(composite1, 0);
        this.mStatusText.setText("Status Placeholder");
        GridDataBuilder.create((Control)this.mStatusText).hFill().hGrab();
    }

    @Override
    protected void postCreate() {
        ProgressViewFactory factory = new ProgressViewFactory();
        factory.setProgressView(new ProgressView(this.mStatusText, this.mProgressBar, null, new SdkLogAdapter(this.mUpdaterData.getSdkLog())));
        this.mUpdaterData.setTaskFactory(factory);
        this.setupSources();
        this.initializeSettings();
        if (this.mUpdaterData.checkIfInitFailed()) {
            this.close();
            return;
        }
        this.mUpdaterData.broadcastOnSdkLoaded();
        this.mPackageLoader = new PackageLoader((UpdaterData)this.mUpdaterData);
    }

    @Override
    protected void eventLoop() {
        this.mPackageLoader.loadPackagesWithInstallTask(this.mPackageFilter.installFlags(), new PackageLoader.IAutoInstallTask(){

            public Package[] filterLoadedSource(SdkSource source, Package[] packages) {
                for (Package pkg : packages) {
                    AdtUpdateDialog.this.mPackageFilter.visit(pkg);
                }
                return packages;
            }

            public boolean acceptPackage(Package pkg) {
                return AdtUpdateDialog.this.mPackageFilter.accept(pkg);
            }

            public void setResult(boolean success, Map<Package, File> installPaths) {
                AdtUpdateDialog.this.mResultCode = success;
                AdtUpdateDialog.this.mResultPaths = installPaths;
            }

            public void taskCompleted() {
                AdtUpdateDialog.this.close();
            }
        });
        super.eventLoop();
    }

    private void setupSources() {
        this.mUpdaterData.setupDefaultSources();
    }

    private void initializeSettings() {
        this.mSettingsController = this.mUpdaterData.getSettingsController();
        this.mSettingsController.loadSettings();
        this.mSettingsController.applySettings();
    }

    public static PackageFilter createExtraFilter(final String vendor, final String path) {
        return new PackageFilter(){
            String mVendor;
            String mPath;
            {
                this.mVendor = vendor;
                this.mPath = path;
            }

            @Override
            boolean accept(Package pkg) {
                ExtraPackage ep;
                if (pkg instanceof ExtraPackage && (ep = (ExtraPackage)pkg).getVendorId().equals(this.mVendor)) {
                    if (ep.getPath().equals(this.mPath)) {
                        return true;
                    }
                    for (String oldPath : ep.getOldPaths()) {
                        if (!oldPath.equals(this.mPath)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            void visit(Package pkg) {
            }

            @Override
            int installFlags() {
                return 1;
            }
        };
    }

    private PackageFilter createPlatformToolsFilter() {
        return new PackageFilter(){

            @Override
            boolean accept(Package pkg) {
                return pkg instanceof PlatformToolPackage;
            }

            @Override
            void visit(Package pkg) {
            }

            @Override
            int installFlags() {
                return 1;
            }
        };
    }

    public static PackageFilter createPlatformFilter(final int apiLevel) {
        return new PackageFilter(){
            int mApiLevel;
            boolean mFindMaxApi;
            {
                this.mApiLevel = apiLevel;
                this.mFindMaxApi = apiLevel == 0;
            }

            @Override
            boolean accept(Package pkg) {
                if (pkg instanceof PlatformPackage) {
                    PlatformPackage pp = (PlatformPackage)pkg;
                    AndroidVersion v = pp.getAndroidVersion();
                    return !v.isPreview() && v.getApiLevel() == this.mApiLevel;
                }
                return false;
            }

            @Override
            void visit(Package pkg) {
                int api;
                PlatformPackage pp;
                AndroidVersion v;
                if (this.mFindMaxApi && pkg instanceof PlatformPackage && !pkg.isLocal() && !(v = (pp = (PlatformPackage)pkg).getAndroidVersion()).isPreview() && (api = v.getApiLevel()) > this.mApiLevel) {
                    this.mApiLevel = api;
                }
            }

            @Override
            int installFlags() {
                return 1;
            }
        };
    }

    public static PackageFilter createNewSdkFilter(final Set<Integer> apiLevels) {
        return new PackageFilter(){
            int mMaxApiLevel;
            boolean mFindMaxApi;
            boolean mNeedTools;
            boolean mNeedPlatformTools;
            {
                this.mFindMaxApi = apiLevels.contains(0);
                this.mNeedTools = true;
                this.mNeedPlatformTools = true;
            }

            @Override
            boolean accept(Package pkg) {
                if (!pkg.isLocal()) {
                    if (pkg instanceof PlatformPackage) {
                        PlatformPackage pp = (PlatformPackage)pkg;
                        AndroidVersion v = pp.getAndroidVersion();
                        if (!v.isPreview()) {
                            int level = v.getApiLevel();
                            if (this.mFindMaxApi && level == this.mMaxApiLevel || level > 0 && apiLevels.contains(level)) {
                                return true;
                            }
                        }
                    } else {
                        if (this.mNeedTools && pkg instanceof ToolPackage) {
                            this.mNeedTools = false;
                            return true;
                        }
                        if (this.mNeedPlatformTools && pkg instanceof PlatformToolPackage) {
                            this.mNeedPlatformTools = false;
                            return true;
                        }
                    }
                }
                return false;
            }

            @Override
            void visit(Package pkg) {
                int api;
                PlatformPackage pp;
                AndroidVersion v;
                if (this.mFindMaxApi && pkg instanceof PlatformPackage && !pkg.isLocal() && !(v = (pp = (PlatformPackage)pkg).getAndroidVersion()).isPreview() && (api = v.getApiLevel()) > this.mMaxApiLevel) {
                    this.mMaxApiLevel = api;
                }
            }

            @Override
            int installFlags() {
                return 0;
            }
        };
    }

    private static abstract class PackageFilter {
        private PackageFilter() {
        }

        abstract int installFlags();

        abstract void visit(Package var1);

        abstract boolean accept(Package var1);
    }
}

