/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.sdklib.internal.repository.sources.SdkAddonSource;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSourceCategory;
import com.android.sdklib.internal.repository.sources.SdkSourceProperties;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.sources.SdkSysImgSource;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.UpdaterBaseDialog;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AddonSitesDialog
extends UpdaterBaseDialog {
    private final SdkSources mSources;
    private Table mUserTable;
    private TableViewer mUserTableViewer;
    private CheckboxTableViewer mSitesTableViewer;
    private Button mUserButtonNew;
    private Button mUserButtonDelete;
    private Button mUserButtonEdit;
    private Runnable mSourcesChangeListener;

    public AddonSitesDialog(Shell parent, SwtUpdaterData updaterData) {
        super(parent, updaterData, "Add-on Sites");
        this.mSources = updaterData.getSources();
        assert (this.mSources != null);
    }

    @Override
    protected void createContents() {
        super.createContents();
        Shell shell = this.getShell();
        shell.setMinimumSize(new Point(300, 300));
        shell.setSize(600, 400);
        TabFolder tabFolder = new TabFolder((Composite)shell, 0);
        GridDataBuilder.create((Control)tabFolder).fill().grab().hSpan(2);
        TabItem sitesTabItem = new TabItem(tabFolder, 0);
        sitesTabItem.setText("Official Add-on Sites");
        this.createTabOfficialSites(tabFolder, sitesTabItem);
        TabItem userTabItem = new TabItem(tabFolder, 0);
        userTabItem.setText("User Defined Sites");
        this.createTabUserSites(tabFolder, userTabItem);
        Label label = new Label((Composite)shell, 0);
        GridDataBuilder.create((Control)label).hFill().hGrab();
        this.createCloseButton();
    }

    void createTabOfficialSites(TabFolder tabFolder, TabItem sitesTabItem) {
        Composite root = new Composite((Composite)tabFolder, 0);
        sitesTabItem.setControl((Control)root);
        GridLayoutBuilder.create(root).columns(3);
        Label label = new Label(root, 0);
        GridDataBuilder.create((Control)label).hGrab().vCenter().hSpan(3);
        label.setText("This lets select which official 3rd-party sites you want to load.\n\nThese sites are managed by non-Android vendors to provide add-ons and extra packages.\nThey are by default all enabled. When you disable one, the SDK Manager will not check the site for new packages.");
        this.mSitesTableViewer = CheckboxTableViewer.newCheckList((Composite)root, (int)67584);
        this.mSitesTableViewer.setContentProvider((IContentProvider)new SourcesContentProvider());
        Table sitesTable = this.mSitesTableViewer.getTable();
        sitesTable.setToolTipText("Enable 3rd-Party Site");
        sitesTable.setLinesVisible(true);
        sitesTable.setHeaderVisible(true);
        GridDataBuilder.create((Control)sitesTable).fill().grab().hSpan(3);
        TableViewerColumn columnViewer = new TableViewerColumn((TableViewer)this.mSitesTableViewer, 0);
        TableColumn column = columnViewer.getColumn();
        column.setResizable(true);
        column.setWidth(150);
        column.setText("Name");
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SdkSource) {
                    String name = ((SdkSource)element).getUiName();
                    if (name != null) {
                        return name;
                    }
                    return ((SdkSource)element).getShortDescription();
                }
                return super.getText(element);
            }
        });
        columnViewer = new TableViewerColumn((TableViewer)this.mSitesTableViewer, 0);
        column = columnViewer.getColumn();
        column.setResizable(true);
        column.setWidth(400);
        column.setText("URL");
        columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SdkSource) {
                    return ((SdkSource)element).getUrl();
                }
                return super.getText(element);
            }
        });
        this.mSitesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AddonSitesDialog.this.on_SitesTableViewer_checkStateChanged(event);
            }
        });
        Button selectAll = new Button(root, 0);
        selectAll.setText("Enable All");
        GridDataBuilder.create((Control)selectAll).hLeft();
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddonSitesDialog.this.on_SitesTableViewer_selectAll();
            }
        });
        label = new Label(root, 0);
        GridDataBuilder.create((Control)label).hFill().hGrab();
        Button deselectAll = new Button(root, 0);
        deselectAll.setText("Disable All");
        GridDataBuilder.create((Control)deselectAll).hRight();
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddonSitesDialog.this.on_SitesTableViewer_deselectAll();
            }
        });
    }

    void createTabUserSites(TabFolder tabFolder, TabItem userTabItem) {
        Composite root = new Composite((Composite)tabFolder, 0);
        userTabItem.setControl((Control)root);
        GridLayoutBuilder.create(root).columns(2);
        Label label = new Label(root, 0);
        GridDataBuilder.create((Control)label).hLeft().vCenter().hSpan(2);
        label.setText("This lets you manage a list of user-contributed external add-on sites URLs.\n\nAdd-on sites can provide new add-ons and extra packages.\nThey cannot provide standard Android platforms, system images or docs.\nAdding a URL here will not allow you to clone an official Android repository.");
        this.mUserTableViewer = new TableViewer(root, 67584);
        this.mUserTableViewer.setContentProvider((IContentProvider)new SourcesContentProvider());
        this.mUserTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddonSitesDialog.this.on_UserTableViewer_selectionChanged(event);
            }
        });
        this.mUserTable = this.mUserTableViewer.getTable();
        this.mUserTable.setLinesVisible(true);
        this.mUserTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                AddonSitesDialog.this.on_UserTable_mouseUp(event);
            }
        });
        GridDataBuilder.create((Control)this.mUserTable).fill().grab().vSpan(5);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.mUserTableViewer, 0);
        TableColumn userColumnUrl = tableViewerColumn.getColumn();
        userColumnUrl.setWidth(100);
        this.mUserTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mUserButtonNew = new Button(root, 0);
        this.mUserButtonNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddonSitesDialog.this.userNewOrEdit(false);
            }
        });
        GridDataBuilder.create((Control)this.mUserButtonNew).hFill().vCenter();
        this.mUserButtonNew.setText("New...");
        this.mUserButtonEdit = new Button(root, 0);
        this.mUserButtonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddonSitesDialog.this.userNewOrEdit(true);
            }
        });
        GridDataBuilder.create((Control)this.mUserButtonEdit).hFill().vCenter();
        this.mUserButtonEdit.setText("Edit...");
        this.mUserButtonDelete = new Button(root, 0);
        this.mUserButtonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddonSitesDialog.this.on_UserButtonDelete_widgetSelected(e);
            }
        });
        GridDataBuilder.create((Control)this.mUserButtonDelete).hFill().vCenter();
        this.mUserButtonDelete.setText("Delete...");
        this.adjustColumnsWidth(this.mUserTable, userColumnUrl);
    }

    @Override
    protected void close() {
        if (this.mSources != null && this.mSourcesChangeListener != null) {
            this.mSources.removeChangeListener(this.mSourcesChangeListener);
        }
        SdkSourceProperties p = new SdkSourceProperties();
        p.save();
        super.close();
    }

    private void adjustColumnsWidth(final Table table, final TableColumn column0) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = table.getClientArea();
                column0.setWidth(r.width * 100 / 100);
            }
        });
    }

    private void userNewOrEdit(final boolean isEdit) {
        String url;
        String initialValue;
        final SdkSource[] knownSources = this.mSources.getAllSources();
        String title = isEdit ? "Edit Add-on Site URL" : "Add Add-on Site URL";
        String msg = "Please enter the URL of the addon.xml:";
        IStructuredSelection sel = (IStructuredSelection)this.mUserTableViewer.getSelection();
        String string = initialValue = !isEdit || sel.isEmpty() ? null : sel.getFirstElement().toString();
        if (isEdit && initialValue == null) {
            return;
        }
        InputDialog dlg = new InputDialog(this.getShell(), title, msg, initialValue, new IInputValidator(){

            public String isValid(String newText) {
                String string = newText = newText == null ? null : newText.trim();
                if (newText == null || newText.length() == 0) {
                    return "Error: URL field is empty. Please enter a URL.";
                }
                if (!(newText.startsWith("file://") || newText.startsWith("ftp://") || newText.startsWith("http://") || newText.startsWith("https://"))) {
                    return "Error: The URL must start by one of file://, ftp://, http:// or https://";
                }
                if (isEdit && newText.equals(initialValue)) {
                    return null;
                }
                for (SdkSource s : knownSources) {
                    if (!newText.equalsIgnoreCase(s.getUrl())) continue;
                    return "Error: This site is already listed.";
                }
                return null;
            }
        });
        if (dlg.open() == 0 && !(url = dlg.getValue().trim()).equals(initialValue)) {
            if (isEdit && initialValue != null) {
                for (SdkSource source : this.mSources.getSources(SdkSourceCategory.USER_ADDONS)) {
                    if (!initialValue.equals(source.getUrl())) continue;
                    this.mSources.remove(source);
                    break;
                }
            }
            Object newSource = url.endsWith("sys-img.xml") ? new SdkSysImgSource(url, null) : new SdkAddonSource(url, null);
            this.mSources.add(SdkSourceCategory.USER_ADDONS, (SdkSource)newSource);
            this.setReturnValue(true);
            this.mSources.notifyChangeListeners();
            StructuredSelection newSel = new StructuredSelection(newSource);
            this.mUserTableViewer.setSelection((ISelection)newSel, true);
        }
    }

    private void on_UserButtonDelete_widgetSelected(SelectionEvent e) {
        String selectedUrl;
        IStructuredSelection sel = (IStructuredSelection)this.mUserTableViewer.getSelection();
        String string = selectedUrl = sel.isEmpty() ? null : sel.getFirstElement().toString();
        if (selectedUrl == null) {
            return;
        }
        MessageBox mb = new MessageBox(this.getShell(), 65732);
        mb.setText("Delete add-on site");
        mb.setMessage(String.format("Do you want to delete the URL %1$s?", selectedUrl));
        if (mb.open() == 64) {
            for (SdkSource source : this.mSources.getSources(SdkSourceCategory.USER_ADDONS)) {
                if (!selectedUrl.equals(source.getUrl())) continue;
                this.mSources.remove(source);
                this.setReturnValue(true);
                this.mSources.notifyChangeListeners();
                break;
            }
        }
    }

    private void on_UserTable_mouseUp(MouseEvent event) {
        Point p = new Point(event.x, event.y);
        if (this.mUserTable.getItem(p) == null) {
            this.mUserTable.deselectAll();
            this.on_UserTableViewer_selectionChanged(null);
        }
    }

    private void on_UserTableViewer_selectionChanged(SelectionChangedEvent event) {
        ISelection sel = this.mUserTableViewer.getSelection();
        this.mUserButtonDelete.setEnabled(!sel.isEmpty());
        this.mUserButtonEdit.setEnabled(!sel.isEmpty());
    }

    private void on_SitesTableViewer_checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof SdkSource) {
            SdkSource source = (SdkSource)element;
            boolean isChecked = event.getChecked();
            if (source.isEnabled() != isChecked) {
                this.setReturnValue(true);
                source.setEnabled(isChecked);
                this.mSources.notifyChangeListeners();
            }
        }
    }

    private void on_SitesTableViewer_selectAll() {
        for (Object item : (Object[])this.mSitesTableViewer.getInput()) {
            if (this.mSitesTableViewer.getChecked(item)) continue;
            this.mSitesTableViewer.setChecked(item, true);
            this.on_SitesTableViewer_checkStateChanged(new CheckStateChangedEvent((ICheckable)this.mSitesTableViewer, item, true));
        }
    }

    private void on_SitesTableViewer_deselectAll() {
        for (Object item : (Object[])this.mSitesTableViewer.getInput()) {
            if (!this.mSitesTableViewer.getChecked(item)) continue;
            this.mSitesTableViewer.setChecked(item, false);
            this.on_SitesTableViewer_checkStateChanged(new CheckStateChangedEvent((ICheckable)this.mSitesTableViewer, item, false));
        }
    }

    @Override
    protected void postCreate() {
        final Runnable updateInUiThread = new Runnable(){

            @Override
            public void run() {
                AddonSitesDialog.this.loadUserUrlsList();
                AddonSitesDialog.this.loadSiteUrlsList();
            }
        };
        this.mSourcesChangeListener = new Runnable(){

            @Override
            public void run() {
                Display display;
                Shell shell = AddonSitesDialog.this.getShell();
                if (shell != null && (display = shell.getDisplay()) != null) {
                    display.syncExec(updateInUiThread);
                }
            }
        };
        this.mSources.addChangeListener(this.mSourcesChangeListener);
        updateInUiThread.run();
    }

    private void loadUserUrlsList() {
        Object[] knownSources = this.mSources.getSources(SdkSourceCategory.USER_ADDONS);
        Arrays.sort(knownSources);
        ISelection oldSelection = this.mUserTableViewer.getSelection();
        this.mUserTableViewer.setInput((Object)knownSources);
        this.mUserTableViewer.refresh();
        this.on_UserTableViewer_selectionChanged(null);
        if (oldSelection != null && !oldSelection.isEmpty()) {
            this.mUserTableViewer.setSelection(oldSelection, true);
        }
    }

    private void loadSiteUrlsList() {
        Object[] knownSources = this.mSources.getSources(SdkSourceCategory.ADDONS_3RD_PARTY);
        Arrays.sort(knownSources);
        ISelection oldSelection = this.mSitesTableViewer.getSelection();
        this.mSitesTableViewer.setInput((Object)knownSources);
        this.mSitesTableViewer.refresh();
        if (oldSelection != null && !oldSelection.isEmpty()) {
            this.mSitesTableViewer.setSelection(oldSelection, true);
        }
        ArrayList<Object> disabled = new ArrayList<Object>(knownSources.length);
        for (Object source : knownSources) {
            if (!source.isEnabled()) continue;
            disabled.add(source);
        }
        this.mSitesTableViewer.setCheckedElements(disabled.toArray());
    }

    private static class SourcesContentProvider
    implements IStructuredContentProvider {
        private SourcesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SdkSource[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }
    }
}

