/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.core;

import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.updater.PkgItem;
import com.android.sdklib.repository.IDescription;
import com.android.sdkuilib.internal.repository.core.PkgCategory;
import com.android.sdkuilib.internal.repository.core.PkgCategorySource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IInputProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PkgContentProvider
implements ITreeContentProvider {
    private final IInputProvider mViewer;
    private boolean mDisplayArchives;

    public PkgContentProvider(IInputProvider viewer) {
        this.mViewer = viewer;
    }

    public void setDisplayArchives(boolean displayArchives) {
        this.mDisplayArchives = displayArchives;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ArrayList) {
            return ((ArrayList)parentElement).toArray();
        }
        if (parentElement instanceof PkgCategorySource) {
            return this.getSourceChildren((PkgCategorySource)parentElement);
        }
        if (parentElement instanceof PkgCategory) {
            return ((PkgCategory)parentElement).getItems().toArray();
        }
        if (parentElement instanceof PkgItem) {
            if (this.mDisplayArchives) {
                Package pkg = ((PkgItem)parentElement).getUpdatePkg();
                if (pkg != null) {
                    return new Object[]{pkg};
                }
                return ((PkgItem)parentElement).getArchives();
            }
        } else if (parentElement instanceof Package && this.mDisplayArchives) {
            return ((Package)parentElement).getArchives();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        Object input;
        if (element instanceof PkgItem && (input = this.mViewer.getInput()) != null) {
            for (PkgCategory cat : (List)input) {
                if (!cat.getItems().contains(element)) continue;
                return cat;
            }
        }
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof ArrayList) {
            return true;
        }
        if (parentElement instanceof PkgCategory) {
            return true;
        }
        if (parentElement instanceof PkgItem) {
            if (this.mDisplayArchives) {
                Package pkg = ((PkgItem)parentElement).getUpdatePkg();
                if (pkg != null) {
                    return true;
                }
                Archive[] archives = ((PkgItem)parentElement).getArchives();
                return archives.length > 0;
            }
        } else if (parentElement instanceof Package && this.mDisplayArchives) {
            return ((Package)parentElement).getArchives().length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private Object[] getSourceChildren(PkgCategorySource parentElement) {
        List<PkgItem> children = parentElement.getItems();
        SdkSource source = parentElement.getSource();
        RepoSourceError error = null;
        RepoSourceNotification empty = null;
        String errStr = source.getFetchError();
        if (errStr != null) {
            error = new RepoSourceError(source);
        }
        if (!source.isEnabled() || children.isEmpty()) {
            empty = new RepoSourceNotification(source);
        }
        if (error != null || empty != null) {
            ArrayList<PkgItem> children2 = new ArrayList<PkgItem>();
            if (error != null) {
                children2.add((PkgItem)error);
            }
            if (empty != null) {
                children2.add((PkgItem)empty);
            }
            children2.addAll(children);
            children = children2;
        }
        return children.toArray();
    }

    public static class RepoSourceNotification
    implements IDescription {
        private final SdkSource mSource;

        public RepoSourceNotification(SdkSource source) {
            this.mSource = source;
        }

        public String getLongDescription() {
            if (this.mSource.isEnabled()) {
                return this.mSource.getLongDescription();
            }
            return "Loading from this site has been disabled. To enable it, use Tools > Manage Add-ons Sites.";
        }

        public String getShortDescription() {
            if (this.mSource.isEnabled()) {
                return "No packages found.";
            }
            return "This site is disabled. ";
        }
    }

    public static class RepoSourceError
    implements IDescription {
        private final SdkSource mSource;

        public RepoSourceError(SdkSource source) {
            this.mSource = source;
        }

        public String getLongDescription() {
            return this.mSource.getLongDescription();
        }

        public String getShortDescription() {
            return this.mSource.getFetchError();
        }
    }
}

