/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.core;

import com.android.sdklib.AndroidVersion;
import com.android.sdkuilib.internal.repository.core.PkgCategory;

public class PkgCategoryApi
extends PkgCategory {
    private String mPlatformName;
    public static final AndroidVersion KEY_TOOLS = new AndroidVersion(0x3FFFFFFF, null);
    public static final AndroidVersion KEY_TOOLS_PREVIEW = new AndroidVersion(0x3FFFFFFE, null);
    public static final AndroidVersion KEY_EXTRA = new AndroidVersion(-1, null);

    public PkgCategoryApi(AndroidVersion version, String platformName, Object iconRef) {
        super(version, null, iconRef);
        this.setPlatformName(platformName);
    }

    public String getPlatformName() {
        return this.mPlatformName;
    }

    public void setPlatformName(String platformName) {
        if (platformName != null) {
            this.mPlatformName = String.format("Android %1$s", platformName);
            super.setLabel(null);
        }
    }

    public String getApiLabel() {
        AndroidVersion key = (AndroidVersion)this.getKey();
        if (key.equals((Object)KEY_TOOLS)) {
            return "TOOLS";
        }
        if (key.equals((Object)KEY_TOOLS_PREVIEW)) {
            return "TOOLS-PREVIEW";
        }
        if (key.equals((Object)KEY_EXTRA)) {
            return "EXTRAS";
        }
        return key.toString();
    }

    @Override
    public String getLabel() {
        String label = super.getLabel();
        if (label == null) {
            AndroidVersion key = (AndroidVersion)this.getKey();
            label = key.equals((Object)KEY_TOOLS) ? "Tools" : (key.equals((Object)KEY_TOOLS_PREVIEW) ? "Tools (Preview Channel)" : (key.equals((Object)KEY_EXTRA) ? "Extras" : (this.mPlatformName != null ? String.format("%1$s (%2$s)", this.mPlatformName, this.getApiLabel()) : this.getApiLabel())));
            super.setLabel(label);
        }
        return label;
    }

    @Override
    public void setLabel(String label) {
        throw new UnsupportedOperationException("Use setPlatformName() instead.");
    }

    @Override
    public String toString() {
        return String.format("%s <API=%s, label=%s, #items=%d>", this.getClass().getSimpleName(), this.getApiLabel(), this.getLabel(), this.getItems().size());
    }
}

