/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.core;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.repository.packages.BuildToolPackage;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.IFullRevisionProvider;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PlatformPackage;
import com.android.sdklib.internal.repository.packages.PlatformToolPackage;
import com.android.sdklib.internal.repository.packages.SystemImagePackage;
import com.android.sdklib.internal.repository.packages.ToolPackage;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.updater.PkgItem;
import com.android.sdklib.repository.FullRevision;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.core.PkgCategory;
import com.android.sdkuilib.internal.repository.core.PkgCategoryApi;
import com.android.utils.Pair;
import com.android.utils.SparseArray;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackagesDiffLogic {
    private final SwtUpdaterData mUpdaterData;
    private boolean mFirstLoadComplete = true;
    private final UpdateOpApi mOpApi = new UpdateOpApi();
    private static final PkgItem.PkgState[] PKG_STATES = new PkgItem.PkgState[]{PkgItem.PkgState.INSTALLED, PkgItem.PkgState.NEW};

    public PackagesDiffLogic(SwtUpdaterData swtUpdaterData) {
        this.mUpdaterData = swtUpdaterData;
    }

    public void clear() {
        this.mFirstLoadComplete = true;
        this.mOpApi.clear();
    }

    public boolean isFirstLoadComplete() {
        boolean b = this.mFirstLoadComplete;
        this.mFirstLoadComplete = false;
        return b;
    }

    public void checkNewUpdateItems(boolean selectNew, boolean selectUpdates, boolean selectTop, int currentPlatform) {
        Package p;
        int maxApi = 0;
        HashSet<Integer> installedPlatforms = new HashSet<Integer>();
        SparseArray platformItems = new SparseArray();
        boolean hasTools = false;
        HashMap toolsCandidates = Maps.newHashMap();
        toolsCandidates.put(PlatformToolPackage.class, Pair.of((Object)null, (Object)null));
        toolsCandidates.put(BuildToolPackage.class, Pair.of((Object)null, (Object)null));
        List<PkgItem> allItems = this.getAllPkgItems();
        block0: for (PkgItem item : allItems) {
            if (!item.hasCompatibleArchive()) continue;
            int api = 0;
            p = item.getMainPackage();
            if (p instanceof IAndroidVersionProvider) {
                api = ((IAndroidVersionProvider)p).getAndroidVersion().getApiLevel();
            }
            if (selectTop && api > 0) {
                ArrayList<PkgItem> items;
                maxApi = Math.max(maxApi, api);
                if (item.getState() == PkgItem.PkgState.INSTALLED) {
                    installedPlatforms.add(api);
                }
                if ((items = (ArrayList<PkgItem>)platformItems.get(api)) == null) {
                    items = new ArrayList<PkgItem>();
                    platformItems.put(api, items);
                }
                items.add(item);
            }
            if ((selectUpdates || selectNew) && item.getState() == PkgItem.PkgState.NEW && !item.getRevision().isPreview()) {
                boolean sameFound = false;
                Package newPkg = item.getMainPackage();
                if (newPkg instanceof IFullRevisionProvider) {
                    IFullRevisionProvider newPkg2 = (IFullRevisionProvider)newPkg;
                    for (PkgItem item2 : allItems) {
                        Package installed;
                        if (item2.getState() != PkgItem.PkgState.INSTALLED || !(installed = item2.getMainPackage()).getRevision().isPreview() || !newPkg2.sameItemAs(installed, FullRevision.PreviewComparison.IGNORE)) continue;
                        sameFound = true;
                        if (installed.canBeUpdatedBy(newPkg) != Package.UpdateInfo.UPDATE) continue;
                        item.setChecked(true);
                        break;
                    }
                }
                if (selectNew && !sameFound) {
                    item.setChecked(true);
                }
            } else if (selectUpdates && item.hasUpdatePkg()) {
                item.setChecked(true);
            }
            if (!selectTop) continue;
            if (p instanceof ToolPackage && p.isLocal()) {
                hasTools = true;
                continue;
            }
            if (!(p instanceof PlatformToolPackage) && !(p instanceof BuildToolPackage)) continue;
            for (Class clazz : toolsCandidates.keySet()) {
                if (!clazz.isInstance(p)) continue;
                if (p.isLocal()) {
                    toolsCandidates.remove(clazz);
                    continue block0;
                }
                if (!toolsCandidates.containsKey(clazz)) continue block0;
                Pair val = (Pair)toolsCandidates.get(clazz);
                FullRevision rev = p.getRevision();
                if (rev.isPreview() || val.getSecond() != null && rev.compareTo((FullRevision)val.getSecond()) <= 0) continue block0;
                toolsCandidates.put(clazz, Pair.of((Object)item, (Object)rev));
                continue block0;
            }
        }
        if (selectTop && hasTools) {
            for (Pair candidate : toolsCandidates.values()) {
                PkgItem item = (PkgItem)candidate.getFirst();
                if (item == null) continue;
                item.setChecked(true);
            }
        }
        List items = (List)platformItems.get(maxApi);
        if (selectTop && maxApi > 0 && items != null) {
            if (!installedPlatforms.contains(maxApi)) {
                for (PkgItem item : items) {
                    if ((item.getState() != PkgItem.PkgState.NEW || item.getRevision().isPreview()) && !item.hasUpdatePkg()) continue;
                    item.setChecked(true);
                }
            } else {
                for (PkgItem item : items) {
                    p = item.getMainPackage();
                    if (!(p instanceof PlatformPackage) || item.getState() != PkgItem.PkgState.NEW || item.getRevision().isPreview()) continue;
                    item.setChecked(true);
                    break;
                }
                boolean hasSysImg = false;
                for (PkgItem item : items) {
                    Package p2 = item.getMainPackage();
                    if (p2 instanceof PlatformPackage && item.getState() == PkgItem.PkgState.INSTALLED) {
                        if (item.hasUpdatePkg() && item.isChecked()) {
                            p2 = item.getUpdatePkg();
                            if (p2 instanceof PlatformPackage) {
                                hasSysImg = ((PlatformPackage)p2).getIncludedAbi() != null;
                            }
                        } else {
                            boolean bl = hasSysImg = ((PlatformPackage)p2).getIncludedAbi() != null;
                        }
                        if (hasSysImg) break;
                    }
                    if (!(p2 instanceof SystemImagePackage) || !((SystemImagePackage)p2).isPlatform() || item.getState() != PkgItem.PkgState.INSTALLED) continue;
                    hasSysImg = true;
                    break;
                }
                if (!hasSysImg) {
                    for (PkgItem item : items) {
                        Package p3 = item.getMainPackage();
                        if (!(p3 instanceof PlatformPackage)) continue;
                        if (item.getState() == PkgItem.PkgState.NEW && !item.getRevision().isPreview() && ((PlatformPackage)p3).getIncludedAbi() != null) {
                            item.setChecked(true);
                            hasSysImg = true;
                            continue;
                        }
                        if (!item.hasUpdatePkg() || !((p3 = item.getUpdatePkg()) instanceof PlatformPackage) || ((PlatformPackage)p3).getIncludedAbi() == null) continue;
                        item.setChecked(true);
                        hasSysImg = true;
                    }
                }
                if (!hasSysImg) {
                    for (PkgItem item : items) {
                        Package p4 = item.getMainPackage();
                        if (!(p4 instanceof SystemImagePackage) || !((SystemImagePackage)p4).isPlatform() || item.getState() != PkgItem.PkgState.NEW) continue;
                        item.setChecked(true);
                    }
                }
            }
        }
        if (selectTop) {
            for (PkgItem item : this.getAllPkgItems()) {
                p = item.getMainPackage();
                if (!(p instanceof ExtraPackage) || item.getState() != PkgItem.PkgState.NEW || item.getRevision().isPreview()) continue;
                ExtraPackage ep = (ExtraPackage)p;
                if (currentPlatform == 2 && ep.getVendorId().equals("google") && ep.getPath().equals("usb_driver")) {
                    item.setChecked(true);
                    continue;
                }
                if (!ep.getVendorId().equals("android") || !ep.getPath().equals("support")) continue;
                item.setChecked(true);
            }
        }
    }

    public void uncheckAllItems() {
        for (PkgItem item : this.getAllPkgItems()) {
            item.setChecked(false);
        }
    }

    public List<PkgCategory> getCategories() {
        return this.mOpApi.getCategories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PkgItem> getAllPkgItems() {
        List<PkgCategory> cats;
        ArrayList<PkgItem> items = new ArrayList<PkgItem>();
        List<PkgCategory> list = cats = this.getCategories();
        synchronized (list) {
            for (PkgCategory cat : cats) {
                items.addAll(cat.getItems());
            }
        }
        return items;
    }

    public void updateStart() {
        this.mOpApi.updateStart();
    }

    public boolean updateSourcePackages(SdkSource source, Package[] newPackages) {
        return this.mOpApi.updateSourcePackages(source, newPackages);
    }

    public boolean updateEnd() {
        return this.mOpApi.updateEnd();
    }

    private boolean processLocals(UpdateOp op, Package[] packages) {
        boolean hasChanged = false;
        List<PkgCategory> cats = op.getCategories();
        HashSet<PkgItem> keep = new HashSet<PkgItem>();
        block0: for (Package localPkg : packages) {
            for (PkgCategory cat : cats) {
                for (PkgItem currItem : cat.getItems()) {
                    if (currItem.getState() != PkgItem.PkgState.INSTALLED || !currItem.isSameMainPackageAs(localPkg)) continue;
                    op.keep(currItem);
                    op.keep(cat);
                    keep.add(currItem);
                    continue block0;
                }
            }
            keep.add(this.addNewItem(op, localPkg, PkgItem.PkgState.INSTALLED));
            hasChanged = true;
        }
        for (PkgCategory cat : cats) {
            Iterator<PkgItem> itemIt = cat.getItems().iterator();
            while (itemIt.hasNext()) {
                PkgItem item = itemIt.next();
                if (item.getState() != PkgItem.PkgState.INSTALLED || keep.contains(item)) continue;
                itemIt.remove();
                hasChanged = true;
            }
        }
        if (hasChanged) {
            op.postCategoryItemsChanged();
        }
        return hasChanged;
    }

    private boolean processSource(UpdateOp op, SdkSource source, Package[] packages) {
        boolean hasChanged = false;
        List<PkgCategory> cats = op.getCategories();
        boolean enablePreviews = this.mUpdaterData.getSettingsController().getSettings().getEnablePreviews();
        block4: for (Package newPkg : packages) {
            if (!enablePreviews && newPkg.getRevision().isPreview() && !(newPkg instanceof BuildToolPackage)) continue;
            for (PkgCategory cat : cats) {
                for (PkgItem.PkgState state : PKG_STATES) {
                    Iterator<PkgItem> currItemIt = cat.getItems().iterator();
                    while (currItemIt.hasNext()) {
                        Package mainPkg;
                        PkgItem currItem = currItemIt.next();
                        if (currItem.getState() != state || !(mainPkg = currItem.getMainPackage()).sameItemAs(newPkg)) continue;
                        if (currItem.isSameMainPackageAs(newPkg)) {
                            op.keep(currItem);
                            op.keep(cat);
                            continue block4;
                        }
                        if (currItem.hasUpdatePkg() && currItem.isSameUpdatePackageAs(newPkg)) {
                            op.keep(currItem.getUpdatePkg());
                            op.keep(cat);
                            continue block4;
                        }
                        switch (currItem.getState()) {
                            case NEW: {
                                if (newPkg.getRevision().compareTo(mainPkg.getRevision()) < 0) {
                                    if (op.isKeep(currItem)) break;
                                    currItemIt.remove();
                                    this.addNewItem(op, newPkg, PkgItem.PkgState.NEW);
                                    hasChanged = true;
                                    break;
                                }
                                if (newPkg.getRevision().compareTo(mainPkg.getRevision()) <= 0) break;
                                currItemIt.remove();
                                this.addNewItem(op, newPkg, PkgItem.PkgState.NEW);
                                hasChanged = true;
                                break;
                            }
                            case INSTALLED: {
                                if (newPkg.getRevision().compareTo(mainPkg.getRevision()) <= 0 || !currItem.mergeUpdate(newPkg)) break;
                                op.keep(currItem.getUpdatePkg());
                                op.keep(cat);
                                hasChanged = true;
                            }
                        }
                        continue block4;
                    }
                }
            }
            this.addNewItem(op, newPkg, PkgItem.PkgState.NEW);
            hasChanged = true;
        }
        if (hasChanged) {
            op.postCategoryItemsChanged();
        }
        return hasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PkgItem addNewItem(UpdateOp op, Package pkg, PkgItem.PkgState state) {
        Object catKey;
        List<PkgCategory> cats = op.getCategories();
        PkgCategory cat = this.findCurrentCategory(cats, catKey = op.getCategoryKey(pkg));
        if (cat == null) {
            cat = op.createCategory(catKey);
            List<PkgCategory> list = cats;
            synchronized (list) {
                cats.add(cat);
            }
            op.sortCategoryList();
        } else {
            op.adjustCategory(cat, catKey);
        }
        PkgItem item = new PkgItem(pkg, state);
        op.keep(item);
        cat.getItems().add(item);
        op.keep(cat);
        return item;
    }

    private PkgCategory findCurrentCategory(List<PkgCategory> currentCategories, Object categoryKey) {
        for (PkgCategory cat : currentCategories) {
            if (!cat.getKey().equals(categoryKey)) continue;
            return cat;
        }
        return null;
    }

    private class UpdateOpApi
    extends UpdateOp {
        private UpdateOpApi() {
        }

        @Override
        public Object getCategoryKey(Package pkg) {
            if (pkg instanceof IAndroidVersionProvider) {
                return ((IAndroidVersionProvider)pkg).getAndroidVersion();
            }
            if (pkg instanceof ToolPackage || pkg instanceof PlatformToolPackage || pkg instanceof BuildToolPackage) {
                if (pkg.getRevision().isPreview()) {
                    return PkgCategoryApi.KEY_TOOLS_PREVIEW;
                }
                return PkgCategoryApi.KEY_TOOLS;
            }
            return PkgCategoryApi.KEY_EXTRA;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addDefaultCategories() {
            List<PkgCategory> list;
            PkgCategoryApi acat;
            boolean needTools = true;
            boolean needExtras = true;
            List<PkgCategory> cats = this.getCategories();
            for (PkgCategory cat : cats) {
                if (cat.getKey().equals(PkgCategoryApi.KEY_TOOLS)) {
                    this.keep(cat);
                    needTools = false;
                    continue;
                }
                if (!cat.getKey().equals(PkgCategoryApi.KEY_EXTRA)) continue;
                this.keep(cat);
                needExtras = false;
            }
            if (needTools) {
                acat = new PkgCategoryApi(PkgCategoryApi.KEY_TOOLS, null, (Object)PackagesDiffLogic.this.mUpdaterData.getImageFactory().getImageByName("pkgcat_other_16.png"));
                list = cats;
                synchronized (list) {
                    cats.add(acat);
                }
            }
            if (needExtras) {
                acat = new PkgCategoryApi(PkgCategoryApi.KEY_EXTRA, null, (Object)PackagesDiffLogic.this.mUpdaterData.getImageFactory().getImageByName("pkgcat_other_16.png"));
                list = cats;
                synchronized (list) {
                    cats.add(acat);
                }
            }
        }

        @Override
        public PkgCategory createCategory(Object catKey) {
            PkgCategoryApi cat = null;
            assert (catKey instanceof AndroidVersion);
            AndroidVersion key = (AndroidVersion)catKey;
            assert (!key.equals((Object)PkgCategoryApi.KEY_TOOLS) && !key.equals((Object)PkgCategoryApi.KEY_EXTRA));
            String platformName = null;
            for (IAndroidTarget target : PackagesDiffLogic.this.mUpdaterData.getSdkManager().getTargets()) {
                if (!target.isPlatform() || !key.equals((Object)target.getVersion())) continue;
                platformName = target.getVersionName();
                break;
            }
            cat = new PkgCategoryApi(key, platformName, (Object)PackagesDiffLogic.this.mUpdaterData.getImageFactory().getImageByName("pkgcat_16.png"));
            return cat;
        }

        @Override
        public void adjustCategory(PkgCategory cat, Object catKey) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sortCategoryList() {
            List<PkgCategory> list = this.getCategories();
            synchronized (list) {
                Collections.sort(this.getCategories(), new Comparator<PkgCategory>(){

                    @Override
                    public int compare(PkgCategory cat1, PkgCategory cat2) {
                        assert (cat1 instanceof PkgCategoryApi);
                        assert (cat2 instanceof PkgCategoryApi);
                        assert (cat1.getKey() instanceof AndroidVersion);
                        assert (cat2.getKey() instanceof AndroidVersion);
                        AndroidVersion v1 = (AndroidVersion)cat1.getKey();
                        AndroidVersion v2 = (AndroidVersion)cat2.getKey();
                        return v2.compareTo(v1);
                    }
                });
            }
        }

        @Override
        public void postCategoryItemsChanged() {
            block0: for (PkgCategory cat : this.getCategories()) {
                Collections.sort(cat.getItems());
                assert (cat instanceof PkgCategoryApi);
                PkgCategoryApi pac = (PkgCategoryApi)cat;
                if (pac.getPlatformName() != null) continue;
                for (PkgItem item : cat.getItems()) {
                    String platformName;
                    Package p = item.getMainPackage();
                    if (!(p instanceof PlatformPackage) || (platformName = ((PlatformPackage)p).getVersionName()) == null) continue;
                    pac.setPlatformName(platformName);
                    continue block0;
                }
            }
        }
    }

    abstract class UpdateOp {
        private final Set<SdkSource> mVisitedSources = new HashSet<SdkSource>();
        private final List<PkgCategory> mCategories = new ArrayList<PkgCategory>();
        private final Set<PkgCategory> mCatsToRemove = new HashSet<PkgCategory>();
        private final Set<PkgItem> mItemsToRemove = new HashSet<PkgItem>();
        private final Map<Package, PkgItem> mUpdatesToRemove = new HashMap<Package, PkgItem>();

        UpdateOp() {
        }

        public void clear() {
            this.mVisitedSources.clear();
            this.mCategories.clear();
        }

        public List<PkgCategory> getCategories() {
            return this.mCategories;
        }

        public abstract Object getCategoryKey(Package var1);

        public abstract void addDefaultCategories();

        public abstract PkgCategory createCategory(Object var1);

        public abstract void adjustCategory(PkgCategory var1, Object var2);

        public abstract void sortCategoryList();

        public abstract void postCategoryItemsChanged();

        public void updateStart() {
            this.mVisitedSources.clear();
            this.mCatsToRemove.clear();
            this.mItemsToRemove.clear();
            this.mUpdatesToRemove.clear();
            for (PkgCategory cat : this.mCategories) {
                this.mCatsToRemove.add(cat);
                List<PkgItem> items = cat.getItems();
                this.mItemsToRemove.addAll(items);
                for (PkgItem item : items) {
                    if (!item.hasUpdatePkg()) continue;
                    this.mUpdatesToRemove.put(item.getUpdatePkg(), item);
                }
            }
            this.addDefaultCategories();
        }

        public boolean updateSourcePackages(SdkSource source, Package[] newPackages) {
            this.mVisitedSources.add(source);
            if (source == null) {
                return PackagesDiffLogic.this.processLocals(this, newPackages);
            }
            return PackagesDiffLogic.this.processSource(this, source, newPackages);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateEnd() {
            boolean hasChanged = false;
            List<PkgCategory> list = this.mCategories;
            synchronized (list) {
                for (PkgCategory unusedCat : this.mCatsToRemove) {
                    if (!this.mCategories.remove(unusedCat)) continue;
                    hasChanged = true;
                }
            }
            for (PkgCategory cat : this.mCategories) {
                Iterator<PkgItem> itemIt = cat.getItems().iterator();
                while (itemIt.hasNext()) {
                    PkgItem item = itemIt.next();
                    if (this.mItemsToRemove.contains(item)) {
                        itemIt.remove();
                        hasChanged = true;
                        continue;
                    }
                    if (!item.hasUpdatePkg() || !this.mUpdatesToRemove.containsKey(item.getUpdatePkg())) continue;
                    item.removeUpdate();
                    hasChanged = true;
                }
            }
            this.mCatsToRemove.clear();
            this.mItemsToRemove.clear();
            this.mUpdatesToRemove.clear();
            return hasChanged;
        }

        public boolean isKeep(PkgItem item) {
            return !this.mItemsToRemove.contains(item);
        }

        public void keep(Package pkg) {
            this.mUpdatesToRemove.remove(pkg);
        }

        public void keep(PkgItem item) {
            this.mItemsToRemove.remove(item);
        }

        public void keep(PkgCategory cat) {
            this.mCatsToRemove.remove(cat);
        }

        public void dontKeep(PkgItem item) {
            this.mItemsToRemove.add(item);
        }

        public void dontKeep(PkgCategory cat) {
            this.mCatsToRemove.add(cat);
        }
    }
}

