/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.SdkConstants;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.updater.ArchiveInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.License;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.ui.GridDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

final class SdkUpdaterChooserDialog
extends GridDialog {
    private static Point sLastSize;
    private boolean mAcceptSameAllLicense;
    private boolean mInternalLicenseRadioUpdate;
    private SashForm mSashForm;
    private Composite mPackageRootComposite;
    private TreeViewer mTreeViewPackage;
    private Tree mTreePackage;
    private TreeColumn mTreeColum;
    private StyledText mPackageText;
    private Button mLicenseRadioAccept;
    private Button mLicenseRadioReject;
    private Button mLicenseRadioAcceptLicense;
    private Group mPackageTextGroup;
    private final SwtUpdaterData mSwtUpdaterData;
    private Group mTableGroup;
    private Label mErrorLabel;
    private final Collection<ArchiveInfo> mArchives;

    public SdkUpdaterChooserDialog(Shell parentShell, SwtUpdaterData swtUpdaterData, Collection<ArchiveInfo> archives) {
        super(parentShell, 3, false);
        this.mSwtUpdaterData = swtUpdaterData;
        this.mArchives = archives;
    }

    protected boolean isResizable() {
        return true;
    }

    public ArrayList<ArchiveInfo> getResult() {
        ArrayList<ArchiveInfo> ais = new ArrayList<ArchiveInfo>();
        if (this.getReturnCode() == 0) {
            for (ArchiveInfo ai : this.mArchives) {
                if (!ai.isAccepted()) continue;
                ais.add(ai);
            }
        }
        return ais;
    }

    @Override
    public void createDialogContent(Composite parent) {
        this.mSashForm = new SashForm(parent, 0);
        this.mSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.mTableGroup = new Group((Composite)this.mSashForm, 0);
        this.mTableGroup.setText("Packages");
        this.mTableGroup.setLayout((Layout)new GridLayout(1, false));
        this.mTreeViewPackage = new TreeViewer((Composite)this.mTableGroup, 2564);
        this.mTreePackage = this.mTreeViewPackage.getTree();
        this.mTreePackage.setHeaderVisible(false);
        this.mTreePackage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mTreePackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SdkUpdaterChooserDialog.this.onPackageSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SdkUpdaterChooserDialog.this.onPackageDoubleClick();
            }
        });
        this.mTreeColum = new TreeColumn(this.mTreePackage, 0);
        this.mTreeColum.setWidth(100);
        this.mTreeColum.setText("Packages");
        this.mPackageRootComposite = new Composite((Composite)this.mSashForm, 0);
        this.mPackageRootComposite.setLayout((Layout)new GridLayout(4, false));
        this.mPackageRootComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mPackageTextGroup = new Group(this.mPackageRootComposite, 0);
        this.mPackageTextGroup.setText("Package Description && License");
        this.mPackageTextGroup.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.mPackageTextGroup.setLayout((Layout)new GridLayout(1, false));
        this.mPackageText = new StyledText((Composite)this.mPackageTextGroup, 586);
        this.mPackageText.setBackground(this.getParentShell().getDisplay().getSystemColor(22));
        this.mPackageText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mLicenseRadioAccept = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAccept.setText("Accept");
        this.mLicenseRadioAccept.setToolTipText("Accept this package.");
        this.mLicenseRadioAccept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SdkUpdaterChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mLicenseRadioReject = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioReject.setText("Reject");
        this.mLicenseRadioReject.setToolTipText("Reject this package.");
        this.mLicenseRadioReject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SdkUpdaterChooserDialog.this.onLicenseRadioSelected();
            }
        });
        Link link = new Link(this.mPackageRootComposite, 0);
        link.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        String printAction = "Print";
        link.setText(String.format("<a>Copy to clipboard</a> | <a>%1$s</a>", "Print"));
        link.setToolTipText("Copies all text and license to clipboard | Print using system defaults.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if ("Print".equals(e.text)) {
                    SdkUpdaterChooserDialog.this.mPackageText.print();
                } else {
                    Point p = SdkUpdaterChooserDialog.this.mPackageText.getSelection();
                    SdkUpdaterChooserDialog.this.mPackageText.selectAll();
                    SdkUpdaterChooserDialog.this.mPackageText.copy();
                    SdkUpdaterChooserDialog.this.mPackageText.setSelection(p);
                }
            }
        });
        this.mLicenseRadioAcceptLicense = new Button(this.mPackageRootComposite, 16);
        this.mLicenseRadioAcceptLicense.setText("Accept License");
        this.mLicenseRadioAcceptLicense.setToolTipText("Accept all packages that use the same license.");
        this.mLicenseRadioAcceptLicense.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SdkUpdaterChooserDialog.this.onLicenseRadioSelected();
            }
        });
        this.mSashForm.setWeights(new int[]{200, 300});
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false, 3, 1);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.mErrorLabel = new Label(composite, 0);
        this.mErrorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label.setText("[*] Something depends on this package");
        label.setEnabled(false);
        ++layout.numColumns;
        this.createButtonsForButtonBar(composite);
        Button button = this.getButton(0);
        button.setText("Install");
        return composite;
    }

    public void create() {
        super.create();
        this.getShell().setText("Choose Packages to Install");
        this.setWindowImage();
        for (ArchiveInfo ai : this.mArchives) {
            Archive a = ai.getNewArchive();
            if (a == null) continue;
            License license = a.getParentPackage().getLicense();
            boolean hasLicense = license != null && license.getLicense() != null && license.getLicense().length() > 0;
            ai.setAccepted(!hasLicense);
        }
        this.mTreeViewPackage.setLabelProvider((IBaseLabelProvider)new NewArchivesLabelProvider());
        this.mTreeViewPackage.setContentProvider((IContentProvider)new NewArchivesContentProvider());
        this.mTreeViewPackage.setInput(this.createTreeInput(this.mArchives));
        this.mTreeViewPackage.expandAll();
        this.adjustColumnsWidth();
        this.onPackageSelected();
    }

    private void setWindowImage() {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mSwtUpdaterData != null && (imgFactory = this.mSwtUpdaterData.getImageFactory()) != null) {
            this.getShell().setImage(imgFactory.getImageByName(imageName));
        }
    }

    private void adjustColumnsWidth() {
        ControlAdapter resizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = SdkUpdaterChooserDialog.this.mTreePackage.getClientArea();
                SdkUpdaterChooserDialog.this.mTreeColum.setWidth(r.width);
            }
        };
        this.mTreePackage.addControlListener((ControlListener)resizer);
        resizer.controlResized(null);
    }

    public boolean close() {
        sLastSize = this.getShell().getSize();
        return super.close();
    }

    protected Point getInitialSize() {
        if (sLastSize != null) {
            return sLastSize;
        }
        return new Point(740, 470);
    }

    private void onPackageSelected() {
        Object item = this.getSelectedItem();
        ArchiveInfo ai = null;
        List<ArchiveInfo> list = null;
        if (item instanceof ArchiveInfo) {
            ai = (ArchiveInfo)item;
            Object p = ((NewArchivesContentProvider)this.mTreeViewPackage.getContentProvider()).getParent(ai);
            if (p instanceof LicenseEntry) {
                list = ((LicenseEntry)p).getArchives();
            }
            this.displayPackageInformation(ai);
        } else if (item instanceof LicenseEntry) {
            LicenseEntry entry = (LicenseEntry)item;
            list = entry.getArchives();
            this.displayLicenseInformation(entry);
        } else {
            this.displayEmptyInformation();
        }
        boolean bl = this.mAcceptSameAllLicense = list != null && list.size() > 0;
        if (this.mAcceptSameAllLicense) {
            assert (list != null);
            License lic0 = this.getLicense(list.get(0));
            for (ArchiveInfo ai2 : list) {
                License lic2 = this.getLicense(ai2);
                if (ai2.isAccepted() && (lic0 == lic2 || lic0.equals((Object)lic2))) continue;
                this.mAcceptSameAllLicense = false;
                break;
            }
        }
        this.displayMissingDependency(ai);
        this.updateLicenceRadios(ai);
    }

    private Object getSelectedItem() {
        Object elem;
        ISelection sel = this.mTreeViewPackage.getSelection();
        if (sel instanceof IStructuredSelection && ((elem = ((IStructuredSelection)sel).getFirstElement()) instanceof ArchiveInfo || elem instanceof LicenseEntry)) {
            return elem;
        }
        return null;
    }

    private void displayEmptyInformation() {
        this.mPackageText.setText("Please select a package or a license.");
    }

    private void displayPackageInformation(ArchiveInfo ai) {
        String text;
        ArchiveInfo[] aDeps;
        Package pNew;
        Archive aNew = ai == null ? null : ai.getNewArchive();
        Package package_ = pNew = aNew == null ? null : aNew.getParentPackage();
        if (pNew == null) {
            this.displayEmptyInformation();
            return;
        }
        assert (ai != null);
        assert (aNew != null);
        this.mPackageText.setText("");
        this.addSectionTitle("Package Description\n");
        this.addText(pNew.getLongDescription(), "\n\n");
        Archive aOld = ai.getReplaced();
        if (aOld != null) {
            AndroidVersion vNew;
            AndroidVersion vOld;
            Package pOld = aOld.getParentPackage();
            FullRevision rOld = pOld.getRevision();
            FullRevision rNew = pNew.getRevision();
            boolean showRev = true;
            if (pNew instanceof IAndroidVersionProvider && pOld instanceof IAndroidVersionProvider && !(vOld = ((IAndroidVersionProvider)pOld).getAndroidVersion()).equals((Object)(vNew = ((IAndroidVersionProvider)pNew).getAndroidVersion()))) {
                this.addText(String.format("This update will replace API %1$s revision %2$s with API %3$s revision %4$s.\n\n", vOld.getApiString(), rOld.toShortString(), vNew.getApiString(), rNew.toShortString()));
                showRev = false;
            }
            if (showRev) {
                this.addText(String.format("This update will replace revision %1$s with revision %2$s.\n\n", rOld.toShortString(), rNew.toShortString()));
            }
        }
        if ((aDeps = ai.getDependsOn()) != null && aDeps.length > 0 || ai.isDependencyFor()) {
            this.addSectionTitle("Dependencies\n");
            if (aDeps != null && aDeps.length > 0) {
                this.addText("Installing this package also requires installing:");
                for (ArchiveInfo aDep : aDeps) {
                    this.addText(String.format("\n- %1$s", aDep.getShortDescription()));
                }
                this.addText("\n\n");
            }
            if (ai.isDependencyFor()) {
                this.addText("This package is a dependency for:");
                for (ArchiveInfo ai2 : ai.getDependenciesFor()) {
                    this.addText(String.format("\n- %1$s", ai2.getShortDescription()));
                }
                this.addText("\n\n");
            }
        }
        this.addSectionTitle("Archive Description\n");
        this.addText(aNew.getLongDescription(), "\n\n");
        License license = pNew.getLicense();
        if (license != null && (text = license.getLicense()) != null) {
            this.addSectionTitle("License\n");
            this.addText(text.trim(), "\n\n");
        }
        this.addSectionTitle("Site\n");
        SdkSource source = pNew.getParentSource();
        if (source != null) {
            this.addText(source.getShortDescription());
        }
    }

    private void displayLicenseInformation(LicenseEntry entry) {
        String text;
        List<ArchiveInfo> archives;
        List<ArchiveInfo> list = archives = entry == null ? null : entry.getArchives();
        if (archives == null) {
            this.displayEmptyInformation();
            return;
        }
        assert (entry != null);
        this.mPackageText.setText("");
        License license = null;
        this.addSectionTitle("Packages\n");
        for (ArchiveInfo ai : entry.getArchives()) {
            Package pNew;
            Archive aNew = ai.getNewArchive();
            if (aNew == null || (pNew = aNew.getParentPackage()) == null) continue;
            if (license == null) {
                license = pNew.getLicense();
            } else assert (license.equals((Object)pNew.getLicense()));
            this.addText("- ", pNew.getShortDescription(), "\n");
        }
        if (license != null && (text = license.getLicense()) != null) {
            this.addSectionTitle("\nLicense\n");
            this.addText(text.trim(), "\n\n");
        }
    }

    /*
     * Exception decompiling
     */
    private void displayMissingDependency(ArchiveInfo ai) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[FORLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addText(String ... string) {
        for (String s : string) {
            this.mPackageText.append(s);
        }
    }

    private void addSectionTitle(String string) {
        String s = this.mPackageText.getText();
        int start = s == null ? 0 : s.length();
        this.mPackageText.append(string);
        StyleRange sr = new StyleRange();
        sr.start = start;
        sr.length = string.length();
        sr.fontStyle = 1;
        sr.underline = true;
        this.mPackageText.setStyleRange(sr);
    }

    private void updateLicenceRadios(ArchiveInfo ai) {
        boolean missing;
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        boolean oneAccepted = false;
        this.mLicenseRadioAcceptLicense.setSelection(this.mAcceptSameAllLicense);
        oneAccepted = ai != null && ai.isAccepted();
        this.mLicenseRadioAccept.setEnabled(ai != null);
        this.mLicenseRadioReject.setEnabled(ai != null);
        this.mLicenseRadioAccept.setSelection(oneAccepted);
        this.mLicenseRadioReject.setSelection(ai != null && ai.isRejected());
        boolean bl = missing = this.mErrorLabel.getText() != null && this.mErrorLabel.getText().length() > 0;
        if (!missing && !oneAccepted) {
            for (ArchiveInfo ai2 : this.mArchives) {
                if (!ai2.isAccepted()) continue;
                oneAccepted = true;
                break;
            }
        }
        this.getButton(0).setEnabled(!missing && oneAccepted);
        this.mInternalLicenseRadioUpdate = false;
    }

    private void onLicenseRadioSelected() {
        if (this.mInternalLicenseRadioUpdate) {
            return;
        }
        this.mInternalLicenseRadioUpdate = true;
        Object item = this.getSelectedItem();
        ArchiveInfo ai = item instanceof ArchiveInfo ? (ArchiveInfo)item : null;
        boolean needUpdate = true;
        if (!this.mAcceptSameAllLicense && this.mLicenseRadioAcceptLicense.getSelection()) {
            Object p;
            List<ArchiveInfo> list = null;
            if (item instanceof LicenseEntry) {
                list = ((LicenseEntry)item).getArchives();
            } else if (ai != null && (p = ((NewArchivesContentProvider)this.mTreeViewPackage.getContentProvider()).getParent(ai)) instanceof LicenseEntry) {
                list = ((LicenseEntry)p).getArchives();
            }
            if (list != null && list.size() > 0) {
                this.mAcceptSameAllLicense = true;
                for (ArchiveInfo ai2 : list) {
                    ai2.setAccepted(true);
                    ai2.setRejected(false);
                }
            }
        } else if (ai != null && this.mLicenseRadioAccept.getSelection()) {
            this.mAcceptSameAllLicense = false;
            ai.setAccepted(true);
            ai.setRejected(false);
        } else if (ai != null && this.mLicenseRadioReject.getSelection()) {
            this.mAcceptSameAllLicense = false;
            ai.setAccepted(false);
            ai.setRejected(true);
        } else {
            needUpdate = false;
        }
        this.mInternalLicenseRadioUpdate = false;
        if (needUpdate) {
            if (this.mAcceptSameAllLicense) {
                this.mTreeViewPackage.refresh();
            } else {
                this.mTreeViewPackage.refresh((Object)ai);
                this.mTreeViewPackage.refresh(((NewArchivesContentProvider)this.mTreeViewPackage.getContentProvider()).getParent(ai));
            }
            this.displayMissingDependency(ai);
            this.updateLicenceRadios(ai);
        }
    }

    private void onPackageDoubleClick() {
        Object item = this.getSelectedItem();
        if (item instanceof ArchiveInfo) {
            ArchiveInfo ai;
            boolean wasAccepted = (ai = (ArchiveInfo)item).isAccepted();
            ai.setAccepted(!wasAccepted);
            ai.setRejected(wasAccepted);
            this.mAcceptSameAllLicense = false;
            this.mTreeViewPackage.refresh((Object)ai);
            this.mTreeViewPackage.refresh(((NewArchivesContentProvider)this.mTreeViewPackage.getContentProvider()).getParent(ai));
            this.displayMissingDependency(ai);
            this.updateLicenceRadios(ai);
        } else if (item instanceof LicenseEntry) {
            this.mTreeViewPackage.setExpandedState(item, !this.mTreeViewPackage.getExpandedState(item));
        }
    }

    private List<LicenseEntry> createTreeInput(Collection<ArchiveInfo> archives) {
        String noLicense = "No license";
        Comparator<String> comp = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                boolean first1 = "No license".equals(s1);
                boolean first2 = "No license".equals(s2);
                if (first1 && first2) {
                    return 0;
                }
                if (first1) {
                    return -1;
                }
                if (first2) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        };
        TreeMap<String, ArrayList<ArchiveInfo>> map = new TreeMap<String, ArrayList<ArchiveInfo>>(comp);
        for (ArchiveInfo info : archives) {
            ArrayList<ArchiveInfo> list;
            String ref = "No license";
            License license = this.getLicense(info);
            if (license != null && license.getLicenseRef() != null) {
                ref = this.prettyLicenseRef(license.getLicenseRef());
            }
            if ((list = (ArrayList<ArchiveInfo>)map.get(ref)) == null) {
                list = new ArrayList<ArchiveInfo>();
                map.put(ref, list);
            }
            list.add(info);
        }
        ArrayList<LicenseEntry> licensesList = new ArrayList<LicenseEntry>();
        for (Map.Entry entry : map.entrySet()) {
            licensesList.add(new LicenseEntry(licensesList, (String)entry.getKey(), (List)entry.getValue()));
        }
        return licensesList;
    }

    private License getLicense(ArchiveInfo ai) {
        Package pNew;
        Archive aNew;
        if (ai != null && (aNew = ai.getNewArchive()) != null && (pNew = aNew.getParentPackage()) != null) {
            return pNew.getLicense();
        }
        return null;
    }

    private String prettyLicenseRef(String ref) {
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        for (char c : ref.toCharArray()) {
            if (c >= 'a' && c <= 'z') {
                if (capitalize) {
                    c = (char)(c + 65 - 97);
                    capitalize = false;
                }
            } else {
                if (c == '-') {
                    c = ' ';
                }
                capitalize = true;
            }
            sb.append(c);
        }
        ref = sb.toString();
        for (String w : new String[]{"Sdk", "Mips", "Arm"}) {
            ref = ref.replaceAll(w, w.toUpperCase(Locale.US));
        }
        return ref;
    }

    private static class LicenseEntry {
        private final List<LicenseEntry> mRoot;
        private final String mLicenseRef;
        private final List<ArchiveInfo> mArchives;

        public LicenseEntry(List<LicenseEntry> root, String licenseRef, List<ArchiveInfo> archives) {
            this.mRoot = root;
            this.mLicenseRef = licenseRef;
            this.mArchives = archives;
        }

        public List<LicenseEntry> getRoot() {
            return this.mRoot;
        }

        public String getLicenseRef() {
            return this.mLicenseRef;
        }

        public List<ArchiveInfo> getArchives() {
            return this.mArchives;
        }
    }

    private class NewArchivesContentProvider
    implements ITreeContentProvider {
        private List<LicenseEntry> mInput;

        private NewArchivesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mInput = newInput instanceof List && ((List)newInput).size() > 0 && ((List)newInput).get(0) instanceof LicenseEntry ? (List)newInput : null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof List) {
                return true;
            }
            if (parent instanceof LicenseEntry) {
                return ((LicenseEntry)parent).getArchives().size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof List) {
                return ((List)parent).toArray();
            }
            if (parent instanceof LicenseEntry) {
                return ((LicenseEntry)parent).getArchives().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof LicenseEntry) {
                return ((LicenseEntry)child).getRoot();
            }
            if (child instanceof ArchiveInfo && this.mInput != null) {
                for (LicenseEntry entry : this.mInput) {
                    if (!entry.getArchives().contains(child)) continue;
                    return entry;
                }
            }
            return null;
        }
    }

    private class NewArchivesLabelProvider
    extends LabelProvider {
        private NewArchivesLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageFactory imgFactory;
            if (element instanceof ArchiveInfo) {
                ArchiveInfo ai = (ArchiveInfo)element;
                ImageFactory imgFactory2 = SdkUpdaterChooserDialog.this.mSwtUpdaterData.getImageFactory();
                if (imgFactory2 != null) {
                    if (ai.isAccepted()) {
                        return imgFactory2.getImageByName("accept_icon16.png");
                    }
                    if (ai.isRejected()) {
                        return imgFactory2.getImageByName("reject_icon16.png");
                    }
                    return imgFactory2.getImageByName("unknown_icon16.png");
                }
                return super.getImage(element);
            }
            if (element instanceof LicenseEntry && (imgFactory = SdkUpdaterChooserDialog.this.mSwtUpdaterData.getImageFactory()) != null) {
                boolean allAccepted = true;
                boolean allRejected = true;
                for (ArchiveInfo ai : ((LicenseEntry)element).getArchives()) {
                    allAccepted = allAccepted && ai.isAccepted();
                    allRejected = allRejected && ai.isRejected();
                }
                if (allAccepted && !allRejected) {
                    return imgFactory.getImageByName("accept_icon16.png");
                }
                if (!allAccepted && allRejected) {
                    return imgFactory.getImageByName("reject_icon16.png");
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof LicenseEntry) {
                return ((LicenseEntry)element).getLicenseRef();
            }
            if (element instanceof ArchiveInfo) {
                ArchiveInfo ai = (ArchiveInfo)element;
                String desc = ai.getShortDescription();
                if (ai.isDependencyFor()) {
                    desc = desc + " [*]";
                }
                return desc;
            }
            assert (element instanceof String || element instanceof ArchiveInfo);
            return null;
        }
    }
}

