/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkstats;

import java.io.IOException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class SdkStatsPermissionDialog
extends Dialog {
    private static final String HEADER_TEXT = "Thanks for using the Android SDK!";
    public static final String NOTICE_TEXT = "We know you just want to get started but please read this first.";
    public static final String BODY_TEXT = "By choosing to send certain usage statistics to Google, you can help us improve the Android SDK. These usage statistics lets us measure things like active usage of the SDK, and let us know things like which versions of the SDK are in use and which tools are the most popular with developers. This limited data is not associated with personal information about you, and is examined on an aggregate basis, and is maintained in accordance with the Google Privacy Policy.";
    public static final String PRIVACY_POLICY_LINK_TEXT = "<a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>";
    public static final String CHECKBOX_TEXT = "Send usage statistics to Google.";
    public static final String FOOTER_TEXT = "If you later decide to change this setting, you can do so in the \"ddms\" tool under \"File\" > \"Preferences\" > \"Usage Stats\".";
    private static final String BUTTON_TEXT = "Proceed";
    private static final String[] LINUX_BROWSERS = new String[]{"firefox -remote openurl(%URL%,new-window)", "mozilla -remote openurl(%URL%,new-window)", "firefox %URL%", "mozilla %URL%", "kfmclient openURL %URL%", "opera -newwindow %URL%"};
    private static final boolean ALLOW_PING_DEFAULT = true;
    private boolean mAllowPing = true;

    public SdkStatsPermissionDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, BUTTON_TEXT, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label title = new Label(composite, 0x1000040);
        FontData[] fontdata = title.getFont().getFontData();
        for (int i = 0; i < fontdata.length; ++i) {
            fontdata[i].setHeight(fontdata[i].getHeight() * 4 / 3);
        }
        title.setFont(new Font((Device)this.getShell().getDisplay(), fontdata));
        title.setLayoutData((Object)new GridData(768));
        title.setText(HEADER_TEXT);
        Label notice = new Label(composite, 64);
        notice.setFont(title.getFont());
        notice.setForeground(new Color((Device)this.getShell().getDisplay(), 255, 0, 0));
        notice.setLayoutData((Object)new GridData(768));
        notice.setText(NOTICE_TEXT);
        notice.pack();
        Label bodyText = new Label(composite, 64);
        GridData gd = new GridData();
        gd.widthHint = notice.getSize().x;
        gd.grabExcessHorizontalSpace = true;
        bodyText.setLayoutData((Object)gd);
        bodyText.setText(BODY_TEXT);
        Link privacyLink = new Link(composite, 524288);
        privacyLink.setText(PRIVACY_POLICY_LINK_TEXT);
        privacyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SdkStatsPermissionDialog.openUrl(event.text);
            }
        });
        final Button checkbox = new Button(composite, 32);
        checkbox.setSelection(true);
        checkbox.setText(CHECKBOX_TEXT);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SdkStatsPermissionDialog.this.mAllowPing = checkbox.getSelection();
            }
        });
        checkbox.setFocus();
        Label footer = new Label(composite, 64);
        gd = new GridData();
        gd.widthHint = notice.getSize().x;
        gd.grabExcessHorizontalSpace = true;
        footer.setLayoutData((Object)gd);
        footer.setText(FOOTER_TEXT);
        return composite;
    }

    public static void openUrl(final String url) {
        if (!Program.launch((String)url)) {
            new Thread(){

                @Override
                public void run() {
                    for (String cmd : LINUX_BROWSERS) {
                        cmd = cmd.replaceAll("%URL%", url);
                        try {
                            Process proc = Runtime.getRuntime().exec(cmd);
                            if (proc.waitFor() != 0) continue;
                            break;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }.start();
        }
    }

    public boolean getPingUserPreference() {
        return this.mAllowPing;
    }
}

