/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkstats;

import com.android.prefs.AndroidLocation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.eclipse.jface.preference.PreferenceStore;

public class DdmsPreferenceStore {
    public static final String PING_OPT_IN = "pingOptIn";
    private static final String PING_TIME = "pingTime";
    private static final String PING_ID = "pingId";
    private static final String ADT_USED = "adtUsed";
    private static final String LAST_SDK_PATH = "lastSdkPath";
    private static volatile PreferenceStore sPrefStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreferenceStore getPreferenceStore() {
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            if (sPrefStore == null) {
                String homeDir = null;
                try {
                    homeDir = AndroidLocation.getFolder();
                }
                catch (AndroidLocation.AndroidLocationException e1) {
                    // empty catch block
                }
                if (homeDir == null) {
                    sPrefStore = new PreferenceStore();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return sPrefStore;
                }
                assert (homeDir != null);
                String rcFileName = homeDir + "ddms.cfg";
                String oldPrefPath = System.getProperty("user.home") + File.separator + ".ddmsrc";
                File oldPrefFile = new File(oldPrefPath);
                if (oldPrefFile.isFile()) {
                    FileOutputStream fileOutputStream = null;
                    try {
                        PreferenceStore oldStore = new PreferenceStore(oldPrefPath);
                        oldStore.load();
                        fileOutputStream = new FileOutputStream(rcFileName);
                        oldStore.save((OutputStream)fileOutputStream, "");
                        oldPrefFile.delete();
                        PreferenceStore newStore = new PreferenceStore(rcFileName);
                        newStore.load();
                        sPrefStore = newStore;
                    }
                    catch (IOException e) {
                        sPrefStore = new PreferenceStore(rcFileName);
                    }
                    finally {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                } else {
                    sPrefStore = new PreferenceStore(rcFileName);
                    try {
                        sPrefStore.load();
                    }
                    catch (IOException e) {
                        System.err.println("Error Loading DDMS Preferences");
                    }
                }
            }
            assert (sPrefStore != null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sPrefStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            try {
                prefs.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPingId() {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return prefs != null && prefs.contains(PING_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPingId() {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return prefs == null ? 0L : prefs.getLong(PING_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateNewPingId() {
        PreferenceStore prefs = this.getPreferenceStore();
        Random rnd = new Random();
        long id = rnd.nextLong();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            prefs.setValue(PING_ID, id);
            try {
                prefs.save();
            }
            catch (IOException e) {
                // empty catch block
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPingOptIn() {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return prefs != null && prefs.contains(PING_OPT_IN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPingOptIn(boolean optIn) {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            prefs.setValue(PING_OPT_IN, optIn);
            try {
                prefs.save();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPingTime(String app) {
        PreferenceStore prefs = this.getPreferenceStore();
        String timePref = "pingTime." + app;
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return prefs == null ? 0L : prefs.getLong(timePref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPingTime(String app, long timeStamp) {
        PreferenceStore prefs = this.getPreferenceStore();
        String timePref = "pingTime." + app;
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            prefs.setValue(timePref, timeStamp);
            try {
                prefs.save();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdtUsed() {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            if (prefs == null || !prefs.contains(ADT_USED)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return prefs.getBoolean(ADT_USED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdtUsed(boolean used) {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            prefs.setValue(ADT_USED, used);
            try {
                prefs.save();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastSdkPath() {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return prefs == null ? null : prefs.getString(LAST_SDK_PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSdkPath(String osSdkPath) {
        PreferenceStore prefs = this.getPreferenceStore();
        Class<DdmsPreferenceStore> clazz = DdmsPreferenceStore.class;
        synchronized (DdmsPreferenceStore.class) {
            prefs.setValue(LAST_SDK_PATH, osSdkPath);
            try {
                prefs.save();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
    }
}

