/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;

public class CaseBreakQuickFixBreak
extends AbstractAstRewriteQuickFix {
    public boolean isApplicable(IMarker marker) {
        int line = marker.getAttribute("lineNumber", 0) - 1;
        return line >= 0;
    }

    public String getLabel() {
        return QuickFixMessages.CaseBreakQuickFixBreak_Label;
    }

    protected IASTStatement getStmtBeforeBreak(IMarker marker, IASTTranslationUnit ast) throws BadLocationException {
        int line = marker.getAttribute("lineNumber", 0) - 1;
        if (line < 0) {
            return null;
        }
        IRegion lineInformation = this.getDocument().getLineInformation(line);
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTNode containedNode = nodeSelector.findFirstContainedNode(lineInformation.getOffset(), lineInformation.getLength());
        Object beforeBreakNode = null;
        beforeBreakNode = containedNode != null ? CxxAstUtils.getEnclosingStatement((IASTNode)containedNode) : nodeSelector.findEnclosingNode(lineInformation.getOffset(), lineInformation.getLength());
        if (beforeBreakNode instanceof IASTCompoundStatement) {
            while (beforeBreakNode != null) {
                if (beforeBreakNode.getParent() instanceof IASTCompoundStatement && beforeBreakNode.getParent().getParent() instanceof IASTSwitchStatement) {
                    return beforeBreakNode;
                }
                beforeBreakNode = beforeBreakNode.getParent();
            }
        }
        if (beforeBreakNode instanceof IASTStatement) {
            return beforeBreakNode;
        }
        return null;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        try {
            IASTTranslationUnit ast = this.getTranslationUnitViaEditor(marker).getAST(index, 2);
            IASTStatement beforeBreak = this.getStmtBeforeBreak(marker, ast);
            if (beforeBreak != null && beforeBreak.getParent() instanceof IASTCompoundStatement) {
                IASTStatement after;
                IASTCompoundStatement enclosingStatement;
                if (beforeBreak instanceof IASTCompoundStatement) {
                    enclosingStatement = (IASTCompoundStatement)beforeBreak;
                    after = null;
                } else {
                    enclosingStatement = (IASTCompoundStatement)beforeBreak.getParent();
                    after = this.getStatementAfter(beforeBreak);
                }
                ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)enclosingStatement.getTranslationUnit());
                IASTBreakStatement breakStatement = ast.getASTNodeFactory().newBreakStatement();
                r.insertBefore((IASTNode)enclosingStatement, (IASTNode)after, (IASTNode)breakStatement, null);
                Change c = r.rewriteAST();
                c.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
        catch (BadLocationException e) {
            CheckersUiActivator.log(e);
        }
    }

    private IASTStatement getStatementAfter(IASTStatement beforeBreak) {
        IASTCompoundStatement enclosingStatement = (IASTCompoundStatement)beforeBreak.getParent();
        IASTStatement after = null;
        IASTStatement[] statements = enclosingStatement.getStatements();
        int i = 0;
        while (i < statements.length) {
            IASTStatement st = statements[i];
            if (st == beforeBreak && i < statements.length - 1) {
                after = statements[i + 1];
                break;
            }
            ++i;
        }
        return after;
    }
}

