/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.DominatorsSummary;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.IPathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ISnapshot {
    public SnapshotInfo getSnapshotInfo();

    public int[] getGCRoots() throws SnapshotException;

    public Collection<IClass> getClasses() throws SnapshotException;

    public Collection<IClass> getClassesByName(String var1, boolean var2) throws SnapshotException;

    public Collection<IClass> getClassesByName(Pattern var1, boolean var2) throws SnapshotException;

    public Histogram getHistogram(IProgressListener var1) throws SnapshotException;

    public Histogram getHistogram(int[] var1, IProgressListener var2) throws SnapshotException;

    public int[] getInboundRefererIds(int var1) throws SnapshotException;

    public int[] getOutboundReferentIds(int var1) throws SnapshotException;

    public int[] getInboundRefererIds(int[] var1, IProgressListener var2) throws SnapshotException;

    public int[] getOutboundReferentIds(int[] var1, IProgressListener var2) throws SnapshotException;

    public IPathsFromGCRootsComputer getPathsFromGCRoots(int var1, Map<IClass, Set<String>> var2) throws SnapshotException;

    public IMultiplePathsFromGCRootsComputer getMultiplePathsFromGCRoots(int[] var1, Map<IClass, Set<String>> var2) throws SnapshotException;

    public int[] getRetainedSet(int[] var1, IProgressListener var2) throws SnapshotException;

    public int[] getRetainedSet(int[] var1, String[] var2, IProgressListener var3) throws SnapshotException;

    public int[] getRetainedSet(int[] var1, ExcludedReferencesDescriptor[] var2, IProgressListener var3) throws SnapshotException;

    public int[] getMinRetainedSet(int[] var1, IProgressListener var2) throws SnapshotException;

    public long getMinRetainedSize(int[] var1, IProgressListener var2) throws SnapshotException;

    public int[] getImmediateDominatedIds(int var1) throws SnapshotException;

    public int getImmediateDominatorId(int var1) throws SnapshotException;

    public DominatorsSummary getDominatorsOf(int[] var1, Pattern var2, IProgressListener var3) throws SnapshotException;

    public int[] getTopAncestorsInDominatorTree(int[] var1, IProgressListener var2) throws SnapshotException;

    public IObject getObject(int var1) throws SnapshotException;

    public GCRootInfo[] getGCRootInfo(int var1) throws SnapshotException;

    public IClass getClassOf(int var1) throws SnapshotException;

    public long getHeapSize(int var1) throws SnapshotException;

    public long getHeapSize(int[] var1) throws SnapshotException;

    public long getRetainedHeapSize(int var1) throws SnapshotException;

    public boolean isClass(int var1);

    public boolean isClassLoader(int var1);

    public boolean isArray(int var1);

    public boolean isGCRoot(int var1);

    public long mapIdToAddress(int var1) throws SnapshotException;

    public int mapAddressToId(long var1) throws SnapshotException;

    public void dispose();

    public <A> A getSnapshotAddons(Class<A> var1) throws SnapshotException;

    public IThreadStack getThreadStack(int var1) throws SnapshotException;
}

