/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="collections_grouped_by_size")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
public class CollectionsBySizeQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        FieldSizeArrayCollectionExtractor specificExtractor;
        listener.subTask(Messages.CollectionsBySizeQuery_CollectingSizes);
        if (this.size_attribute != null && this.collection != null) {
            specificExtractor = new FieldSizeArrayCollectionExtractor(this.size_attribute, this.collection);
        } else if (this.size_attribute == null && this.collection == null) {
            specificExtractor = null;
        } else {
            throw new IllegalArgumentException("need both or none of size and array attributes");
        }
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column(Messages.CollectionsBySizeQuery_Column_Length, Integer.TYPE)});
        builder.column(Messages.CollectionsBySizeQuery_Column_NumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        this.runQuantizer(listener, quantize, specificExtractor, this.collection);
        return quantize.getResult();
    }

    private void runQuantizer(IProgressListener listener, Quantize quantize, ICollectionExtractor specificExtractor, String specificClass) throws SnapshotException {
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                IObject obj = this.snapshot.getObject(objectId);
                try {
                    Integer size;
                    AbstractExtractedCollection<?, ?> coll = CollectionExtractionUtils.extractCollection(obj, specificClass, specificExtractor);
                    if (coll != null && coll.hasSize() && (size = coll.size()) != null) {
                        quantize.addValue(objectId, new Object[]{size, null, coll.getUsedHeapSize()});
                    }
                }
                catch (RuntimeException e) {
                    listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.CollectionsBySizeQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                }
                if (listener.isCanceled()) {
                    return;
                }
                ++n2;
            }
        }
    }
}

