/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import org.eclipse.recommenders.utils.Checks;

@Beta
public class Recommendation<T> {
    private final T proposal;
    private final double relevance;

    public static <S, T extends S> Recommendation<S> newRecommendation(T proposal, double relevance) {
        return new Recommendation<T>(Checks.ensureIsNotNull(proposal, "proposal cannot be null", new Object[0]), Checks.ensureIsInRange(relevance, 0.0, 1.0, "relevance '%f' must be in range [0..1]", relevance));
    }

    protected Recommendation(T proposal, double relevance) {
        this.proposal = proposal;
        this.relevance = relevance;
    }

    public T getProposal() {
        return this.proposal;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("proposal", this.proposal).add("probability", (Object)String.format("%.4f", this.relevance)).toString();
    }
}

