/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Joiner;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.recommenders.internal.models.rcp.Dialogs;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ModelsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ModelRepositoryListEditor repoEditor;

    public ModelsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.models.rcp"));
        this.setMessage(Messages.PREFPAGE_TITLE_MODEL_REPOSITORIES);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_MODEL_REPOSITORIES);
    }

    protected void createFieldEditors() {
        this.repoEditor = new ModelRepositoryListEditor("repository.url.list", Messages.FIELD_LABEL_REPOSITORY_URIS, this.getFieldEditorParent());
        this.addField((FieldEditor)this.repoEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("repository.auto.download", Messages.FIELD_LABEL_ENABLE_AUTO_DOWNLOAD, this.getFieldEditorParent()));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        String repositoryURLList = Joiner.on((String)"\t").join((Object[])this.repoEditor.getItems());
        store.setValue("repository.url.list", repositoryURLList);
        return super.performOk();
    }

    private static final class ModelRepositoryListEditor
    extends ListEditor {
        private final Map<String, String> toUnobfuscatedUrls = new HashMap<String, String>();

        private ModelRepositoryListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        public String[] getItems() {
            return super.getList().getItems();
        }

        protected String getNewInputObject() {
            InputDialog inputDialog = Dialogs.newModelRepositoryUrlDialog(this.getShell(), this.getItems());
            if (inputDialog.open() == 0) {
                String unobfuscatedUrl = inputDialog.getValue();
                String obfuscatedUrl = Urls.toStringWithMaskedPassword((URL)Urls.toUrl((String)unobfuscatedUrl), (char)'*');
                this.toUnobfuscatedUrls.put(obfuscatedUrl, unobfuscatedUrl);
                return obfuscatedUrl;
            }
            return null;
        }

        protected String[] parseString(String string) {
            String[] unobfuscatedUrls = ModelsRcpPreferences.splitRemoteRepositoryString(string);
            String[] list = new String[unobfuscatedUrls.length];
            int i = 0;
            while (i < unobfuscatedUrls.length) {
                list[i] = Urls.toStringWithMaskedPassword((URL)Urls.toUrl((String)unobfuscatedUrls[i]), (char)'*');
                this.toUnobfuscatedUrls.put(list[i], unobfuscatedUrls[i]);
                ++i;
            }
            return list;
        }

        protected String createList(String[] items) {
            String[] unobfuscated = new String[items.length];
            int i = 0;
            while (i < items.length) {
                unobfuscated[i] = this.toUnobfuscatedUrls.get(items[i]);
                ++i;
            }
            return ModelsRcpPreferences.joinRemoteRepositoriesToString(unobfuscated);
        }
    }
}

