/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IResource;

public class SuspiciousSemicolonChecker
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.SuspiciousSemicolonProblem";
    public static final String PARAM_ELSE = "else";
    public static final String PARAM_ALFTER_ELSE = "afterelse";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitStatements = true;
            }

            public int visit(IASTStatement statement) {
                if (statement instanceof IASTIfStatement) {
                    IASTStatement thenStmt = ((IASTIfStatement)statement).getThenClause();
                    IASTStatement elseStmt = ((IASTIfStatement)statement).getElseClause();
                    if (elseStmt instanceof IASTNullStatement && SuspiciousSemicolonChecker.this.doReportAfterElse() && !SuspiciousSemicolonChecker.macroInvolved(elseStmt)) {
                        SuspiciousSemicolonChecker.this.reportProblem(SuspiciousSemicolonChecker.ER_ID, (IASTNode)elseStmt, new Object[0]);
                    }
                    if (elseStmt != null && SuspiciousSemicolonChecker.this.doNotReportIfElse()) {
                        return 3;
                    }
                    if (thenStmt instanceof IASTNullStatement && !SuspiciousSemicolonChecker.macroInvolved(thenStmt)) {
                        SuspiciousSemicolonChecker.this.reportProblem(SuspiciousSemicolonChecker.ER_ID, (IASTNode)thenStmt, new Object[0]);
                    }
                }
                return 3;
            }
        });
    }

    private boolean doNotReportIfElse() {
        IProblem pt = this.getProblemById(ER_ID, (IResource)this.getFile());
        return (Boolean)this.getPreference(pt, PARAM_ELSE);
    }

    private boolean doReportAfterElse() {
        IProblem pt = this.getProblemById(ER_ID, (IResource)this.getFile());
        return (Boolean)this.getPreference(pt, PARAM_ALFTER_ELSE);
    }

    private static boolean macroInvolved(IASTStatement node) {
        IASTFileLocation fileLocation;
        if (SuspiciousSemicolonChecker.includesMacroExpansion((IASTNode)node)) {
            return true;
        }
        IASTNodeSelector nodeSelector = node.getTranslationUnit().getNodeSelector(node.getTranslationUnit().getFilePath());
        IASTPreprocessorMacroExpansion macro = nodeSelector.findEnclosingMacroExpansion((fileLocation = node.getFileLocation()).getNodeOffset() - 1, 1);
        return macro != null;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_ELSE, CheckersMessages.SuspiciousSemicolonChecker_ParamElse, Boolean.FALSE);
        this.addPreference(problem, PARAM_ALFTER_ELSE, CheckersMessages.SuspiciousSemicolonChecker_ParamAfterElse, Boolean.FALSE);
    }
}

