/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator10;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.utilities.PluginUtils;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.logic.AbstractStartAndroidEmulatorLogic;
import org.eclipse.andmore.android.emulator.logic.ConnectVncLogic;
import org.eclipse.andmore.android.emulator.logic.ForwardVncPortLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.emulator.logic.StartEmulatorProcessLogic;
import org.eclipse.andmore.android.emulator.logic.StartVncServerLogic;
import org.eclipse.andmore.android.emulator.logic.TransferFilesLogic;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class StartAndroidEmulatorLogic
extends AbstractStartAndroidEmulatorLogic {
    @Override
    public Collection<IAndroidLogic> getLogicCollection(IAndroidLogicInstance instance, AbstractStartAndroidEmulatorLogic.LogicMode mode) {
        LinkedList<IAndroidLogic> logicCollection = new LinkedList<IAndroidLogic>();
        switch (mode) {
            case START_MODE: {
                logicCollection.add(new StartEmulatorProcessLogic());
                break;
            }
            case TRANSFER_AND_CONNECT_VNC: {
                logicCollection.add(this.createTransferFilesLogic());
                logicCollection.add(new ForwardVncPortLogic());
                StartVncServerLogic startVncServerLogic = this.createStartVncServerLogic();
                logicCollection.add(startVncServerLogic);
                logicCollection.add(this.getConnectVncClientLogic(startVncServerLogic));
                break;
            }
            case RESTART_VNC_SERVER: {
                logicCollection.add(this.createTransferFilesLogic());
                logicCollection.add(new ForwardVncPortLogic());
                logicCollection.add(this.createStartVncServerLogic());
            }
        }
        return logicCollection;
    }

    private String getResourceDir() {
        String resDir = "res";
        if (SdkUtils.isOphoneSDK()) {
            resDir = "res_OPhone";
        }
        return resDir;
    }

    protected IAndroidLogic createTransferFilesLogic() {
        File localDirParent = PluginUtils.getPluginInstallationPath((Plugin)EmulatorPlugin.getDefault());
        File localDir = new File(localDirParent, this.getResourceDir());
        TransferFilesLogic transferLogic = new TransferFilesLogic();
        transferLogic.setLocalDir(localDir.getAbsolutePath());
        transferLogic.setRemoteDir("/data/local");
        transferLogic.addFilename("fbvncserver");
        return transferLogic;
    }

    protected StartVncServerLogic createStartVncServerLogic() {
        StartVncServerLogic logic = new StartVncServerLogic();
        logic.addRemoteCommand("chmod 700 /data/local/fbvncserver");
        logic.addRemoteCommand("/data/local/fbvncserver");
        return logic;
    }

    protected IAndroidLogic getConnectVncClientLogic(StartVncServerLogic startVncServerLogic) {
        final ConnectVncLogic startVncClientLogic = new ConnectVncLogic();
        startVncServerLogic.addVncServerJobListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent ijobchangeevent) {
                startVncClientLogic.setVncServerDoneEvent(ijobchangeevent);
            }
        });
        return startVncClientLogic;
    }
}

