/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.perspective;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.ui.perspective.extension.AndroidPerspectiveExtensionBean;
import org.eclipse.andmore.android.emulator.ui.perspective.extension.AndroidPerspectiveExtensionReader;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.PartInitException;

public class AndroidEmulatorPerspective
implements IPerspectiveFactory {
    private static String LAUNCH_COOLBAR_SHORTCUT = "org.eclipse.debug.ui.launchActionSet";

    public void createInitialLayout(IPageLayout layout) {
        this.addEmulatorView(layout);
        this.addRunCoolbar(layout);
        this.createAndPopulateDynamicAreas(layout);
        layout.setEditorAreaVisible(false);
    }

    private void addEmulatorView(IPageLayout layout) {
        try {
            EclipseUtils.showView((String)"org.eclipse.andmore.android.emulator.androidView");
        }
        catch (PartInitException partInitException) {
            AndmoreLogger.error((String)"Unable to open Android Emulator View on Android Emulator Perspective.");
        }
        layout.addShowViewShortcut("org.eclipse.andmore.android.emulator.androidView");
        layout.addShowViewShortcut("org.eclipse.andmore.android.emulator.mainDisplayView");
    }

    private void addRunCoolbar(IPageLayout layout) {
        layout.addActionSet(LAUNCH_COOLBAR_SHORTCUT);
    }

    private void createAndPopulateDynamicAreas(IPageLayout layout) {
        Collection<AndroidPerspectiveExtensionBean> perspectiveExtensionBeans = AndroidPerspectiveExtensionReader.readAndroidPerspectiveExtensions();
        IFolderLayout devMgtArea = this.createDeviceMgtViewsArea(layout);
        TreeSet<String> emuAreaViewIds = new TreeSet<String>();
        for (AndroidPerspectiveExtensionBean extensionBean : perspectiveExtensionBeans) {
            if (AndroidPerspectiveExtensionBean.PerspectiveAreas.DEVICE_MANAGEMENT_VIEWS_AREA.equals((Object)extensionBean.getArea())) {
                devMgtArea.addView(extensionBean.getViewId());
                continue;
            }
            if (AndroidPerspectiveExtensionBean.PerspectiveAreas.EMULATION_VIEWS_AREA.equals((Object)extensionBean.getArea())) {
                emuAreaViewIds.add(extensionBean.getViewId());
                continue;
            }
            AndmoreLogger.warn((String)("View of id " + extensionBean.getViewId() + " could not be added to Android Emulator perspective"));
        }
        int numEmuViews = emuAreaViewIds.size();
        IFolderLayout[] emuAreaFolders = this.createEmuArea(layout, numEmuViews);
        int i = 0;
        for (String viewId : emuAreaViewIds) {
            emuAreaFolders[i % 3].addView(viewId);
            ++i;
        }
    }

    private IFolderLayout createDeviceMgtViewsArea(IPageLayout layout) {
        return layout.createFolder("devicemanagementviews", 1, 0.3f, "org.eclipse.ui.editorss");
    }

    private IFolderLayout[] createEmuArea(IPageLayout layout, int numEmuViews) {
        IFolderLayout[] emuAreaFolders = new IFolderLayout[3];
        int div = numEmuViews >= 3 ? 3 : (numEmuViews == 2 ? 2 : 1);
        float ratio = 1.0f / (float)div;
        emuAreaFolders[0] = layout.createFolder("emuAreaBottom", 4, ratio, "org.eclipse.ui.editorss");
        if (numEmuViews >= 2) {
            if (numEmuViews > 2) {
                ratio *= 2.0f;
            }
            emuAreaFolders[1] = layout.createFolder("emuAreaMiddle", 3, ratio, "emuAreaBottom");
        }
        if (numEmuViews >= 3) {
            emuAreaFolders[2] = layout.createFolder("emuAreaTop", 3, 0.5f, "emuAreaMiddle");
        }
        return emuAreaFolders;
    }
}

